<?php
/**
 * rep2expack - flock() x[X̔ėpbN
 */

// {{{ P2Lock

/**
 * ȈՃbNNX
 */
class P2Lock
{
    // {{{ properties

    /**
     * bNt@C̃pX
     *
     * @var string
     */
    protected $_filename;

    /**
     * bNt@C̃nh
     *
     * @var resource
     */
    protected $_fh;

    /**
     * bNt@Cō폜邩ǂ
     *
     * @var bool
     */
    protected $_remove;

    // }}}
    // {{{ constructor

    /**
     * RXgN^
     *
     * @param  string $name     bNirt@Cj
     * @param  bool   $remove   bNt@Cō폜邩ǂ
     * @param  string $suffix   bNt@C̐ڔ
     */
    public function __construct($name, $remove = true, $suffix = '.lck')
    {
        $this->_filename = p2_realpath($name . $suffix);
        $this->_remove = $remove;

        FileCtl::mkdirFor($this->_filename);

        $this->_fh = fopen($this->_filename, 'wb');
        if (!$this->_fh) {
            p2die("cannot create lockfile ({$this->_filename}).");
        }
        if (!flock($this->_fh, LOCK_EX)) {
            p2die("cannot get lock ({$this->_filename}).");
        }
    }

    // }}}
    // {{{ destructor

    /**
     * fXgN^
     */
    public function __destruct()
    {
        if (is_resource($this->_fh)) {
            flock($this->_fh, LOCK_UN);
            fclose($this->_fh);
            $this->_fh = null;
        }

        if ($this->_remove && file_exists($this->_filename)) {
            unlink($this->_filename);
        }
    }

    // }}}
    // {{{ free()

    /**
     * IɃbNJ
     */
    public function free()
    {
        $this->__destruct();
    }

    // }}}
    // {{{ remove()

    /**
     * IɃbNJAbNt@C폜
     *
     * unlink()stat()̃LbVIɃNÂ
     * clearstatcache()Kv͂Ȃ
     */
    public function remove()
    {
        $this->__destruct();
        if (file_exists($this->_filename)) {
            unlink($this->_filename);
        }
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
