﻿/**
 * $Revision$
 * $Date$
*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Diagnostics;
using System.Text;
using System.Windows.Forms;
using Lugens.Utils;

namespace Lugens.Components
{

    public enum IconListViewType
    {
        None,
        Alias,
        Command,
        Directory,
        File,
        Macro,
        Sentence,
        SysCommand
    }

    public class IconListViewItem : ListViewItem
    {
        public IconListViewItem() : base()
        {
        }

        public IconListViewItem(string text) : base(text)
        {
            this.Name = text;
        }

        private Icon icon;
        public Icon Icon
        {
            get { return this.icon; }
            set { this.icon = value; }
        }

        private IconListViewType type;
        public IconListViewType Type
        {
            get { return this.type; }
            set { this.type = value; }
        }
    }

    public partial class IconListView : ListView
    {
        private Image selectedBackgroundImage;
        public Image SelectedBackgroundImage
        {
            get { return selectedBackgroundImage; }
            set { this.selectedBackgroundImage = value; }
        }

        //表示されるアイテム数
        private int showItemCount;
        public int ShowItemCount
        {
            get { return showItemCount;}
        }

        public int ItemHeight
        {
            get { return this.Items.Count == 0 ? 20 : this.Items[0].Bounds.Height; }
        }

        public IconListView() : base()
        {
            InitializeComponent();
            this.SmallImageList = new ImageList();
            this.View = View.Details;
            this.OwnerDraw = true;
            this.Scrollable = true;
            this.FullRowSelect = true;
            this.MultiSelect = false;
            this.HeaderStyle = ColumnHeaderStyle.None;
            //this.selectedBackgroundImage = Properties.Resources.ImageSelect;
            this.DoubleBuffered = true;

            this.DrawItem += OnDrawItem;
            this.SizeChanged += OnSizeChanged;
            this.Columns.Add("");
            this.Columns[0].Width = this.ClientSize.Width;

            this.showItemCount = this.Items.Count == 0 || this.Items[0] == null ? 1 : this.ClientRectangle.Height / this.Items[0].Bounds.Height;
            this.Columns[0].Width = this.ClientSize.Width;
        }

        protected override void OnMouseMove(MouseEventArgs e)
        {
            this.Invalidate();
            base.OnMouseMove(e);
        }

        private void OnDrawItem(object sender, DrawListViewItemEventArgs e)
        {
            Rectangle srcRect = new Rectangle();
            Rectangle destRect = new Rectangle();
            IconListViewItem item = (IconListViewItem)e.Item;
            if (item.Selected)
            {
                srcRect.X = 0;
                srcRect.Y = 0;
                srcRect.Width = 3;
                srcRect.Height = this.selectedBackgroundImage.Height;
                destRect.X = e.Bounds.X;
                destRect.Y = e.Bounds.Y;
                destRect.Width = 3;
                destRect.Height = e.Bounds.Height;
                e.Graphics.DrawImage(this.selectedBackgroundImage, destRect, srcRect, GraphicsUnit.Pixel);

                srcRect.X = 3;
                srcRect.Y = 0;
                srcRect.Width = 1;
                srcRect.Height = this.selectedBackgroundImage.Height;
                destRect.X = e.Bounds.X + 3;
                destRect.Y = e.Bounds.Y;
                destRect.Width = e.Bounds.Width - 6;
                destRect.Height = e.Bounds.Height;
                e.Graphics.DrawImage(this.selectedBackgroundImage, destRect, srcRect, GraphicsUnit.Pixel);

                srcRect.X = 4;
                srcRect.Y = 0;
                srcRect.Width = 3;
                srcRect.Height = this.selectedBackgroundImage.Height;
                destRect.X = e.Bounds.Width - 3;
                destRect.Y = e.Bounds.Y;
                destRect.Width = 3;
                destRect.Height = e.Bounds.Height;
                e.Graphics.DrawImage(this.selectedBackgroundImage, destRect, srcRect, GraphicsUnit.Pixel);
            }
            else
            {
                SolidBrush brush = new SolidBrush(SystemColors.Window);
                //e.Graphics.FillRectangle(brush, e.Bounds);
                brush.Dispose();
            }

            if(item.Icon != null)
                e.Graphics.DrawIcon(item.Icon, new Rectangle(e.Bounds.X + 1, e.Bounds.Y/* + 2*/, 16, 16));

            destRect = new Rectangle(e.Bounds.X + 18,e.Bounds.Y/* + 1*/, e.Bounds.Width - 19, e.Bounds.Height/* - 2*/);
            //TextRenderer.DrawText(e.Graphics, item.Name, item.Font, destRect, SystemColors.WindowText, TextFormatFlags.Left);
            TextRenderer.DrawText(e.Graphics, item.Name, item.Font, new Point(e.Bounds.X + 18,e.Bounds.Y), SystemColors.WindowText);
        }

        private void OnSizeChanged(object sender, EventArgs e)
        {
            if (this.Visible)
            {
                this.showItemCount = this.Items.Count == 0 || this.Items[0] == null || this.Items[0].Index < 0 ? 1 : this.Size.Height / this.Items[0].Bounds.Height;
                this.DoClientSizeChange();
            }
        }

        public void DoClientSizeChange()
        {
            this.Columns[0].Width = this.ClientSize.Width;
        }

        protected override void OnVisibleChanged(EventArgs e)
        {
            this.DoClientSizeChange();
            base.OnVisibleChanged(e);
        }


        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
                case 0x115: //WM_VSCROLL
                    Win32.PostMessage(this.Parent.Handle, m.Msg, m.WParam, m.LParam);
                    break;
            }

            base.WndProc(ref m);
        }

    }
}
