/**
 * $Revision: 15 $
 * $Date: 2006-08-18 21:16:30 +0900 (金, 18 8 2006) $
*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using Lugens.Utils;

namespace Lugens.Components
{

    public partial class DropdownListForm : Form
    {
        public delegate void VisibleChangeDelegate(bool visible);

        public enum DrawMode { Text, IconText };
        
        /// <summary>
        /// 対になるテキストボックス
        /// </summary>
        private AutoCompleteTextBox parentTextBox;
        public AutoCompleteTextBox ParentTextBox { get { return this.parentTextBox; } set { this.parentTextBox = value; } }

        private DrawMode mode = DrawMode.Text;
        public DrawMode DrawType { get { return this.mode; } set { this.mode = value; } }

        public delegate Icon GetIconCallBack(string name);
        private GetIconCallBack iconCallBack = null;
        //private IconListView dropdownListView;
        private IconListBox dropdownListBox;
        //private IContainer components;

        public GetIconCallBack IconCallBack { get { return this.iconCallBack; } set { this.iconCallBack = value; } }
/*
        public IconListView DropdownListView
        {
            get
            {
                return dropdownListView;
            }
        }
*/
        public IconListBox DropdownListBox
        {
            get
            {
                return dropdownListBox;
            }
        }

        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }

        #region Windows フォーム デザイナで生成されたコード

        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.dropdownListBox = new Lugens.Components.IconListBox();
            this.SuspendLayout();
            // 
            // dropdownListBox
            // 
            this.dropdownListBox.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            this.dropdownListBox.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(186)));
            this.dropdownListBox.ItemHeight = 18;
            this.dropdownListBox.Location = new System.Drawing.Point(0, 0);
            this.dropdownListBox.Name = "dropdownListBox";
            this.dropdownListBox.PreSelectedBackgroundImage = global::Lugens.Components.Properties.Resources.preselect_7;
            this.dropdownListBox.SearchItemMode = false;
            this.dropdownListBox.SelectedBackgroundImage = global::Lugens.Components.Properties.Resources.select_7;
            this.dropdownListBox.Size = new System.Drawing.Size(121, 40);
            this.dropdownListBox.Status = 1;
            this.dropdownListBox.TabIndex = 2;
            this.dropdownListBox.ViewMode = Lugens.Components.ViewMode.IconText;
            this.dropdownListBox.MouseClick += new System.Windows.Forms.MouseEventHandler(this.dropdownListBox_MouseClick);
            this.dropdownListBox.DoubleClick += new System.EventHandler(this.dropdownListBox_DoubleClick);
            this.dropdownListBox.MouseDown += new System.Windows.Forms.MouseEventHandler(this.dropdownListBox_MouseDown);
            // 
            // DropdownListForm
            // 
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 12F);
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            this.BackColor = System.Drawing.SystemColors.Control;
            this.ClientSize = new System.Drawing.Size(133, 51);
            this.ControlBox = false;
            this.Controls.Add(this.dropdownListBox);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
            this.Name = "DropdownListForm";
            this.ShowIcon = false;
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
            this.SizeChanged += new System.EventHandler(this.DropdownListForm_SizeChanged);
            this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.DropdownListForm_KeyPress);
            this.ResumeLayout(false);

        }

        #endregion
        
        public DropdownListForm()
        {
            InitializeComponent();
        }

        private void DropdownListForm_Deactivate(object sender, EventArgs e)
        {
            this.Visible = false;
        }

        private void dropdownListBox_DoubleClick(object sender, EventArgs e)
        {
            //parentTextBox.Text = this.dropdownListView.Text;
            //parentTextBox.SelectionStart = parentTextBox.Text.Length;
            //this.Visible = false;
        }

        protected override bool IsInputKey(Keys keyData)
        {
            if (Keys.Tab == keyData)
                return true;
            return base.IsInputKey(keyData);
        }

        private void DropdownListForm_SizeChanged(object sender, EventArgs e)
        {
            this.dropdownListBox.Size = this.ClientSize;
            //this.dropdownListBox.DoClientSizeChange();
        }

        private void dropdownListBox_MouseClick(object sender, MouseEventArgs e)
        {
            this.parentTextBox.Focus();
        }

        private void dropdownListBox_MouseDown(object sender, MouseEventArgs e)
        {
            this.parentTextBox.Focus();
        }

        private void DropdownListForm_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = true;
        }

        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams cp = base.CreateParams;
                cp.Style |= (-2147483648);// | 0x00040000;
                cp.ClassStyle |= 0x00020000;
                cp.ExStyle |= Win32.WS_EX_NOACTIVATE;
                return cp;
            }
        }

        protected override bool ShowWithoutActivation
        {
            get
            {
                return true;
            }
        }

        public void DoVisibleChange(bool visible)
        {
            if (visible)
            {
                this.Opacity = this.parentTextBox.FindForm().Opacity;
                this.Visible = true;
            }
            else
                this.Visible = false;
        }

        public void RequestVisibleChange(bool visible)
        {
            Invoke(new VisibleChangeDelegate(DoVisibleChange), new object[] { visible });
        }

        private void dropdownListView_MouseUp(object sender, MouseEventArgs e)
        {
            this.parentTextBox.Focus();
        }

        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
                case 0x115: //WM_VSCROLL
                    if ((int)m.WParam == 8) //SB_ENDSCROLL
                        this.parentTextBox.Focus();
                    Win32.PostMessage(this.parentTextBox.Parent.Handle, m.Msg, m.WParam, m.LParam);
                    break;
            }
            base.WndProc(ref m);
        }
    }
}