﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO;

namespace Progressive.PecaStarter.Commons.Networks
{
    static class HttpWebRequestExtension
    {
        public static IAsyncResult BeginAccess(this HttpWebRequest webRequest, AsyncCallback callback, object state)
        {
            return webRequest.BeginGetResponse(callback, state);
        }

        public static void EndAccess(this HttpWebRequest webRequest, IAsyncResult asyncResult)
        {
            webRequest.EndGetResponse(asyncResult).Close();
        }

        public static IAsyncResult BeginGetText(this HttpWebRequest webRequest, AsyncCallback callback, object state)
        {
            return webRequest.BeginGetResponse(callback, state);
        }

        public static string EndGetText(this HttpWebRequest webRequest, IAsyncResult asyncResult)
        {
            using (var sr = new StreamReader(webRequest.EndGetResponse(asyncResult).GetResponseStream(), Encoding.UTF8))
            {
                return sr.ReadToEnd();
            }
        }
    }
}
