﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using Progressive.PecaStarter.Commons.Networks;

namespace Progressive.PecaStarter.Peercast4Net
{
    class Peercast4NetBase
    {
        private HttpWebRequest httpWebRequest;

        protected IAsyncResult BeginAccess(string address, AsyncCallback callback, object state)
        {
            if (httpWebRequest != null)
                throw new InvalidOperationException();

            httpWebRequest = (HttpWebRequest)HttpWebRequest.Create(address);
            return httpWebRequest.BeginAccess(callback, state);
        }

        protected void EndAccess(IAsyncResult asyncResult)
        {
            if (httpWebRequest == null)
                throw new InvalidOperationException();

            try
            {
                httpWebRequest.EndAccess(asyncResult);
            }
            finally
            {
                httpWebRequest = null;
            }
        }

        protected IAsyncResult BeginGetText(string address, AsyncCallback callback, object state)
        {
            if (httpWebRequest != null)
                throw new InvalidOperationException();

            httpWebRequest = (HttpWebRequest)HttpWebRequest.Create(address);
            return httpWebRequest.BeginGetText(callback, state);
        }

        protected string EndGetText(IAsyncResult asyncResult)
        {
            if (httpWebRequest == null)
                throw new InvalidOperationException();

            string result;
            try
            {
                result = httpWebRequest.EndGetText(asyncResult);
            }
            finally
            {
                httpWebRequest = null;
            }
            return result;
        }
    }
}
