﻿using System;
using System.Deployment.Application;
using System.IO;
using System.Text;

namespace Progressive.PecaStarter.Model
{
    public class ApplicationModel
    {
        public string ApplicationTitle
        {
            get
            {
                if (!ApplicationDeployment.IsNetworkDeployed)
                {
                    return "Peca Starter3 (Stand Alone)";
                }
                var version = ApplicationDeployment.CurrentDeployment.CurrentVersion;
                var sb = new StringBuilder("Peca Starter").Append(" ");
                sb.Append(version.Major.ToString()).Append('.');
                sb.Append(version.Minor.ToString()).Append('.');
                sb.Append(version.Build.ToString()).Append('.');
                sb.Append(version.Revision.ToString());
                return sb.ToString();
            }
        }

        public string DefaultLogFolder
        {
            get { return Environment.GetFolderPath(Environment.SpecialFolder.Personal) + Path.DirectorySeparatorChar + "PeercastLog"; }
        }
    }
}
