﻿using System.Collections.Generic;
using System.ComponentModel;

namespace Progressive.PecaStarter.ViewModel
{
    public class ViewModelBase : INotifyPropertyChanged
    {
        private const int MAX_HISTORY = 50;

        #region INotifyPropertyChanged メンバ

        public event PropertyChangedEventHandler PropertyChanged;

        #endregion

        public void NotifyPropertyChanged(string info)
        {
            if (this.PropertyChanged != null)
            {
                this.PropertyChanged(this, new PropertyChangedEventArgs(info));
            }
        }

        protected List<string> CreateAddedList(List<string> source, string value)
        {
            var list = new List<string>(MAX_HISTORY);
            list.Add(value);
            for (int i = 0, len = source.Count; i < len; i++)
            {
                var item = source[i];
                if (i == 0 && (value.IndexOf(item) == 0))
                {
                    continue;
                }
                if (list.Count >= MAX_HISTORY)
                {
                    break;
                }
                if (value == item)
                {
                    continue;
                }
                list.Add(item);
            }
            return list;
        }
    }
}
