﻿using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Xml.Serialization;
using Progressive.PecaStarter.Model;
using Progressive.PecaStarter.Entity;

namespace Progressive.PecaStarter.DAO
{
    public class WebApiDAO
    {
        public webapi[] Select()
        {
            string targetDirectory = Path.GetDirectoryName(Assembly.GetEntryAssembly().Location) + Path.DirectorySeparatorChar + "yellowpages2";
            if (!Directory.Exists(targetDirectory))
            {
                Directory.CreateDirectory(targetDirectory);
            }
            var webApis = new List<webapi>();
            var xs = new XmlSerializer(typeof(webapi));
            foreach (var file in Directory.GetFiles(targetDirectory))
            {
                webApis.Add(xs.Deserialize(new FileStream(file, FileMode.Open)) as webapi);
            }
            return webApis.ToArray();
        }
    }
}
