﻿using Progressive.PecaStarter.DTO;
using Progressive.PecaStarter.ViewModel.Command;

namespace Progressive.PecaStarter.ViewModel
{
    public class RelaySelectDialogViewModel : ViewModelBase
    {
        public ChannelDTO[] BroadcastChannels
        {
            get { return broadcastChannels; }
            set
            {
                broadcastChannels = value;
                NotifyPropertyChanged("BroadcastChannels");
            }
        }
        public ChannelDTO SelectedChannel
        {
            get { return selectedChannel; }
            set
            {
                selectedChannel = value;
                ImportChannelCommand.NotifyCanExecuteChanged();
                NotifyPropertyChanged("SelectedChannel");
            }
        }
        public ImportChannelCommand ImportChannelCommand { get; private set; }
        private BroadcastViewModel Parent;
        private ChannelDTO[] broadcastChannels;
        private ChannelDTO selectedChannel;

        public RelaySelectDialogViewModel(BroadcastViewModel parent)
        {
            ImportChannelCommand = new ImportChannelCommand(parent);
            Parent = parent;
            broadcastChannels = null;
            selectedChannel = null;
        }
    }
}
