﻿using System;
using System.Windows;

namespace Progressive.PecaStarter.View.WPF
{
    class TaskTrayIconManager : IDisposable
    {
        private TaskTrayIcon TaskTrayIcon;
        private Window Root;

        public TaskTrayIconManager(Window root)
        {
            Root = root;
        }
        ~TaskTrayIconManager()
        {
            Dispose();
        }

        public void Create()
        {
            if (TaskTrayIcon == null)
            {
                TaskTrayIcon = new TaskTrayIcon(Root);
                TaskTrayIcon.Icon = Progressive.PecaStarter.Properties.Resources.icon;
                TaskTrayIcon.Text = Root.Title;
                TaskTrayIcon.BalloonTipText = "";
                TaskTrayIcon.BalloonTipTitle = Root.Title;
            }
        }
        public void Dispose()
        {
            if (TaskTrayIcon != null)
            {
                TaskTrayIcon.Dispose();
                TaskTrayIcon = null;
            }
        }
    }
}
