﻿using System;
using System.Collections.Generic;
using CreteLib;

namespace Progressive.PecaStarter.Model.Peercast
{
    using Parameter = KeyValuePair<string, string>;

    class SettingsHtml
    {
        private HtmlDocument html;

        public SettingsHtml(string source)
        {
            html = new HtmlDocument();
            html.LoadHtml(source, true);
        }

        public List<Parameter> Parameters
        {
            get
            {
                return html.GetNodesByTagName("form")[0].GetParameters();
            }
        }
    }
    static class ExtensionsOnSettingsHtml
    {
        static public List<Parameter> GetParameters(this HtmlNode form)
        {
            var dictionary = new List<Parameter>();
            foreach (HtmlNode node in form.ChildNodes)
            {
                if ("input".EqualsIgnoreCase(node.TagName))
                {
                    dictionary.AddFromInputNode(node);
                    continue;
                }
                if ("select".EqualsIgnoreCase(node.TagName))
                {
                    dictionary.AddFromSelectNode(node);
                    continue;
                }
                dictionary.AddAll(node.GetParameters());
            }
            return dictionary;
        }

        static private void AddFromSelectNode(this List<Parameter> list, HtmlNode node)
        {
            string value = "";
            foreach (HtmlNode option in node.ChildNodes)
            {
                if (option.Attributes.ContainsKey("selected"))
                {
                    value = option.Attributes["value"];
                    break;
                }
            }
            list.Add(new Parameter(node.Attributes["name"], value));
        }

        static private void AddFromInputNode(this List<Parameter> list, HtmlNode node)
        {
            if (!node.Attributes.ContainsKey("type"))
            {
                list.AddParameter(node);
                return;
            }
            var type = node.Attributes["type"];
            if (!"radio".EqualsIgnoreCase(type) && !"checkbox".EqualsIgnoreCase(type))
            {
                list.AddParameter(node);
                return;
            }
            if (node.Attributes.ContainsKey("checked"))
            {
                list.AddParameter(node);
                return;
            }
        }

        static private void AddParameter(this List<Parameter> List, HtmlNode node)
        {
            if (!node.Attributes.ContainsKey("value"))
            {
                List.Add(new Parameter(node.Attributes["name"], ""));
                return;
            }
            List.Add(new Parameter(node.Attributes["name"], node.Attributes["value"].Replace(' ', '+')));
        }

        static private bool EqualsIgnoreCase(this string source, string target)
        {
            return source.Equals(target, StringComparison.OrdinalIgnoreCase);
        }

        static private void AddAll(this List<Parameter> t, List<Parameter> source)
        {
            foreach (var kv in source)
            {
                t.Add(kv);
            }
        }
    }
}
