﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Linq;

namespace Progressive.PecaStarter.Model
{
    public class YellowPages
    {
        public string Prefix
        {
            get
            {
                StringBuilder sb = new StringBuilder();
                foreach (var option in Options)
                {
                    sb.Append(option.ToString());
                }
                return sb.ToString();
            }
        }
        public string Name { get; set; }
        public string Host { get; set; }
        public string Notice { get; set; }
        public Option[] Options { get; set; }

        public YellowPages()
        {
            Name = "";
            Host = "";
            Notice = "";
            Options = new Option[] { };
        }

        public string ParseGenre(string value)
        {
            var sr = new Util.Tokenizer(value);
            foreach (var option in Options)
            {
                if (option is YellowPages.HiddenOption)
                {
                    if (!sr.TryOverTo(option.Sign))
                    {
                        break;
                    }
                    continue;
                }
                if (option is YellowPages.CheckOption)
                {
                    if (!sr.TryOverTo(option.Sign))
                    {
                        (option as YellowPages.CheckOption).IsChecked = false;
                        continue;
                    }
                    (option as YellowPages.CheckOption).IsChecked = true;
                    continue;
                }
                if (option is YellowPages.ComboOption)
                {
                    var comboOption = option as YellowPages.ComboOption;
                    for (var i = comboOption.ComboItems.Length - 1; 0 <= i; i--)
                    {
                        var item = comboOption.ComboItems[i];
                        if ("" == item.Sign)
                        {
                            continue;
                        }
                        if (!sr.TryOverTo(item.Sign))
                        {
                            continue;
                        }
                        comboOption.Value = item.Sign;
                        break;
                    }
                    continue;
                }
                if (option is YellowPages.TextOption)
                {
                    (option as YellowPages.TextOption).Value = sr.ReadToSign(option.Sign);
                    continue;
                }
            }
            return sr.ReadToEnd();
        }

        public abstract class Option
        {
            public string Name { get; set; }
            public string Sign { get; set; }

            public Option()
            {
                Name = "";
                Sign = "";
            }

            public override string ToString()
            {
                return "";
            }
        }

        public class HiddenOption : Option
        {
            public HiddenOption()
                : base()
            {
            }

            public override string ToString()
            {
                return Sign;
            }
        }

        public class TextOption : Option
        {
            public string Value { get; set; }

            public TextOption()
                : base()
            {
                Value = "";
            }

            public override string ToString()
            {
                return Value.Length == 0 ? "" : Value + Sign;
            }
        }

        public class CheckOption : Option
        {
            public bool IsChecked { get; set; }

            public CheckOption()
                : base()
            {
                IsChecked = false;
            }

            public override string ToString()
            {
                return IsChecked ? Sign : "";
            }
        }

        public class ComboOption : Option
        {
            public ComboOptionItem[] ComboItems { get; set; }
            public string Value { get; set; }

            public ComboOption()
                : base()
            {
                ComboItems = new ComboOptionItem[] { };
                Value = "";
            }

            public override string ToString()
            {
                return Value;
            }
        }

        public class ComboOptionItem
        {
            public string Name { get; set; }
            public string Sign { get; set; }

            public ComboOptionItem()
            {
                Name = "";
                Sign = "";
            }
        }
    }
}
