﻿using Progressive.PecaStarter.Model;
using Progressive.PecaStarter.Service;

namespace Progressive.PecaStarter.ViewModel.Broadcast
{
    public class YellowPagesViewModel : ViewModelBase
    {
        public BroadcastViewModel Parent { get; set; }
        public bool IsBroadcast
        {
            get { return Parent.IsBroadcast; }
        }
        public YellowPages SelectedYellowPages
        {
            get { return yellowPageses[selectedIndex]; }
        }
        public YellowPages[] YellowPageses
        {
            get { return yellowPageses; }
            set
            {
                yellowPageses = value;
                NotifyPropertyChanged("YellowPageses");
            }
        }
        public uint SelectedIndex
        {
            get { return selectedIndex; }
            set
            {
                selectedIndex = value;
                NotifyPropertyChanged("SelectedIndex");
            }
        }
        private YellowPages[] yellowPageses;
        private uint selectedIndex;

        public YellowPagesViewModel(BroadcastViewModel parent)
        {
            Parent = parent;
            yellowPageses = new YellowPagesService().CreateYellowPagesSites();
            selectedIndex = 0;
        }

        public string ParseGenre(string value)
        {
            for (int i = 0, len = yellowPageses.Length; i < len; i++)
            {
                if (yellowPageses[i].Options[0] is YellowPages.HiddenOption == false)
                {
                    continue;
                }
                if (value.IndexOf(yellowPageses[i].Options[0].Sign) != 0)
                {
                    continue;
                }
                selectedIndex = (uint)i;
                break;
            }
            if (selectedIndex < 0)
            {
                return value;
            }
            return yellowPageses[selectedIndex].ParseGenre(value);
        }
    }
}
