﻿using System;
using Progressive.PecaStarter.Service;

namespace Progressive.PecaStarter.ViewModel.Command
{
    class GetRelaysCommand : AsyncCommandBase
    {
        public GetRelaysCommand(BroadcastViewModel viewModel) : base(viewModel) { }

        protected override object AsyncExecute(object parameter)
        {
            ViewModel.RelaySelectDialogViewModel.BroadcastChannels = new PeercastService().GetBroadcastChannels(ViewModel.SettingsViewModel.ServerAddress);
            return null;
        }

        public override bool CanExecute(object parameter)
        {
            return true;
        }
    }
}
