
var X_Audio_WebAudio_context = !X_UA[ 'iPhone_4s' ]  && !X_UA[ 'iPad_2Mini1' ]  && !X_UA[ 'iPod_4' ]  &&
								!( X_UA[ 'Gecko' ] && X_UA[ 'Android' ] ) &&
								( window.AudioContext || window.webkitAudioContext ),
	X_Audio_BUFFER_LIST      = [],
	X_Audio_WebAudioWrapper,
	X_Audio_BufferLoader;

/*
 * iPhone 4s 以下、iPad2以下、iPad mini 1以下, iPod touch 4G 以下は不可
 */
if( X_Audio_WebAudio_context ){
	
	X_Audio_WebAudio_context = new X_Audio_WebAudio_context;
	
	X_Audio_BufferLoader = X_EventDispatcher[ 'inherits' ](
		'X.AV.WebAudioBufferLoader',
		X_Class.POOL_OBJECT,
		{
			url             : '',
            xhr             : null,
            onDecodeSuccess : null,
            onDecodeError   : null,
            
            buffer          : null,
            error           : 0,
            webAudioList    : null,
            
			Constructor : function( webAudio, url ){
				this.webAudioList = [ webAudio ];
				this.url = url;
				this.xhr = X.Net( { 'xhr' : url, 'dataType' : 'arraybuffer' } )
									[ 'listen' ]( X_EVENT_PROGRESS, this )
									[ 'listenOnce' ]( [ X_EVENT_SUCCESS, X_EVENT_COMPLETE ], this );
			},
			
			handleEvent : function( e ){
				switch( e.type ){
					case X_EVENT_PROGRESS :
						this[ 'dispatch' ]( { type : 'progress', 'percent' : e[ 'percent' ] } );
						return;
					
					case X_EVENT_SUCCESS :
					// TODO 旧api
					// https://developer.mozilla.org/en-US/docs/Web/API/Web_Audio_API/Porting_webkitAudioContext_code_to_standards_based_AudioContext
					
					// http://qiita.com/sou/items/5688d4e7d3a37b4e2ff1
					// iOS 7.1 で decodeAudioData に処理が入った瞬間にスクリーンを長押しする（スクロールを繰り返す）と
					// decoeAudioData の処理がキャンセルされることがある（エラーやコールバックの発火もなく、ただ処理が消滅する）。
					// ただし iOS 8.1.2 では エラーになる
						if( X_Audio_WebAudio_context.createBuffer && X_UA[ 'iOS' ] < 8 ){
							this._onDecodeSuccess( X_Audio_WebAudio_context.createBuffer( e.response, false ) );
						} else
						if( X_Audio_WebAudio_context.decodeAudioData ){
							X_Audio_WebAudio_context.decodeAudioData( e.response,
								this.onDecodeSuccess = X_Callback_create( this, this._onDecodeSuccess ),
								this.onDecodeError   = X_Callback_create( this, this._onDecodeError ) );
						} else {
							this._onDecodeSuccess( X_Audio_WebAudio_context.createBuffer( e.response, false ) );
						};
						break;

					case X_EVENT_COMPLETE :
						this.error = 1;				
						this[ 'asyncDispatch' ]( X_EVENT_COMPLETE );
						break;
				};
				this.xhr[ 'unlisten' ]( [ X_EVENT_PROGRESS, X_EVENT_SUCCESS, X_EVENT_COMPLETE ], this );
				delete this.xhr;
			},
			
				_onDecodeSuccess : function( buffer ){
					console.log( 'WebAudio decode success!' );
					
					this.onDecodeSuccess && this._onDecodeComplete();
					
	                if ( !buffer ) {
	                	this.error = 2;
	                    this[ 'asyncDispatch' ]( X_EVENT_COMPLETE );
	                    return;
	                };
	
	                this.buffer   = buffer;

					this[ 'asyncDispatch' ]( X_EVENT_COMPLETE );

	                console.log( 'WebAudio decoded!' );
				},
				
				_onDecodeError : function(){
					console.log( 'WebAudio decode error!' );
					this._onDecodeComplete();
					this.error = 2;
					this[ 'asyncDispatch' ]( X_EVENT_COMPLETE );
				},
				
				_onDecodeComplete : function(){
					X_Callback_correct( this.onDecodeSuccess );
					delete this.onDecodeSuccess;
					X_Callback_correct( this.onDecodeError );
					delete this.onDecodeError;
				},
			
			unregister : function( webAudio ){
				var list = this.webAudioList,
					i    = list.indexOf( webAudio );
				if( 0 < i ){
					list.splice( i, 1 );
					if( list.length ){
						this.xhr && this.xhr[ 'kill' ]();
						this[ 'kill' ]();
					};
				};
			}
			
		}
	);
	
	
	X_Audio_WebAudioWrapper = X_Audio_AbstractAudioBackend[ 'inherits' ](
		'X.AV.WebAudioWrapper',
		X_Class.POOL_OBJECT,
		{
			
			loader          : null,
						
			_startPos       : 0,
			_endPosition    : 0,
			_startTime      : 0,
            _timerID        : 0,
            _interval       : 0,
          	buffer          : null,
          	source          : null,
            gainNode        : null,
            _onended        : null,
            
			Constructor : function( target, url, option ){				
				var i = 0,
					l = X_Audio_BUFFER_LIST.length,
					loader;

				for( ; i < l; ++i ){
					loader = X_Audio_BUFFER_LIST[ i ];
					if( loader.url === url ){
						this.loader = loader;
						loader.webAudioList.push( this );
						break;
					};
				};
				
				if( !this.loader ){
					this.loader = loader = new X_Audio_BufferLoader( this, url );
				};
				
				this.target  = target || this;
				
				this.setState( option );
				
				this[ 'listenOnce' ]( X_EVENT_KILL_INSTANCE, this.onKill );
				
				if( loader.buffer || loader.error ){
					this._onLoadBufferComplete();
				} else {
					loader[ 'listenOnce' ]( X_EVENT_COMPLETE, this, this._onLoadBufferComplete );
				};
			},
			
			onKill : function(){
				this.loader[ 'unlisten' ]( X_EVENT_COMPLETE, this, this._onLoadBufferComplete )
					.unregister( this );

				delete this.buffer;
				
				this.playing  && this.actualPause();
	            this.source   && this._sourceDispose();
	
	            this._onended && X_Callback_correct( this._onended );	
	
	            this.gainNode && this.gainNode.disconnect();
			},
				_onLoadBufferComplete : function( e ){
					var loader = this.loader,
						buffer = loader.buffer;
					
					e && loader[ 'unlisten' ]( X_EVENT_COMPLETE, this, this._onLoadBufferComplete );
					
	                if ( !buffer ) {
	                	this.error = loader.error;
	                	
	                    this.target[ 'dispatch' ]({
								type    : X_EVENT_ERROR,
								error   : loader.error,
								message : loader.error === 1 ?
											'load buffer network error' :
											'buffer decode error'
							});
						this[ 'kill' ]();
	                    return;
	                };
	
	                this.buffer   = buffer;
	                this.duration = buffer.duration * 1000;

					this.target[ 'asyncDispatch' ]( X_EVENT_READY );
	                
	                this.autoplay && X_Timer_once( 16, this, this.play );
					
				},
			
			actualPlay : function(){
				var begin, end;
				
	            if( !this.buffer ){
	            	this.autoplay = true;
	            	return;
	            };
				
				end   = X_AudioWrapper_getEndTime( this );
				begin = X_AudioWrapper_getStartTime( this, end, true );
				
				console.log( '[WebAudio] play ' + begin + ' -> ' + end );
				
				if( this.source ) this._sourceDispose();
				if( !this.gainNode ){
					this.gainNode = X_Audio_WebAudio_context.createGain ? X_Audio_WebAudio_context.createGain() : X_Audio_WebAudio_context.createGainNode();
	            	this.gainNode.connect( X_Audio_WebAudio_context.destination );
				};
	            this.source        = X_Audio_WebAudio_context.createBufferSource();
	            this.source.buffer = this.buffer;
	            this.source.connect( this.gainNode );
	            
	            this.gainNode.gain.value = this.gain;
	            
	            // おかしい、stop 前に外していても呼ばれる、、、@Firefox33.1
	            // 破棄された X.Callback が呼ばれて、obj.proxy() でエラーになる。Firefox では、onended は使わない
                if( false && this.source.onended !== undefined ){
                	//console.log( '> use onended' );
                	this.source.onended = this._onended || ( this._onended = X_Callback_create( this, this._onEnded ) );
                } else {
                	this._timerID && X_Timer_remove( this._timerID );
					this._timerID = X_Timer_once( end - begin, this, this._onEnded );
                };
	
	            if( this.source.start ){
	                this.source.start( 0, begin / 1000, end / 1000 );
	            } else {
	                this.source.noteGrainOn( 0, begin / 1000, end / 1000 );
	            };
	            
	            this.playing      = true;
	            this._startPos    = begin;
	            this._endPosition = end;
	            this._startTime   = X_Audio_WebAudio_context.currentTime * 1000;
	            this._interval    = this._interval || X_Timer_add( 1000, 0, this, this._onInterval );
			},
			
				_sourceDispose : function(){
		            this.source.disconnect();
		            delete this.source.onended;
		            delete this.source;
		        },

				_onInterval : function(){
					if( !this.playing ){
						delete this._interval;
						return X_Callback_UN_LISTEN;
					};
					this.target[ 'dispatch' ]( X_EVENT_MEDIA_PLAYING );
				},
						
				_onEnded : function(){
					var time;
					delete this._timerID;
					
		            if( this.playing ){
		            	time = X_Audio_WebAudio_context.currentTime * 1000 - this._startTime - this._endPosition + this._startPos | 0;
		            	//console.log( '> onEnd ' + ( this.playing && ( X_Audio_WebAudio_context.currentTime * 1000 - this._startTime ) ) + ' < ' + ( this._endPosition - this._startPos ) );
		            	if( this._onended ){
			            	// Firefox 用の対策,,,
			            	if( time < 0 ) return;
		            	} else {
		            		if( time < 0 ){
		            			console.log( '> onEnd crt:' + ( X_Audio_WebAudio_context.currentTime * 1000 ) + ' startTime:' + this._startTime +
		            				' from:' + this._startPos + ' to:' + this._endPosition );
		            			this._timerID = X_Timer_once( -time, this, this._onEnded );
		            			return;
		            		};
		            	};
		            	
		            	if( this.autoLoop ){
		            		if( !( this.target[ 'dispatch' ]( X_EVENT_MEDIA_BEFORE_LOOP ) & X_Callback_PREVENT_DEFAULT ) ){
		            			this.looped = true;
		            			this.target[ 'dispatch' ]( X_EVENT_MEDIA_LOOPED );
		            			this.actualPlay();
			            	};
		            	} else {
		            		this.actualPause();
		            		this.target[ 'dispatch' ]( X_EVENT_MEDIA_ENDED );
		            	};
		            };
				},
			
			actualPause : function(){
				if( !this.playing ) return this;
				
				console.log( '[WebAudio] pause' );
				
				this.seekTime = this.getActualCurrentTime();
				
	            this._timerID && X_Timer_remove( this._timerID );
				delete this._timerID;
				delete this.playing;

	            if( this.source ){
	            	if( this.source.onended ) delete this.source.onended;
	            	
	                this.source.stop ? 
	                	this.source.stop( 0 ) : this.source.noteOff( 0 );
	            };
			},
			
			getActualCurrentTime : function(){
				return X_Audio_WebAudio_context.currentTime * 1000 - this._startTime + this._startPos | 0;
			},
			
			afterUpdateState : function( result ){
				if( result & 2 || result & 1 ){ // seek
	            	this.actualPlay();
				} else
				if( result & 4 ){
	               this.gainNode.gain.value = this.gain;
				};
			}

		}
	);

	/*
	 * http://qiita.com/sou/items/5688d4e7d3a37b4e2ff1
	 * L-01F 等の一部端末で Web Audio API の再生結果に特定条件下でノイズが混ざることがある。
	 * 描画レート（描画 FPS）が下がるとノイズが混ざり始め、レートを上げると再生結果が正常になるというもので、オーディオ処理が描画スレッドに巻き込まれているような動作を見せる。
	 */
	if( X_UA[ 'Android' ] && X_UA[ 'Chrome' ] ){
		X_Node_systemNode.create( 'div', { id : 'fps-slowdown-make-sound-noisy' } );
	};

	X_Audio_BACKENDS.push(
		{
			backendName : 'Web Audio',

			// 
			detect : function( proxy, source, ext ){
				proxy[ 'asyncDispatch' ]( { type : X_EVENT_COMPLETE, canPlay : X_Audio_codecs[ ext ] } );
			},
			
			klass : X_Audio_WebAudioWrapper
		}
	);
};
