
/*
 * http://uupaa.hatenablog.com/entry/2011/12/12/213233
 * Mobile Opera11 は Audio をサポートするがイベントが取れない
 * iframe 内で生成して、Audio Sprite の preset で再生できないか？
 */
var X_Audio_Sprite_shouldUse        = window.HTMLAudioElement && ( X_UA[ 'iOS' ] || X_UA[ 'AndroidBrowser' ] || X_UA[ 'OperaMobile' ] || X_UA[ 'OperaTablet' ] ), // Flash がない
	X_Audio_Sprite_useVideoForMulti = 4 <= X_UA[ 'AndroidBrowser' ] && 534.3 < X_UA[ 'AndroidWebkit' ], // ドスパラパッドはビデオのインライン再生が不可 
	X_Audio_Sprite_needTouchAndroid = X_Audio_Sprite_useVideoForMulti,	
	X_Audio_Sprite_needTouchFirst   = X_UA[ 'iOS' ] || X_Audio_Sprite_needTouchAndroid || ( X_UA[ 'WinPhone' ] && X_UA[ 'IE9' ] ),
	X_Audio_Sprite_enableMultiTrack = !( X_UA[ 'iOS' ] && !X_Audio_WebAudio_context ) && !( X_UA[ 'AndroidBrowser4' ] && X_UA[ 'AndroidWebkit' ] <= 534.3 ) && !( X_UA[ 'WinPhone' ] && X_UA[ 'IE9' ] ),
	X_Audio_Sprite_enableVolume     = window.HTMLAudioElement && ( !X_UA[ 'iOS' ] && !X_UA[ 'AndroidBrowser' ] && !X_UA[ 'OperaMobile' ] && !X_UA[ 'OperaTablet' ] ), // TODO fennec は　25以上
	X_Audio_Sprite_maxTracks        = !X_Audio_Sprite_enableMultiTrack ? 1 : X_Audio_Sprite_useVideoForMulti ? 2 : 9,
	X_Audio_Sprite_lengthSilence    = 10000, // 一番最初の無音部分の長さ
	X_Audio_Sprite_lengthDistance   = 5000,  // 音間の無音の長さ
	X_Audio_Sprite_uid              = 0,
	X_Audio_Sprite_members          = {},
	X_Audio_Sprite_TEMP             = {
		presets     : {},
		BGMs        : {},
		tracks      : [],
		pauseTracks : [], // X_EVENT_DEACTIVATE によって pause した再生中のトラックたち。
		volume      : 1,
		bgmTrack    : null,
		bgmPosition : 0,
		bgmName     : '',
		bgmLooped   : false,
		bgmPlaying  : false
	},
	X_Audio_Sprite_instance,
	X_Audio_Sprite_numTracks,
	X_Audio_Sprite_useVideo;

X[ 'AudioSprite' ] = function( setting ){
	var tracks  = X_Audio_Sprite_TEMP.tracks,
		bgms    = X_Audio_Sprite_TEMP.BGMs,
		presets = X_Audio_Sprite_TEMP.presets,
		urls    = setting[ 'urls' ],
		video   = setting[ 'useVideo' ],
		n       = video ? 1 : setting[ 'numTracks' ] || 1,
		option  = {
			volume    : setting[ 'volume' ] || 0.5,
			autoplay  : false,
			startTime : 0,
			endTime   : X_Audio_Sprite_lengthSilence,
			loop      : true
		},
		k, i, v, track;	
	
	if( X_Audio_Sprite_instance ){
		X_Audio_Sprite_instance[ 'kill' ]();
	} else {
		X_Audio_Sprite_instance = X_Class_override( X_EventDispatcher(), X_Audio_Sprite_members );
		X_ViewPort[ 'listen' ]( [ X_EVENT_VIEW_ACTIVATE, X_EVENT_VIEW_DEACTIVATE ], X_Audio_Sprite_instance, X_Audio_Sprite_handleEvent );
	};
	
	n = n <= X_Audio_Sprite_maxTracks ? n : X_Audio_Sprite_maxTracks;
	
	for( k in setting ){
		v = setting[ k ];
		if( X_Type_isArray( v ) && v !== urls ){
			v = X_Object_cloneArray( v );
			for( i = v.length; i; ){
				--i;
				if( i !== 2 ) v[ i ] = X_AudioWrapper_timeStringToNumber( v[ i ] );
			};					
			if( v[ 2 ] ) bgms[ k ] = v;
			presets[ k ] = v;
		};
	};
	
	X_Audio_startDetectionBackend( X_Audio_BACKENDS[ 0 ], X_Audio_Sprite_instance, X_Object_cloneArray( urls ), option );

	X_Audio_Sprite_instance[ 'listenOnce' ]( [ X_EVENT_BACKEND_READY, X_EVENT_BACKEND_NONE ], X_AudioSprite_backendHandler );
	X_Audio_Sprite_instance[ 'listenOnce' ]( X_EVENT_KILL_INSTANCE, X_Audio_Sprite_handleEvent );
	
	X_Audio_Sprite_useVideo  = video;
	X_Audio_Sprite_numTracks = X_Audio_Sprite_instance[ 'numTracks' ] = n;

	return X_Audio_Sprite_instance;
};

X[ 'AudioSprite' ][ 'shouldUse'        ] = X_Audio_Sprite_shouldUse;
X[ 'AudioSprite' ][ 'needTouchFirst'   ] = X_Audio_Sprite_needTouchFirst;
X[ 'AudioSprite' ][ 'enableMultiTrack' ] = X_Audio_Sprite_enableMultiTrack;

// 再生が終わっているもの、終わりかけのものを探す
// TODO 終わりかけのもの、と一番古いもの、どちらを再利用するか？これ以上に細かい実装を望む場合は X.Audio.Sprite は使わず自力で実装
function X_Audio_Sprite_getTrackEnded(){
	var tracks  = X_Audio_Sprite_TEMP.tracks,
		l = tracks.length,
		i = 0, track, state, last = 1 / 0, _last, index;
	
	for( ; i < l; ++i ){
		track = tracks[ i ];
		state = track.getState();
		if( !state.playing ) return track;
		if( track === X_Audio_Sprite_TEMP.bgmTrack ) continue;
		if( state.currentTime <= X_Audio_Sprite_lengthSilence + X_Audio_Sprite_lengthDistance ) return track;
		_last = state.endTime - state.currentTime;
		if( _last < last ){
			last  = _last;
			index = i;
		};
	};
	return tracks[ index ];
};

/*
 * {
 * 	 urls      : [ 'xx.ogg', 'xx.mp3' ],
 * 	 numTracks : 3,
 *   useVideo  : false,
 *   volume    : 1,
 * 	 BGM_01 : [ '15.00', '45.500', true, '17.666', '50.999' ],
 *   BGM_02 : [ '56.00', '1:15.230', true ]
 * }
 * 
 * X_EVENT_BACKEND_READY
 * X_EVENT_BACKEND_NONE
 * 
 * X_EVENT_READY
 * X_EVENT_MEDIA_LOOPED
 * X_EVENT_MEDIA_ENDED
 * 
 */

X_Audio_Sprite_members = {
		
		'numTracks' : 0,
		
		'load' : function(){
			var tracks = X_Audio_Sprite_TEMP.tracks,
				i = 0, l = tracks.length;
			for( ; i < l; ++i ){
				if( X_UA[ 'WinPhone' ] ){
					console.log( 'WinPhone : touch -> play()' );
					//tracks[ i ].play( 0, X_Audio_Sprite_lengthSilence, true, 0, X_Audio_Sprite_lengthSilence ).seek( 0 );
					this[ 'pause' ]( i );
				} else {
					tracks[ i ][ '_rawObject' ].load();
				};
			};
		},
		
		/*
		 * @return uid Number
		 */
		'play' : function( name ){
			var bgm     = X_Audio_Sprite_TEMP.bgmTrack,
				tracks  = X_Audio_Sprite_TEMP.tracks,
				bgms    = X_Audio_Sprite_TEMP.BGMs,
				presets = X_Audio_Sprite_TEMP.presets,
				preset  = presets[ name ],
				track, i, k;
			
			if( preset ){
				if( bgms[ name ] ){
					if( name !== X_Audio_Sprite_TEMP.bgmName ){
						// bgm変更
						X_Audio_Sprite_TEMP.bgmName     = name;
						X_Audio_Sprite_TEMP.bgmPosition = preset[ 0 ];
						X_Audio_Sprite_TEMP.bgmLooped   = false;
					};
					
					X_Audio_Sprite_TEMP.bgmPlaying = true;
					
					if( bgm ){
						track = bgm;
					} else
					if( 1 < tracks.length ){
						track = X_Audio_Sprite_TEMP.bgmTrack = X_Audio_Sprite_getTrackEnded();
					} else {
						track = X_Audio_Sprite_TEMP.bgmTrack = tracks[ 0 ];
					};
					
					if( track[ 'listen' ]( [ X_EVENT_MEDIA_PLAYING, X_EVENT_MEDIA_BEFORE_LOOP ], this, X_Audio_Sprite_handleEvent ).playing ){
						track.setState({
								'loop'          : true,
								'looped'        : X_Audio_Sprite_TEMP.bgmLooped,
								'currentTime'   : X_Audio_Sprite_TEMP.bgmPosition,
								'startTime'     : preset[ 0 ],
								'endTime'       : preset[ 1 ],
								'loopStartTime' : preset[ 3 ],
								'loopEndTime'   : preset[ 4 ]
							});
					} else {
						track.setState( { 'looped' : X_Audio_Sprite_TEMP.bgmLooped } );
						track.play( preset[ 0 ], preset[ 1 ], true, preset[ 3 ], preset[ 4 ] );
						track.seek( X_Audio_Sprite_TEMP.bgmPosition );
					};
					
				} else {
					if( 1 < tracks.length ){
						track = X_Audio_Sprite_getTrackEnded( X_Audio_Sprite_TEMP.bgmPlaying );
						track
							[ 'listen' ]( [ X_EVENT_MEDIA_PLAYING, X_EVENT_MEDIA_BEFORE_LOOP ], this, X_Audio_Sprite_handleEvent )
							.setState( { 'looped' : false } );
						track.play( preset[ 0 ], preset[ 1 ], true, 0, X_Audio_Sprite_lengthSilence );
					} else {
						// single track, iOS
						if( bgm ){
							X_Audio_Sprite_TEMP.bgmPosition = bgm.currentTime();
							//console.log( 'bgm position : ' + X_Audio_Sprite_TEMP.bgmPosition + ' isPlay:' +  bgm.playing );
							X_Audio_Sprite_TEMP.bgmTrack    = null;
						};
						track = tracks[ 0 ];
					
						if( track[ 'listen' ]( [ X_EVENT_MEDIA_PLAYING, X_EVENT_MEDIA_BEFORE_LOOP ], this, X_Audio_Sprite_handleEvent ).playing ){
							track.setState({
									'loop'          : true,
									'looped'        : false,
									//'currentTime'   : preset[ 0 ],
									'startTime'     : preset[ 0 ],
									'endTime'       : preset[ 1 ],
									'loopStartTime' : 0,
									'loopEndTime'   : X_Audio_Sprite_lengthSilence
								});
						} else {
							track.play( preset[ 0 ], preset[ 1 ], true, 0, X_Audio_Sprite_lengthSilence );	
						};
					};
				};
				return tracks.indexOf( track );
			};
			return -1;
		},
		
		'pause' : function( uid ){
			var track = X_Audio_Sprite_TEMP.tracks[ uid ];
			if( X_Audio_Sprite_TEMP.bgmTrack === track ){
				X_Audio_Sprite_TEMP.bgmPosition = track.currentTime();
				X_Audio_Sprite_TEMP.bgmPlaying  = false;
				X_Audio_Sprite_TEMP.bgmTrack    = null;
			};
			track && track.play( 0, X_Audio_Sprite_lengthSilence, true, 0, X_Audio_Sprite_lengthSilence );
			track && track.seek( 0 );
			this[ 'asyncDispatch' ]( X_EVENT_MEDIA_PAUSED );
			return this;
		},
		
		'seek' : function( uid, position ){
			var track = X_Audio_Sprite_TEMP.tracks[ uid ],
				end;
			if( track ){
				delete track.seekTime;
				end = X_AudioWrapper_getEndTime( track );
				position <= end && X_AudioWrapper_getStartTime( track, end ) <= position && track.seek( postion );
			};
			return this;
		},
		
		'volume' : function( uid, opt_volume ){
			var track, i;
			// TODO uid = 0
			if( uid === 0 ){
				if( opt_volume === undefined ){
					return X_Audio_Sprite_TEMP.volume;
				};
				for( i = X_Audio_Sprite_TEMP.tracks.length; i; ){
					X_Audio_Sprite_TEMP.tracks[ --i ].volume( opt_volume );
				};
				return this;
			};
			track = X_Audio_Sprite_TEMP.tracks[ uid ];
			if( opt_volume === undefined ){
				return track ? track.gain : -1;
			};
			track && track.volume( opt_volume );
			return this;
		},
		
		'state' : function( uid, opt_obj ){
			var track = X_Audio_Sprite_TEMP.tracks[ uid ],
				state, start, end;
			// TODO uid = 0
			if( opt_obj === undefined ){
				// TODO pause
				if( track ){
					state = track.getState();
					start = state.startTime;
					return {
				    	'currentTime' : state.currentTime - start,
				        'playing'     : start <= state.currentTime && state.currentTime <= state.endTime,
				        'duration'    : state.endTime - start,
				        'volume'      : X_Audio_Sprite_TEMP.volume
					};
				};
				return { 'volume' : X_Audio_Sprite_TEMP.volume, 'playing' : false };
			};
			track && track.setState( opt_obj );
			return this;
		}
};

function X_AudioSprite_backendHandler( e ){
	var i, backend, option, src, name, last, _e;
	
	switch( e.type ){
		case X_EVENT_BACKEND_READY :
		
			backend = X_Audio_BACKENDS[ e[ 'backendID' ] ];
			option  = e[ 'option' ];
			
			this[ 'unlisten' ]( X_EVENT_BACKEND_NONE, X_AudioSprite_backendHandler );
			this[ 'source' ]      = src = e[ 'source' ];
			this[ 'backendName' ] = name = backend.backendName;
		
			for( i = 0; i < X_Audio_Sprite_numTracks; ++i ){
				if( X_Audio_Sprite_useVideo || ( i === 1 && X_Audio_Sprite_useVideoForMulti ) ){
					option[ 'useVideo' ] = true;
				};
				// Audiobackend の owner として null を渡すとAudioBackend 自身へ dispatch する
				X_Audio_Sprite_TEMP.tracks.push( last = backend.klass( null, e[ 'source' ], option ) );
			};

			_e = {
				'type'        : X_EVENT_BACKEND_READY,
				'source'      : src,
				'backendName' : name
			};
			
			if( X_Audio_Sprite_needTouchFirst ){
				if( name === 'Web Audio' ){
					_e[ 'needTouchForPlay' ] = true;
				} else {
					_e[ 'needTouchForLoad' ] = true;
				};
			};
			this[ 'asyncDispatch' ]( _e );
			
			last[ 'listenOnce' ]( X_EVENT_READY, this, X_AudioSprite_backendHandler );

			// READY, needTouchForPlay, needTouchForLoad
			if( X_Audio_HTMLAudioWrapper_durationFix ){
				for( i = 0; i < X_Audio_Sprite_TEMP.tracks.length; ++i ){
					this[ 'pause' ]( i );
				};
			};
			
			return X_Callback_STOP_NOW;

		case X_EVENT_BACKEND_NONE :
			this[ 'unlisten' ]( X_EVENT_BACKEND_READY, this, X_AudioSprite_backendHandler )
				[ 'asyncDispatch' ]( X_EVENT_BACKEND_NONE );
			return X_Callback_STOP_NOW;
		
		case X_EVENT_READY :
			console.log( 'X.AudioSprite - Ready!' );
			
			if( X_Audio_Sprite_needTouchAndroid ){
				for( i = 0; i < X_Audio_Sprite_TEMP.tracks.length; ++i ){
					this[ 'pause' ]( i );
				};
				e.target[ 'listenOnce' ]( X_EVENT_MEDIA_PLAYING, this, this.asyncDispatch, [ X_EVENT_READY ] ); // Android 標準ブラウザ
				return;
			};
			this[ 'asyncDispatch' ]( X_EVENT_READY );
			break;
	};
};


function X_Audio_Sprite_handleEvent( e ){
	var i, tracks, track, _e, k;
	
	switch( e.type ){
		case X_EVENT_MEDIA_PLAYING :
			( e.target === X_Audio_Sprite_TEMP.bgmTrack || !e.target.looped ) && this[ 'asyncDispatch' ]( X_EVENT_MEDIA_PLAYING );
			break;
		
		case X_EVENT_MEDIA_BEFORE_LOOP :
			if( e.target === X_Audio_Sprite_TEMP.bgmTrack ){
				X_Audio_Sprite_TEMP.bgmLooped = true;
				this[ 'asyncDispatch' ]( X_EVENT_MEDIA_LOOPED ); // TODO uid
			} else {
				if( e.target.looped ){
					//this[ 'asyncDispatch' ]( X_EVENT_MEDIA_LOOPED ); // TODO uid
				} else {
					this[ 'asyncDispatch' ]( X_EVENT_MEDIA_ENDED ); // TODO uid
				};
				
				console.log( '[AudioSprite] ' + X_Audio_Sprite_TEMP.bgmPlaying + ' ' + !X_Audio_Sprite_TEMP.bgmTrack );
				
				// single track | iOS
				if( X_Audio_Sprite_TEMP.bgmPlaying && !X_Audio_Sprite_TEMP.bgmTrack ){
					X_Audio_Sprite_TEMP.bgmTrack = e.target;
					this.play( X_Audio_Sprite_TEMP.bgmName );
					return X.Callback.PREVENT_DEFAULT;
				};
			};
			break;
		
		// TODO Android Firefox で アクティブ検出できない！
		case X_EVENT_VIEW_ACTIVATE :
			console.log( '■ アクティブ' );
			// track.play(); or iOS need touch??
			tracks = X_Audio_Sprite_TEMP.pauseTracks;
			while( tracks.length ) tracks.pop().actualPlay();
			break;

		case X_EVENT_VIEW_DEACTIVATE :
			console.log( '■ デアクティブ' );
			// track.pause();
			tracks = X_Audio_Sprite_TEMP.tracks;
			i      = tracks.length;
			for( ; i; ){
				track = tracks[ --i ];
				track.playing && X_Audio_Sprite_TEMP.pauseTracks.push( track ) && track.pause();
			};
			break;
		
		case X_EVENT_KILL_INSTANCE :
			
			while( X_Audio_Sprite_TEMP.tracks.length ){
				X_Audio_Sprite_TEMP.tracks.pop()[ 'kill' ]();
			};
			
			for( k in X_Audio_Sprite_TEMP.bgms ){
				delete X_Audio_Sprite_TEMP.bgms[ k ];
			};
			for( k in X_Audio_Sprite_TEMP.presets ){
				delete X_Audio_Sprite_TEMP.presets[ k ];
			};
			
			X_Audio_Sprite_TEMP.bgmTrack    = null;
			X_Audio_Sprite_TEMP.bgmPosition = 0;
			X_Audio_Sprite_TEMP.bgmName     = '';
			X_Audio_Sprite_TEMP.bgmLooped   = false;
			X_Audio_Sprite_TEMP.bgmPlaying  = false;
			
			X_ViewPort[ 'unlisten' ]( [ X_EVENT_VIEW_ACTIVATE, X_EVENT_VIEW_DEACTIVATE ], this, X_Audio_Sprite_handleEvent );
			break;
	};
};
