var X_UI_rootData  = null,
	X_UI_eventBusy = false;

function X_UI_eventRellay( e ){
	var font    = X_ViewPort_baseFontSize,
		x       = e.pageX / font, // clientX は iOS4- で通らない？
		y       = e.pageY / font,
		type    = XUI_Event.NameToID[ e.type ],
		i       = 0,
		data    = X_UI_rootData,
		sysOnly = false,
		ret     = X_Callback_NONE,
		list, parent, _ret;

	// mouseup で　alert を出すと　mouseleave が発生、ということでイベント中のイベント発火を禁止
	if( !data || X_UI_eventBusy ) return ret;
	data._eventBusy = true;
	
	if( type !== '' + XUI_Event._POINTER_MOVE ){
		//console.log( e.type + ' ' + type + ' x:' + x + ', y:' + y );
	};
	
	e.type = type;

	if( data && ( data = data.monopolyNodeData ) && ( ret = data[ 'dispatch' ]( e ) ) & X_Callback_CAPTURE_POINTER ){
		X_UI_eventBusy = false;
		return ret | X_Callback_PREVENT_DEFAULT;
	};
	
	list = X_UI_rootData.hoverList;
	( X_UI_rootData.targetNodeData = X_UI_rootData ).capcher( x, y );
	data = X_UI_rootData.targetNodeData;

	//data !== X_UI_rootData && console.log( data.xnode[ 'text' ]() );

	while( data ){
		_ret = data[ 'dispatch' ]( e, sysOnly );
		ret |= _ret;
		if( _ret & X_Callback_CAPTURE_POINTER || _ret & X_Callback_STOP_PROPAGATION || _ret & X_Callback_STOP_NOW ) break; // sysOnly = true;
		data = data.parentData;
	};
	
	for( i = list.length; i; ){
		parent = data = list[ --i ];
		while( parent.parentData && parent === parent.parentData.hitChildData ){
			parent = parent.parentData;
		};
		if( parent !== X_UI_rootData ){
			data.hoverClassName && data.xnode[ 'removeClass' ]( data.hoverClassName );
			data[ '_listeners' ] && data[ '_listeners' ][ XUI_Event.POINTER_OUT ] && data[ 'dispatch' ]( e, XUI_Event.POINTER_OUT, false ); // new Event
			delete data.hovering;
			list.splice( i, 1 );
			continue;
		};
		if( !data.hovering ){
			data.hoverClassName && data.xnode.addClassName( data.hoverClassName );
			data[ '_listeners' ] && data[ '_listeners' ][ XUI_Event.POINTER_IN ] && data[ 'dispatch' ]( e, XUI_Event.POINTER_IN, true ); // new Event
			data.hovering = true;
		};
	};
	X_UI_eventBusy = false;
	return ret | X_Callback_PREVENT_DEFAULT;
};

/*
 * body が存在したら要素を作成、css も指定
 * 背景画像を読み終える onload で活動開始
 */

var XUI_PageRoot = XUI_Box.inherits(
	'_PageRoot',
	X_Class.FINAL,
	{
		layout                : XUI_Layout_Canvas,
		
		calcReserved          : false,
		hoverList             : null,
		targetNodeData        : null,
		monopolyNodeData      : null,
		
		xnodeInteractiveLayer : null,
		eventCounter          : null,
		cursorStyle           : null,
		
		Constructor : function( user, layout, args ){
			this[ 'Super' ]( user, layout, args );
			
			if( X_ViewPort_readyState === X_EVENT_XDOM_READY ){
				X_Timer_once( 0, this, this.start );
			} else {
				X.ViewPort[ 'listenOnce' ]( X_EVENT_XDOM_READY, this, this.start );
			};
			
			this.hoverList    = [];
			this.eventCounter = {};
			
			X_UI_rootData = this;
		},
		
		start : function(){
			this.initialize( this.User, this, null, null );
			X_Timer_once( 0, this, this.addToView );
		},
		addToView : function(){
			var	counter = this.eventCounter, flg;
			
			// this.xnodeInteractiveLayer の前に追加する！

			this.addToParent( X.Doc.body );
			
			this.xnodeInteractiveLayer = X.Doc.body.create( 'div', {
				'class'      : 'mouse-operation-catcher',
				unselectable : 'on'
			} );
			
			// hover や rollover rollout のための move イベントの追加
			( X_UA[ 'IE' ] < 9 ? X_ViewPort_document : X_UA[ 'Opera' ] < 8 ? X_Node_body : X_ViewPort )[ 'listen' ]( 'pointermove', X_UI_eventRellay );
			if( counter[ XUI_Event._POINTER_MOVE ] ){
				++counter[ XUI_Event._POINTER_MOVE ];
			} else {
				counter[ XUI_Event._POINTER_MOVE ] = 1;
			};

			X_Timer_once( 0, this, this.afterAddToView );
		},
		afterAddToView : function(){
			this.xnode[ 'className' ]( 'PageRoot' );
			
			this.creationComplete();
			X_Timer_once( 0, this, XUI_PageRoot_do1stCalculate );
		},
		
		reserveCalc : function(){
			if( this.calcReserved === false ){
				this.calcReserved = true;
				X_Timer_once( 0, this, this.calculate );
			};
		},
		calculate : function( e ){
			var cancelable = !e || ( e.type !== X_EVENT_VIEW_RESIZED && e.type !== X_EVENT_BASE_FONT_RESIZED ),
				size, font, w, h;
			
			if( this[ 'dispatch' ]( { type : XUI_Event.LAYOUT_BEFORE, 'cancelable' : cancelable } ) & X_Callback_PREVENT_DEFAULT && cancelable ){
				return X_Callback_NONE;
			};
			
			size = X[ 'ViewPort' ][ 'getSize' ]();
			font = X[ 'ViewPort' ][ 'getBaseFontSize' ]();
			this.layout.calculate( this, false, 0, 0, size[ 0 ] / font, size[ 1 ] / font );
			this.updateLayout();
			
			this.calcReserved = false;
			
			X_ViewPort[ 'listenOnce' ]( X_EVENT_AFTER_UPDATE, this, XUI_PageRoot_onViewUpdate );
			
			return X_Callback_NONE;
		},
		
		updateCoursor : function( cursor ){
			
		},
		
		_remove : function(){
			X_EventDispatcher_unlistenAll( this.xnodeInteractiveLayer );
			_Box.prototype._remove.call( this );
		}
	}
);

function XUI_PageRoot_do1stCalculate(){
	this.calculate();
	this.phase = 4;
	X.ViewPort
		[ 'listen' ]( X_EVENT_VIEW_RESIZED, this, this.calculate )
		[ 'listen' ]( X_EVENT_BASE_FONT_RESIZED, this, this.calculate );
};

function XUI_PageRoot_onViewUpdate( e ){
	this[ 'dispatch' ]( XUI_Event.LAYOUT_COMPLETE );
};

//var XUI_PageRoot;
// TODO singleton
X.UI.PageRoot = X.UI.Box.inherits(
	'PageRoot',
	X_Class.NONE,
	{
		Constructor : function(){
			var supports;
			
			//if( !XUI_PageRoot ){
				supports = XUI_Attr_createAttrDef( XUI_Box.prototype.usableAttrs, XUI_Layout_Canvas.overrideAttrsForSelf );
				
				XUI_PageRoot.prototype.layout       = XUI_Layout_Canvas;
				XUI_PageRoot.prototype.usableAttrs = supports;
				XUI_PageRoot.prototype.attrClass    = XUI_Attr_preset( XUI_Box.prototype.attrClass, supports, {
									width  : '100%',
									height : '100%'
								} );
			//};
			X_Pair_create( this, XUI_PageRoot( this, XUI_Layout_Canvas, arguments ) );
		}
	});
/*
X.UI.PageRoot = X.UI.Box.presets(
	'PageRoot',
	XUI_PageRoot,
	{
		width  : '100%',
		height : '100%'
	}
);*/

