

/*
 * style 値の変更は、enterFrame 後にまとめて適用
 * width(), height(), x(), y() 1em の取得時にも適用
 * css3 の ie用 fix は X.UI レベルで行う
 * 
 * use X.Dom.Event
 */
X.Dom.Style = {
	
	Type : {
		LENGTH            : 1,
		PERCENT           : 2,
		COLOR             : 2 < 2,
		U_DECIMAL         : 2 < 3,
		NUMERICAL         : 2 < 4,
		BOOLEAN           : 2 < 5,
		QUARTET           : 2 < 6,
		URL               : 2 < 7,
		FONT_NAME         : 2 < 8,
		TIME              : 2 < 9,
		CONTENT           : 2 < 10,
		LIST              : 2 < 11,
		AUTO              : 2 < 12,
		COMBI             : 2 < 13
	},
	
	SPECIAL_VALUES : {
		AUTO : Number.POSITIVE_INFINITY,
		FULL : X.Dom // something unigue value; 100%
	},
	
	PropNo : {},
	
	UNIT : {
		'px'   : 0,
		'em'   : 1,
		'cm'   : 2,
		'mm'   : 3,
		'in'   : 4,
		'%'    : 5,
		'pct'  : 5,
		'ms'   : 6,
		's'    : 7,
		'#'    : 8,
		'rgb'  : 9,
		'rgba' : 10
	},
	
	/* font-size -> fontSize */
	_DICTIONARY_CAMELIZE : {},
	
	camelize : function( cssProp ){
		var me  = X.Dom.Style,
			parts, l, i, camelized;
		
		if( camelized = me._DICTIONARY_CAMELIZE[ cssProp ] ) return camelized;
		parts = cssProp.split( ' ' ).join( '' ).split( '-' );
		l     = parts.length;
		if( l === 1 ) return parts[ 0 ];
		
		camelized = cssProp.charAt(0) === '-'
		  ? parts[ 0 ].charAt( 0 ).toUpperCase() + parts[ 0 ].substring( 1 )
		  : parts[ 0 ];
		
		for( i = 1; i < l; ++i ){
			camelized += parts[ i ].charAt( 0 ).toUpperCase() + parts[ i ].substring( 1 );
		};
		return me._DICTIONARY_CAMELIZE[ cssProp ] = camelized;
	},
	
	/* fontSize -> font-size */
	CHAR_CODE_A : 'A'.charCodeAt( 0 ),
	
	_DICTIONARY_UNCAMELIZE : {},
	
	uncamelize : function( str ){
		var me  = X.Dom.Style,
			A   = me.CHAR_CODE_A,
			Z   = A + 25,
			uncamelized, l, chr, code;
		str = str.split( ' ' ).join( '' );
		if( uncamelized = me._DICTIONARY_UNCAMELIZE[ str ] ) return uncamelized;
		uncamelized = '';
		for( i = 0, l = str.length; i < l; ++i ){
			chr = str.charAt( i );
			code = chr.charCodeAt( 0 );
			uncamelized += ( A <= code && code <= Z ) ? '-' + chr : chr;
		};
		return me._DICTIONARY_UNCAMELIZE[ str ] = uncamelized.toLowerCase();
	},
	
/*
 * CSS における display, position, float プロパティの相互関係
 * http://d.hatena.ne.jp/elm200/20080201/1201874740
 * 
 * CSS21:9.7 Relationships between ’display’, ’position’, and ’float’ 
 * http://www.w3.org/TR/CSS21/visuren.html#dis-pos-flo
 * 
 *   display:none? -yes-> 非表示
 *    ↓
 *   position:absolute? -yes-> float:none,display:block;
 *    ↓
 *   float:none? -no-> display:block;
 *    ↓
 *   display:そのまま
 * 
 *
display		position			float
block		static|relative		none
block		static|relative		right|left
block		absolute			none
inline		static|relative		none

_DISPLAY_NONE
_ABSOLUTE_BOX
_FLOAT_BOX
_GRNERAL
 */
	objToCssText : function( obj ){
		var css           = [],
			me            = X.Dom.Style,
			uncamelize    = me.uncamelize,
			VENDER_PREFIX = me.VENDER_PREFIX,
			FIX_PROP      = me.SPECIAL_FIX_PROP,
			SPECIAL_FIX   = me.SPECIAL_FIX,
			n             = -1,
			p, name, sp;
		for( p in obj ){
			name = uncamelize( p );
			if( FIX_PROP[ name ] ){
				sp = 1;
			} else {
				css[ ++n ] = [ VENDER_PREFIX[ name ] || name, obj[ p ] ].join( ':' );
			};
		};
		sp && ( css[ ++n ] = 'filter:' + SPECIAL_FIX( obj ) );
		return css.join( ';' );
	},
	
	IE_FILTER_FIX :
		X.UA.IE && X.UA.IE < 9 ?
			{
				opacity : 1,
				textShadow : 1
			} :
		9 <= X.UA.IE && X.UA.IE < 10 ? // == 9
			{} :
			{},
	
	_UNIT_RATIO      : null,
	_FONT_SIZE_RATIO : null,

	//  https://developer.mozilla.org/en-US/docs/Web/CSS/transform
	//  Firefox 3.5, ie9, Opera 10.5, Safari 3.1, Chrome
	//  3D support Firefox 10, ie10, Safari 4.0, Chrome 12.0
	// transform : void 0,
	
	//  https://developer.mozilla.org/ja/docs/Web/Guide/CSS/Using_CSS_transitions
	//  Chrome 1.0, Firefox 4.0, ie10, Opera 10.5, Safari 3.2
	//  Android 2.1, Firefox Android 4.0, Opera Mobile 10, Safari Mobile 3.2	
	// transition : void 0
	
	// ブラウザ毎の getComputedStyle の戻り値 http://d.hatena.ne.jp/uupaa/20080928/1222543331

	COLOR : {
		BLACK         : 0x0,
		RED           : 0xFF0000,
		LIME          : 0x00FF00,
		BLUE          : 0x0000FF,
		YELLOW        : 0xFFFF00,
		AQUA          : 0x00FFFF,
		CYAN          : 0x00FFFF,
		MAGENTA       : 0xFF00FF,
		FUCHSIA       : 0xFF00FF,
		WHITE         : 0xFFFFFF,
		GREEN         : 0x008000,
		PURPLE        : 0x800080,
		MAROON        : 0x800000,
		NAVY          : 0x000080,
		OLIVE         : 0x808000,
		TEAL          : 0x008080,
		GRAY          : 0x808080,
		SILVER        : 0xC0C0C0,
		DIMGRAY       : 0x696969,
		SLATEGRAY     : 0x708090,
		DARKGRAY      : 0xA9A9A9,
		GAINSBORO     : 0xDCDCDC,
		MIDNIGHTBLUE  : 0x191970,
		SLATEBLUE     : 0x6A5ACD,
		MEDIUMBLUE    : 0x0000CD,
		ROYALBLUE     : 0x4169E1,
		DODGERBLUE    : 0x1E90FF,
		SKYBLUE       : 0x87CEEB,
		STEELBLUE     : 0x4682B4,
		LIGHTBLUE     : 0xADD8E6,
		PALETURQUOISE : 0xAFEEEE,
		TURQUOISE     : 0x40E0D0,
		LIGHTCYAN     : 0xE0FFFF,
		AQUAMARINE    : 0x7FFFD4,
		DARKGREEN     : 0x006400,
		SEAGREEN      : 0x2E8B57,
		LIGHTGREEN    : 0x90EE90,
		CHARTREUSE    : 0x7FFF00,
		GREENYELLOW   : 0xADFF2F,
		LIMEGREEN     : 0x32CD32,
		YELLOWGREEN   : 0x9ACD32,
		OLIVEDRAB     : 0x6B8E23,
		DARKKHAKI     : 0xBCB76B,
		PALEGOLDENROD : 0xEEE8AA,
		LIGHTYELLOW   : 0xFFFFE0,
		GOLD          : 0xFFD700,
		GOLDENROD     : 0xDAA520,
		DARKGOLDENROD : 0xB8860B,
		ROSYBROWN     : 0xBC8F8F,
		INDIANRED     : 0xCD5C5C,
		SADDLEBROWN   : 0x8B4513,
		SIENNA        : 0xA0522D,
		PERU          : 0xCD853F,
		BURLYWOOD     : 0xDEB887,
		BEIGE         : 0xF5F5DC,
		WHEAT         : 0xF5DEB3,
		SANDYBROWN    : 0xF4A460,
		TAN           : 0xD2B48C,
		CHOCOLATE     : 0xD2691E,
		FIREBRICK     : 0xB22222,
		BROWN         : 0xA52A2A,
		SALMON        : 0xFA8072,
		ORANGE        : 0xFFA500,
		CORAL         : 0xFF7F50,
		TOMATO        : 0xFF6347,
		HOTPINK       : 0xFF69B4,
		PINK          : 0xFFC0CB,
		DEEPPINK      : 0xFF1493,
		PALEVIOLETRED : 0xDB7093,
		VIOLET        : 0xEE82EE,
		PLUM          : 0xDDA0DD,
		ORCHILD       : 0xDA70D6,
		DARKVIOLET    : 0x9400D3,
		BLUEVIOLET    : 0x8A2BE2,
		MEDIUMPURPLE  : 0x9370DB,
		THISTLE       : 0xD8BFD8,
		LAVENDER      : 0xE6E6FA,
		MISTYROSE     : 0xFFE4E1,
		IVORY         : 0xFFFFF0,
		LEMONCHIFFON  : 0xFFFACD
	},
	
	parseColor : function( x ){
		var rgb, r, g, b;
		
		if( X.Type.isNumber( x ) ){
			return ( 0x0 <= x && x <= 0xFFFFFF ) ? x : undefined;
		} else
		if( !X.Type.isString( x ) ) return;
		
		if( X.Type.isNumber( rgb = X.Dom.Style.COLOR[ x.toUpperCase() ] ) && 0x0 <= rgb && rgb <= 0xFFFFFF ){
			return rgb;
		} else
		if( x.charAt( 0 ) === '#' ){
			switch( x.length ){
				case 7 :
					r = parseInt( x.substr( 1, 2 ), 16 );
					g = parseInt( x.substr( 3, 2 ), 16 );
					b = parseInt( x.substr( 5, 2 ), 16 );
					break;
				case 4 :
					r = parseInt( x.charAt( 1 ) + x.charAt( 1 ), 16 );
					g = parseInt( x.charAt( 2 ) + x.charAt( 2 ), 16 );
					b = parseInt( x.charAt( 3 ) + x.charAt( 3 ), 16 );
					break;
				case 2 :
					r = g = b = parseInt( x.charAt( 1 ) + x.charAt( 1 ), 16 );
					break;
				default :
					return;											
			};
		} else
		if( x.indexOf( 'rgb(' ) === 0 ){
			rgb = x.substr( 4 ).split( ',' );
			r = parseFloat( rgb[ 0 ] );
			g = parseFloat( rgb[ 1 ] );
			b = parseFloat( rgb[ 2 ] );
			if( x.indexOf( '%' ) !== -1 ){
				r *= 2.55;
				g *= 2.55;
				b *= 2.55;
			};
		} else
		if( x.indexOf( 'rgba(' ) === 0 ){
			rgb = x.substr( 5 ).split( ',' );
			r = parseFloat( rgb[ 0 ] );
			g = parseFloat( rgb[ 1 ] );
			b = parseFloat( rgb[ 2 ] );
			//a = parseFloat( rgb[ 3 ] );
			if( x.indexOf( '%' ) !== -1 ){
				r *= 2.55;
				g *= 2.55;
				b *= 2.55;
			};
		} else {
			return undefined;
		};
		return isFinite( r + b + g ) ? ( r << 16 ) + ( g << 8 ) + b : undefined;
	},
	
	PARAMS : ( function(){
		var ret = {};
		register( ret.percent = {},
			'marginBottom,marginLeft,marginRight,marginTop,paddingBottom,paddingLeft,paddingRight,paddingTop,fontSize,textIndent'
		);
		register( ret.offset = {},
			'height,width,bottom,left,right,top'
		);		
		register( ret.size = {},
			'borderBottomWidth,borderLeftWidth,borderRightWidth,borderTopWidth,letterSpacing,wordSpacing'
		);
		register( ret.color = {},
			'backgroundColor,borderBottomColor,borderLeftColor,borderRightColor,borderTopColor,color'
		);
		register( ret.region = {},
			'margin,padding,borderWidth,borderColor'
		);		
		register( ret.special = {},
			'clip,backgroundPosition,backgroundPositionX,backgroundPositionY,opacity,lineHeight,zIndex'
		);
		register( ret.unit = {}, 'px,cm,mm,in,pt,pc,em,%' );
		
		register( ret.margin = {}, 'marginBottom,marginLeft,marginRight,marginTop,paddingBottom' );
		register( ret.padding = {}, 'paddingBottom,paddingLeft,paddingRight,paddingTop' );
		register( ret.borderWidth = {}, 'borderBottomWidth,borderLeftWidth,borderRightWidth,borderTopWidth' );
		register( ret.borderColor = {}, 'borderBottomColor,borderLeftColor,borderRightColor,borderTopColor' );
		
		function register( obj, params ){
			params = params.split( ',' );
			for( var i = params.length; i; ) obj[ params[ --i ] ] = true;
		};
		return ret;
	})(),
	
	_CLIP_SEPARATOR : X.UA.IE && X.UA.IE < 8 ? ' ' : ',',
	
	/*
	 * 
	 */
	Property : X.Class.create(
		'Property',
		X.Class.POOL_OBJECT,
		{
			Constructor : function( name, value, unit, xnode ){
				this.name  = name;
				this.value = value;
				this.unit  = unit;
				this.xnode = xnode;
			},
			name    : '',
			value   : 0,
			unit    : '',
			xnode   : null,
			equal : function( prop ){
				if( this.unit === prop.unit ){
					return this.value === prop.value;
				};
				return Math.abs( this.toPx() - prop.toPx() ) < 1;
			},
			convert: function( prop ){
				var u = prop.unit, v;
				if( this.unit === u ) return;
				this.value = v = this.toPx();
				this.unit  = u;
				// %
				// bgpX, bgpY の場合 X.Dom.Image.getActualDimension( backgroundImage url を使用 )
				if( u !== 'px' ){
					this.value =
						u === 'em' ?
							v / this.xnode._getCharSize() :
							v / ( X.Dom.Style._UNIT_RATIO[ u ] || 1 );
				};
			},
			setValue: function( v ){
				this.value = v;
			},
			getValue: function(){
				return this.value;
			},
			getOffset: function( prop ){
				return prop.value - this.value;
			},
			getUnit: function(){
				return this.unit;
			},
			getValueText: function(){
				return this.value === 0 ? '0' : this.value + this.unit;
			},
			toPx: function(){
				var v = this.value, u = this.unit;
				return
					u === 'px' ?
						v :
					( u === 'em' || ( u === '' && this.name === 'lineHeight' ) ) ?
						v * this.xnode._getCharSize() :
					// u === '%'
						v / ( X.Dom.Style._UNIT_RATIO[ u ] || 1 );
			},
			isValid: function(){
				var p = X.Dom.Style.PARAMS,
					n = this.name,
					v = this.value,
					u = this.unit,
					z = u !== '' ? true : v === 0;
				if( p.percent[ n ] === true ) return z;
				if( p.offset[ n ]  === true ) return z;
				if( p.size[ n ]    === true ) return z && u !== '%';
				if( p.special[ n ] === true ){
					if( n === 'lineHeight' ) return true;
					if( n === 'opacity' )    return 0 <= v && v <= 1 && u === '';
					if( n === 'zIndex'  )    return u === '';
				};
				return false;
			}
		}
	),
	
	/**
	 * backgroundPosition, clip
	 */
	PropertyGroup : X.Class.create(
		'PropertyGroup',
		X.Class.POOL_OBJECT,
		{
			Constructor : function( name ){
				this.name  = name;
				this.props = [];
				for( var i = 1, l = arguments.length; i<l; ++i ){
					this.props[ this.props.length ] = arguments[ i ];
				};
			},
			name  : '',
			equal : function( prop ){
				var ps = this.props, i = ps.length;
				for( ; i; ){
					--i;
					if( ps[ i ].equal( prop[ i ] ) === false ) return false;
				};
				return true;
			},
			convert : function( prop ){
				var ps = this.props, i = ps.length;
				for( ; i; ){
					--i;
					ps[ i ].convert( prop[ i ] );
				};
			},
			setValue : function( ary ){
				var ps = this.props, i = 0, l = ps.length;
				for( ; i<l; ++i ){
					ps[ i ].setValue( ary[ i ] );
				};
			},
			getValue : function(){
				var ret = [], ps = this.props, i = 0, l = ps.length;
				for( ; i<l; ++i ){
					ret[ ret.length ] = ps[ i ].getValue();
				};
				return ret;
			},
			getOffset : function( prop ){
				var ret = [],
					ps  = this.props,
					_ps = prop.props,
					i   = 0,
					l = ps.length;
				for( ; i<l; ++i ){
					ret[ ret.length ] = ps[ i ].getOffset( _ps[ i ] );
				};
				return ret;
			},
			getUnit : function(){
				var ret = [], ps = this.props, i = 0, l = ps.length;
				for( ; i<l; ++i ){
					ret[ ret.length ] = ps[ i ].getUnit();
				};
				return ret;
			},
			getValueText : function(){
				var ret = [], ps = this.props, i = 0, l = ps.length;
				for( ; i<l; ++i ){
					ret[ ret.length ] = ps[ i ].getValueText();
				};
				if( this.name === 'clip' ){
					return 'rect(' + ret.join( X.Dom.Style._CLIP_SEPARATOR ) + ')';
				};
				return ret.join( ' ' );
			},
			onKill : function(){
				var ps = this.props, i = ps.length;
				for( ; i; ){
					ps[ --i ].kill();
				};
			},
			isValid : function( t ){
				t = t || this;
				var ps = t.props, i = ps.length;
				for( ; i; ){
					if( ps[ --i ].isValid() === false ) return false;
				};
				return true;
			}
		}
	),

	/*
	 * http://css-eblog.com/ie-css-problems/rgba-pe.html
	 * ie67 では rgb() は background-color で反応しない、、、
	 */

	ColorProperty : X.Class.create(
		'ColorProperty',
		X.Class.POOL_OBJECT, {
			Constructor : function( name, x ){
				var pct = false,
					r   = 0,
					g   = 0,
					b   = 0,
					a   = 1,
					rgb;
				if( X.Type.isNumber( rgb = x ) || X.Type.isNumber( rgb = X.Dom.Style.COLOR[ x.toUpperCase() ] ) ){
					r = ( rgb & 0xff0000 ) >> 16;
					g = ( rgb & 0xff00 ) >> 8;
					b = ( rgb & 0xff );
				} else
				if( x.charAt( 0 ) === '#' ){
					if( x.length === 7 ){
						r = parseInt( x.charAt( 1 ) + x.charAt( 2 ), 16 );
						g = parseInt( x.charAt( 3 ) + x.charAt( 4 ), 16 );
						b = parseInt( x.charAt( 5 ) + x.charAt( 6 ), 16 );
					} else			
					if( x.length === 4 ){
						r = parseInt( x.charAt( 1 ) + x.charAt( 1 ), 16 );
						g = parseInt( x.charAt( 2 ) + x.charAt( 2 ), 16 );
						b = parseInt( x.charAt( 3 ) + x.charAt( 3 ), 16 );
					} else
					if( x.length === 2 ){
						r = parseInt( x.charAt( 1 ) + x.charAt( 1 ), 16 );
						g = parseInt( x.charAt( 1 ) + x.charAt( 1 ), 16 );
						b = parseInt( x.charAt( 1 ) + x.charAt( 1 ), 16 );
					};
				} else
				if( x.indexOf( 'rgb(' ) === 0 ){
					rgb = x.substr( 4 ).split( ',' );
					r = parseFloat( rgb[ 0 ] );
					g = parseFloat( rgb[ 1 ] );
					b = parseFloat( rgb[ 2 ] );
					if( x.indexOf( '%' ) !== -1 ) pct = true;
				} else
				if( x.indexOf( 'rgba(' ) === 0 ){
					rgb = x.substr( 5 ).split( ',' );
					r = parseFloat( rgb[ 0 ] );
					g = parseFloat( rgb[ 1 ] );
					b = parseFloat( rgb[ 2 ] );
					a = parseFloat( rgb[ 3 ] );
					if( x.indexOf( '%' ) !== -1 ) pct = true;
				} else {
					r = 255;
					g = 255;
					b = 255;
				};
				
				this.name = name;
				this.r    = r;
				this.g    = g;
				this.b    = b;
				this.a    = a;
				this.pct  = pct;
			},
			name  : '',
			r     : 0,
			g     : 0,
			b     : 0,
			a     : 0,
			pct   : false,
			equal : function( prop ){
				if( this.pct === prop.pct ){
					return this.r === prop.r && this.g === prop.g && this.b === prop.b;
				};
				var rgb  = this._toPct(),
					_rgb = prop._toPct(),
					i    = rgb.length;
				for( ; i; ){
					--i;
					if( Math.abs( rgb[ i ] - _rgb[ i ] ) > 1 ) return false;
				};
				return true;
			},
			convert : function( prop ){
				var u = prop.pct, x;
				if( this.pct === u ) return;
				x = u === true ? 100 / 255 : 2.55;
				this.r  *= x;
				this.g  *= x;
				this.b  *= x;
				this.pct = u;
			},
			setValue : function( rgb ){
				this.r = rgb[ 0 ];
				this.g = rgb[ 1 ];
				this.b = rgb[ 2 ];
			},
			getValue : function(){
				return [ this.r, this.g, this.b ];
			},
			getOffset : function( prop ){
				return [ prop.r - this.r, prop.g - this.g, prop.b - this.b ];
			},
			getUnit : function(){
				return this.pct === true ? '%' : '';
			},
			getValueText : function(){
				if( this.pct === true ){
					return [ 'rgb(', this.r, '%,', this.g, '%,', this.b, '%)' ].join( '' );
				};
				var round = Math.round;
				
				var rgb   = '00000' + ( ( round( this.r ) << 16 ) + ( round( this.g ) << 8 ) + round( this.b ) ).toString( 16 );
				return '#' + rgb.substr( rgb.length - 6 );
			},
			_toPct : function(){
				if( this.pct === true ) return [ this.r, this.g, this.b ];
				return [ this.r / 2.55, this.g / 2.55, this.b / 2.55 ];
			},
			isValid : function( t ){
				var isFinite = window.isFinite;
				if( !isFinite( this.r ) || !isFinite( this.g ) || !isFinite( this.b ) ) return false;
				if( 0 > this.r || 0 > this.g || 0 > this.b ) return false;
				if( this.pct === true ) return this.r <= 100 && this.g <= 100 && this.b <= 100;
				return this.r <= 255 && this.g <= 255 && this.b <= 255;
			}
		}
	),
	
	_getProperty : function( xnode, css, unit, p ){
		
		var XDomStyle     = X.Dom.Style,
			me            = XDomStyle._getProperty,
			PARAMS        = XDomStyle.PARAMS,
			PropertyGroup = XDomStyle.PropertyGroup,
			Property      = XDomStyle.Property,
			ColorProperty = XDomStyle.ColorProperty,
			name, width;
		
		if( PARAMS.special[ p ] === true || PARAMS.region[ p ] === true ){
			switch( p ){
				case 'clip' :
					// rect(...)	クリップします。<top>, <bottom> は上端からの、 <right>, <left> は左端からのオフセットで指定します。Internet Explorer 4～7 では、カンマの代わりにスペースで区切る必要があります。
					// position:absolute または position:fixed を適用した要素に対してのみ有効です。
					var top    = me( p + 'Top' ),
						right  = me( p + 'Right' ),
						bottom = me( p + 'Bottom' ),
						left   = me( p + 'Left' ),
						ret    = new PropertyGroup( p, top, right, bottom, left ),
			            all;
					if( ret.isValid() === true ) return ret;
					ret.kill();
					all = css[ p ].split( '(' )[ 1 ].split( ')' )[ 0 ].split( XDomStyle._CLIP_SEPARATOR );
					return
						new PropertyGroup( 
							p,
							new Property( p + 'Top',    all[ 0 ], 'px', xnode ),
							new Property( p + 'Right',  all[ 1 ], 'px', xnode ),
							new Property( p + 'Bottom', all[ 2 ], 'px', xnode ),
							new Property( p + 'Left',   all[ 3 ], 'px', xnode )
						);

				case 'margin' :
				case 'padding' :
					name  = p;
					width = '';
				case 'borderWidth' :
					var props  = '$1Top$2,$1Right$2,$1Bottom$2,$1Left$2'.split( '$1' ).join( name || 'border' ).split( '$2' ).join( width || 'Width' ).split( ',' ),
						top    = me( props[ 0 ] ),
						right  = me( props[ 1 ] ),
						bottom = me( props[ 2 ] ),
						left   = me( props[ 3 ] ),
						ret    = new PropertyGroup( p, top, right, bottom, left ),
						all, _0, _1, _2, _3, vu, v, u;
					if( ret.isValid() === true ) return ret;
					ret.kill();
					all = css[ p ].split( ' ' );
					_0  = all[ 0 ];
					_1  = all[ 1 ];
					_2  = all[ 2 ];
					_3  = all[ 3 ];
					vu  = XDomStyle._splitValueAndUnit( _0 );
					v   = vu[ 0 ];
					u   = vu[ 1 ];
					switch( all.length ){
						case 1 :
							top    = new Property( props[ 0 ], v, u, xnode );
							right  = new Property( props[ 1 ], v, u, xnode );
							bottom = new Property( props[ 2 ], v, u, xnode );
							left   = new Property( props[ 3 ], v, u, xnode );
							break;
						case 2 :
							top    = new Property( props[ 0 ], v, u, xnode );
							bottom = new Property( props[ 2 ], v, u, xnode );
							vu     = XDomStyle._splitValueAndUnit( _1 );
							v      = vu[ 0 ];
							u      = vu[ 1 ];
							right  = new Property( props[ 1 ], v, u, xnode );
							left   = new Property( props[ 3 ], v, u, xnode );
							break;
						case 3 :
							top    = new Property( props[ 0 ], v, u, xnode );
							vu     = XDomStyle._splitValueAndUnit( _1 );
							v      = vu[ 0 ];
							u      = vu[ 1 ];
							right  = new Property( props[ 1 ], v, u, xnode );
							left   = new Property( props[ 3 ], v, u, xnode );
							vu     = XDomStyle._splitValueAndUnit( _2 );
							v      = vu[ 0 ];
							u      = vu[ 1 ];
							bottom = new Property( props[ 2 ], v, u, xnode );
							break;
						case 4 :
							top    = new Property( props[ 0 ], v, u, xnode );
							vu     = XDomStyle._splitValueAndUnit( _1 );
							v      = vu[ 0 ];
							u      = vu[ 1 ];
							right  = new Property( props[ 1 ], v, u, xnode );
							vu     = XDomStyle._splitValueAndUnit( _2 );
							v      = vu[ 0 ];
							u      = vu[ 1 ];
							bottom = new Property( props[ 2 ], v,u, xnode );
							vu     = XDomStyle._splitValueAndUnit( _3 );
							v      = vu[ 0 ];
							u      = vu[ 1 ];
							left   = new Property( props[ 3 ], v, u, xnode );
							break;
					};
					return new PropertyGroup( p, top, right, bottom, left );

				case 'borderColor' :
					var props  = 'borderTopColor,borderRightColor,borderBottomColor,borderLeftColor'.split( ',' ),
						top    = me( props[ 0 ] ),
						right  = me( props[ 1 ] ),
						bottom = me( props[ 2 ] ),
						left   = me( props[ 3 ] ),
						ret    = new PropertyGroup( p, top, right, bottom, left ),
						all, _0, _1;
					if( ret.isValid() === true ) return ret;
					ret.kill();
					all = css[ p ].split( ' ' );
					_0  = all[ 0 ];
					_1  = all[ 1 ];
					switch( all.length ){
						case 1 :
							top    = new ColorProperty( props[ 0 ], _0 );
							right  = new ColorProperty( props[ 1 ], _0 );
							bottom = new ColorProperty( props[ 2 ], _0 );
							left   = new ColorProperty( props[ 3 ], _0 );
							break;
						case 2 :
							top    = new ColorProperty( props[ 0 ], _0 );
							right  = new ColorProperty( props[ 1 ], _1 );
							bottom = new ColorProperty( props[ 2 ], _0 );
							left   = new ColorProperty( props[ 3 ], _1 );
							break;
						case 3 :
							top    = new ColorProperty( props[ 0 ], _0 );
							right  = new ColorProperty( props[ 1 ], _1 );
							bottom = new ColorProperty( props[ 2 ], all[ 2 ] );
							left   = new ColorProperty( props[ 3 ], _1 );
							break;
						case 4 :
							top    = new ColorProperty( props[ 0 ], _0 );
							right  = new ColorProperty( props[ 1 ], _1 );
							bottom = new ColorProperty( props[ 2 ], all[ 2 ] );
							left   = new ColorProperty( props[ 3 ], all[ 3 ] );
							break;
					};
					return new PropertyGroup( p, top, right, bottom, left );
					
				case 'backgroundPosition' :
					var x   = me( p + 'X' ),
						y   = me( p + 'Y' ),
						ret = new PropertyGroup( p, x, y ),
						xy;
					if( ret.isValid() === true ) return ret;
					ret.kill();
					xy = css[ p ].split( ' ' );
					x  = XDomStyle._splitValueAndUnit( xy[ 0 ] );
					y  = XDomStyle._splitValueAndUnit( xy[ 1 ] );
					return
						new PropertyGroup(
							p,
							new Property( p + 'X', x[ 0 ], x[ 1 ], xnode ),
							new Property( p + 'Y', y[ 0 ], y[ 1 ], xnode )
						);
			};
			// opacity, zindex, lineHeight
			vu = XDomStyle._splitValueAndUnit( css[ p ] );
			return new Property( p, vu[ 0 ], vu[ 1 ], xnode );
		};
		var x = css[ p ], e, v, u;
		/*
		if( PARAMS.offset[ p ] === true ){
			return new Property( p, vu[ 0 ], vu[ 1 ], xnode );

			e = this.elm;
			if( p === 'width'  ) v = e.offsetWidth;
			if( p === 'height' ) v = e.offsetHeight;
			if( p === 'top'    ) v = e.offsetTop;
			if( p === 'bottom' ) v = e.offsetBottom;
			if( p === 'left'   ) v = e.offsetLeft;
			if( p === 'right'  ) v = e.offsetRight;
			u = _getUnit( x, p );
			// alert( p + XDomStyle._Util.pxTo( v, u ) + u )
			return new Property( p, XDomStyle._Util.pxTo( v, u ), u, xnode );
		}; */
		if( p === 'fontSize' && ( v = XDomStyle._FONT_SIZE_RATIO[ x ] ) ){ // xx-small 等
			return new Property( p, v, 'px', xnode );
		};
		if( PARAMS.offset[ p ] || PARAMS.percent[ p ] || PARAMS.size[ p ] ){
			vu = XDomStyle._splitValueAndUnit( x );
			return new Property( p, vu[ 0 ], vu[ 1 ], xnode );
		};

		if( PARAMS.color[ p ] ) return new ColorProperty( p, x );
	},
	
	_splitValueAndUnit : function( v ){
		var num, _num, u;
		if( X.Type.isNumber( v ) ) return [ v || 0, '' ];
		if( isNaN( num = parseFloat( v ) ) ) return [ 0, '' ];
		_num = '' + num;
		if( _num.indexOf( '0.' ) === 0 ) _num = _num.slice( 1 );
		u = v.substr( v.indexOf( _num ) + _num.length );
		return [ num, X.Dom.Style.UNIT[ u ] ? u : 'px' ];
	}
};

X.Dom.Style._GET_VALUE_WITH_UNIT = {
	borderWidth  : X.Dom.Style.Type.QUARTET | X.Dom.Style.Type.LENGTH,
	//borderStyle  : X.Dom.Style.Type.QUARTET,
	borderRadius : X.Dom.Style.Type.QUARTET | X.Dom.Style.Type.LENGTH,
	margin       : X.Dom.Style.Type.QUARTET | X.Dom.Style.Type.LENGTH  | X.Dom.Style.Type.PERCENT,
	padding      : X.Dom.Style.Type.QUARTET | X.Dom.Style.Type.LENGTH  | X.Dom.Style.Type.PERCENT,
	clip         : X.Dom.Style.Type.QUARTET | X.Dom.Style.Type.LENGTH  | X.Dom.Style.Type.PERCENT,
	
	backgroundColor    : X.Dom.Style.Type.COLOR,
	backgroundPosition : X.Dom.Style.Type.COMBI,
	
	// boxShadow
	
	fontSize      : X.Dom.Style.Type.LENGTH,
	lineHeight    : X.Dom.Style.Type.LENGTH | X.Dom.Style.Type.PERCENT | X.Dom.Style.Type.NUMERICAL,
	textIndent    : X.Dom.Style.Type.LENGTH,
	letterSpacing : X.Dom.Style.Type.LENGTH,
	wordSpacing   : X.Dom.Style.Type.LENGTH,
	/*
	textShadowColor   : X.Dom.Style.Type.COLOR,
	textShadowOffsetX : X.Dom.Style.Type.LENGTH,
	textShadowOffsetY : X.Dom.Style.Type.LENGTH,
	textShadowBlur    : X.Dom.Style.Type.LENGTH, */
	
	width         : X.Dom.Style.Type.LENGTH | X.Dom.Style.Type.PERCENT,
	height        : X.Dom.Style.Type.LENGTH | X.Dom.Style.Type.PERCENT,
	
	left          : X.Dom.Style.Type.LENGTH | X.Dom.Style.Type.PERCENT,
	top           : X.Dom.Style.Type.LENGTH | X.Dom.Style.Type.PERCENT,
	bottom        : X.Dom.Style.Type.LENGTH | X.Dom.Style.Type.PERCENT,
	right         : X.Dom.Style.Type.LENGTH | X.Dom.Style.Type.PERCENT,
	
	// table
	borderSpacing : X.Dom.Style.Type.LENGTH
};

	
X.Dom.Style.SPECIAL_FIX =
	// ~IE8
	X.UA.IE && X.UA.IE < 9 ?
		(function( obj ){
			var test    = X.Dom.Style.SPECIAL_FIX_PROP,
				filters = [],
				n       = -1,
				p, id, v, dir;
			for( p in obj ){
				if( !( id = test[ p ] ) ) continue;
				v = obj[ p ];
				switch( id ){
					case 1 : //'filter' :
						filters[ ++n ] = v;
						break;
					case 2 : //'opacity' :
						filters[ ++n ] = 'alpha(opacity=' + v * 100 +')';
						break;
					case 3 : //'boxShadow' :
						// box-shadow: 10px 10px 10px 10px rgba(0,0,0,0.4) inset;
						//　スペース区切りで、水平方向の距離 垂直方向の距離 ぼかし距離 広がり距離 影の色 insetキーワードを指定する。 ぼかし距離 広がり距離 影の色 insetキーワードは省略可
						// shadow(color=#cccccc, strength=10, direction=135);
						v = X.Dom.Style._getProperty( this, css, 'px', 'boxShadow' );
						dir = Math.atan2( v[ 1 ], v[ 0 ] ) * 180 / Math.PI + 90;
						dir += dir < 0 ? 360 : 0;
						filters[ ++n ] = 'shadow(color=' + v[ 4 ] + ',strength=' + v[ 3 ] + ',direction=' + dir + ')';
						break;
					case 4 : //'textShadow' :
						//text-shadow: 5px 5px 2px blue; 水平方向の距離 垂直方向の距離 影のぼかし半径 影の色 none
						//glow(Color=yellow,Strength=10);
						//どうやらCSSのbackgroundプロパティと同時に使えないようです。 
						
						
						break;
					case 5 : //'backgroundImage' :
						//
				};
			};
			return filters.join( ' ' );
		}) :
	// IE9 textShadow に filter を使用
	X.UA.IE && 9 <= X.UA.IE && X.UA.IE < 10 ?
		(function( obj ){
			var test    = X.Dom.Style.SPECIAL_FIX_PROP,
				filters = [], p, id, v;
			for( p in obj ){
				if( !( id = test[ p ] ) ) continue;
				v = obj[ p ];
				switch( id ){
					case 1 : //'filter' :
						filters[ filters.length ] = v;
						break;
				};
			};
			if( filters ) return filters.join( ' ' );
		}) :
		(function( obj ){
			var test    = X.Dom.Style.SPECIAL_FIX_PROP,
				ret = [], p, id, v;
			for( p in obj ){
				if( !( id = test[ p ] ) ) continue;
				v = obj[ p ];
				switch( id ){
					case 1 : //'backgroundPositionX' :
						bgpX = v;
						break;
					case 2 : //'backgroundPositionY' :
						bgpY = v;
						break;
					case 3 : //'backgroundPositionX' :
						clipT = v;
						break;
					case 4 : //'backgroundPositionX' :
						clipB = v;
						break;
					case 5 : //'backgroundPositionX' :
						clipL = v;
						break;
					case 6 : //'backgroundPositionX' :
						clipR = v;
						break;
				};
			};
			if( bgpX || bgpY ) ret[ ret.length ] = 'background-position:';
			if( clipT || clipB || clipL || clipR ){
				ret[ ret.length ] = 'clip:rect(';
			};
			return ret.join( ';' );
		});




// export
// name getter
// unitID, name 単位指定のプロパティ取得 geter
// obj setter
// name, value setter

X.Dom.Node.prototype.css = function( nameOrObj /* orUnitID, valuOrUnitOrName */ ){
	var XDomStyle = X.Dom.Style,
		args = arguments,
		css  = this._css,
		p, name, v, camelize, unit, ieFix;
	if( this._xnodeType !== 1 ) return this;
// setter:object
	if( X.Type.isObject( nameOrObj ) ){
		if( !css ) css = this._css = {};
		camelize = XDomStyle.camelize;
		ieFix    = X.Dom.Style.IE_FILTER_FIX;
		for( p in nameOrObj ){
			if( ieFix[ p ] ){
				this._dirty |= X.Dom.Dirty.IE_FILTER;
			};
			v = nameOrObj[ p ];
			v || v === 0 ? css[ camelize( p ) ] = v : delete css[ camelize( p ) ];
			if( p === 'display' ){
				v === 'none' ? ( this._state |= X.Dom.State.IE5_DISPLAY_NONE_FIX ) : ( this._state &= ~X.Dom.State.IE5_DISPLAY_NONE_FIX );
				v === 'none' ? ( this._state |= X.Dom.State.DISPLAY_NONE ) : ( this._state &= ~X.Dom.State.DISPLAY_NONE );
			};
		};
		this._dirty |= X.Dom.Dirty.CSS;
		this.parent && this._reserveUpdate();
		delete this._cssText;
		return this;
	} else
	if( 1 < args.length ){
		if( !XDomStyle.UNIT[ nameOrObj ] ){
// setter name, value
			if( !css ) css = this._css = {};
			name = XDomStyle.camelize( nameOrObj );
			v    = args[ 1 ];
			if( css[ name ] === v ) return this;
			if( X.Dom.Style.IE_FILTER_FIX[ name ] ){
				this._dirty |= X.Dom.Dirty.IE_FILTER;
			};
			if( !v && v !== 0 ){
				delete css[ name ];
			} else {
				css[ name ] = v;
			};
			delete this._cssText;
			this._dirty |= X.Dom.Dirty.CSS;
			if( name === 'display' ){
				v === 'none' ? ( this._state |= X.Dom.State.IE5_DISPLAY_NONE_FIX ) : ( this._state &= ~X.Dom.State.IE5_DISPLAY_NONE_FIX );
				v === 'none' ? ( this._state |= X.Dom.State.DISPLAY_NONE ) : ( this._state &= ~X.Dom.State.DISPLAY_NONE );
			};
			// parent でなく this._root! でなくて this._state & in tree
			this.parent && this._reserveUpdate();
			return this;
		};
// getter unit
// unit 付の値取得は fontSize と 画像サイズが確定していないと正確に取れない。内部のみにする？
		if( !css ) return;
		if( !XDomStyle._GET_VALUE_WITH_UNIT[ name = XDomStyle.camelize( args[ 1 ] ) ] ) return null;
		p = XDomStyle._getProperty( this, css, nameOrObj, name );
		v = p.pxTo( nameOrObj );
		p.kill();
		return v;
	};
// getter
	if( !css ) return;
	// 集計 border, padding, margin, backgroundPosition, clip
	// border で正確なデータを返せない時は、null を返す
	return css[ XDomStyle.camelize( nameOrObj ) ];
};

X.Dom.Node.prototype.cssText = function( v ){
	var obj, i, l, attr, name;
	if( v === '' ){
		delete this._css;
		this._state &= ~X.Dom.State.IE5_DISPLAY_NONE_FIX;
		this._dirty |= X.Dom.Dirty.CSS;
		this.parent && this._reserveUpdate();
		delete this._cssText;
		return this;
	} else
	if( X.Type.isString( v ) ){
		delete this._css;
		this._state &= ~X.Dom.State.IE5_DISPLAY_NONE_FIX;
		obj = {};
		v   = v.split( ';' );
		for( i = 0, l = v.length; i < l; ++i ){
			attr = v[ i ].split( ':' );
			( name = attr[ 0 ] ) && ( obj[ name ] = attr[ 1 ] || true );
		};
		return this.css( obj );
	};
	// getter
	if( this._dirty & X.Dom.Dirty.CSS && !( this._cssText = X.Dom.Style.objToCssText( this._css ) ) ){
		delete this._cssText;
	};
	return this._cssText;
};

/*
 * ここでは HTMLElement のチ1ェックは行わない！
 * TODO
 * body に css attr がセットされた場合には X.Dom.baseFontSize をクリア
 */

X.Dom.Node.prototype._getCharSize =
	window.getComputedStyle ?
		(function(){
			Node.root._updateTimerID && Node.root._startUpdate();
			if( this === Node.root && X.Dom.baseFontSize ) return X.Dom.baseFontSize;
			if( this._fontSize ) return this._fontSize;
			return this._fontSize = parseFloat( getComputedStyle( this._rawNode, null ).fontSize );
		}) :
	document.defaultView && document.defaultView.getComputedStyle ?
		(function(){
			Node.root._updateTimerID && Node.root._startUpdate();
			if( this === Node.root && X.Dom.baseFontSize ) return X.Dom.baseFontSize;
			if( this._fontSize ) return this._fontSize;
			return this._fontSize = parseFloat( document.defaultView.getComputedStyle( this._rawNode, null ).fontSize );
		}) :
	X.UA.IE && 5.5 <= X.UA.IE ?
		(function(){
			var font, vu, v, u, _v;
			Node.root._updateTimerID && Node.root._startUpdate();
			if( this === Node.root && X.Dom.baseFontSize ) return X.Dom.baseFontSize;
			if( this._fontSize ) return this._fontSize;
			
			font = this._rawNode.currentStyle.fontSize;
			//font = this._css && this._css.fontSize || '1em';
			vu   = X.Dom.Style._splitValueAndUnit( font );
			v    = vu[ 0 ];
			u    = vu[ 1 ];

			if( v === 0 ){
				if( v = X.Dom.Style._FONT_SIZE_RATIO[ font ] ) return this._fontSize = v;
			} else {
				if( _v = X.Dom.Style._UNIT_RATIO[ u ] ) return this._fontSize = v / _v;
			};
			switch( u ){
				case 'px' :
					return this._fontSize = v;
				case 'em' :
				// body まで辿ってしまった場合は？
					if( this.parent ) return this._fontSize = this.parent._getCharSize() * v;
					break;
				case '%' :
				// body まで辿ってしまった場合は？
					if( this.parent ) return this._fontSize = this.parent._getCharSize() * v / 100;
			};
			return 0;
		}) :
	X.Dom.DOM_W3C ?
		(function(){
			var elm, v;
			Node.root._updateTimerID && Node.root._startUpdate();
			if( this === Node.root && X.Dom.baseFontSize ) return X.Dom.baseFontSize;
			if( this._fontSize ) return this._fontSize;

			this._rawNode.appendChild( elm = document.createElement( 'span' ) );
			elm.style.cssText = 'display:block;position:absolute;top:0;left:0;visivility:hidden;line-height:1;height:1em;';
			elm.innerHTML = 'X';
			v = elm.offsetHeight;
			this._rawNode.removeChild( elm );
			return this._fontSize = v;
		}) :
	X.Dom.DOM_IE4 ?
		(function(){
			var font, vu, v, u, _v;
			Node.root._updateTimerID && Node.root._startUpdate();
			if( this === Node.root && X.Dom.baseFontSize ) return X.Dom.baseFontSize;
			if( this._fontSize ) return this._fontSize;
			
			if( this._css && ( font = this._css.fontSize ) ){
				vu = X.Dom.Style._splitValueAndUnit( font );
				v  = vu[ 0 ];
				u  = vu[ 1 ];
				
				if( v === 0 ){
					if( _v = X.Dom.Style._FONT_SIZE_RATIO[ font ] ) return this._fontSize = _v;
				} else {
					if( _v = X.Dom.Style._UNIT_RATIO[ u ] ) return this._fontSize = v / _v;
				};
			} else {
				v = 1;
				u = 'em';
			};

			switch( u ){
				case 'px' :
					return this._fontSize = v;
				case 'em' :
				// body まで辿ってしまった場合は？
					if( this.parent ) return this._fontSize = this.parent._getCharSize() * v;
					break;
				case '%' :
				// body まで辿ってしまった場合は？
					if( this.parent ) return this._fontSize = this.parent._getCharSize() * v / 100;
			};
			return 0;
		}) :
		(function(){
			var elm, v;
			if( this === Node.root && X.Dom.baseFontSize ) return X.Dom.baseFontSize;
			Node.root._updateTimerID && Node.root._startUpdate();
			if( this._fontSize ) return this._fontSize;
			
			elm = this._rawNode || this._ie4getRawNode();
			elm.insertAdjacentHTML( 'BeforeEnd', '<span style="visivility:hidden;line-height:1;">X</span>' );
			elm = elm.children[ elm.children.length - 1 ];
			v   = elm.offsetHeight;
			elm.outerHTML = '';
			return this._fontSize = v * 0.75;
		});


X.Dom.listenOnce( X.Dom.Event.DOM_PRE_INIT, function(){
	var testStyle = X.Dom._root.style;
	
	X.Dom.Style.VENDER_PREFIX = (function(){
		var ret       = {},
			vendors   = 'webkit,Webkit,Moz,moz,ms,Ms,O,o,khtml,Khtml'.split( ',' ),
			searches  =
				'opacity,boxSizing,' +
				'transform,transformOrigin,perspective,' +
				'transisiton,transitionDelay,transitionProperty,transitionDuration,transitionTimingFunction,' +
				'userSelect,touchAction,touchCallout,contentZooming,userDrag,tapHighlightColor'.split( ',' ),
			vendor, i, search, prop;
		// 
		vendors.unshift( '' );
		
		function findVenderPrefix( prop ){
			var v, i = vendors.length;
			vendor = null;
			for( ; i; ){
				v = vendors[ --i ];
				if( testStyle[ v + prop ] !== undefined ){
					vendor = v;
					return v + prop;
				};
			};	
		};
		
		for( i = searches.length; i; ){
			search = searches[ --i ];
			prop = findVenderPrefix( search );
			if( search === 'transform' ) ret.transVender = vendor;
			if( prop ) ret[ search ] = prop;
		};
		return ret;
	})();
	
	X.Dom.Style.SPECIAL_FIX_PROP =
		// ~IE8
		X.UA.IE && X.UA.IE < 9 ?
			{
				filter          : 1,
				opacity         : 2//, uinode ChromeNode で行う
				//boxShadow       : 3,
				//textShadow      : 4,
				//backgroundImage : 5
			} :
		// IE9
		X.UA.IE && 9 <= X.UA.IE && X.UA.IE < 10 ?
			{
				filter          : 1//,
				//textShadow      : 1
			} :
		{
			backgroundPositionX : testStyle.backgroundPositionX === undefined ? 3 : 0,
			backgroundPosiitonY : testStyle.backgroundPositionX === undefined ? 3 : 0,
			clipTop             : testStyle.clipTop === undefined && testStyle[ 'clip-top' ] === undefined ? 3 : 0,
			clipBottom          : testStyle.clipTop === undefined && testStyle[ 'clip-top' ] === undefined ? 4 : 0,
			clipLeft            : testStyle.clipTop === undefined && testStyle[ 'clip-top' ] === undefined ? 5 : 0,
			clipRight           : testStyle.clipTop === undefined && testStyle[ 'clip-top' ] === undefined ? 6 : 0
		};
} );

X.Dom.listenOnce( X.Dom.Event.DOM_INIT, function(){
	var xnode  = Node._systemNode,
		output = X.Dom.Style._UNIT_RATIO = {},
		list   = 'cm,mm,in,pt,pc'.split( ',' ),
		unit,size, base, i;
	
	for( i = list.length; i; ){
		unit = list[ --i ];
		output[ unit ] = xnode.css( 'width', 10 + unit ).width() / 10;
	};

	output = X.Dom.Style._FONT_SIZE_RATIO = {},
	list   = 'xx-large,x-large,large,larger,medium,small,smaller,x-small,xx-small'.split( ',' );
	xnode.css( { lineHeight : '100%', height : '1em' } ).text( 'X' );
	
	for( i = list.length; i; ){
		size = list[ --i ];
		output[ size ] = xnode.css( 'fontSize', size ).height();// / base;
	};
	
	// 以下解決、scroll 中に timer が無視される iOS の問題が原因(dom追加で起こったスクロール?)
	// ipod touch 1st で必要なんですけど、、、
	//xnode._rawNode.style.cssText = ''; 
	xnode.cssText( '' ).empty(); //._startUpdate();
} );

