<?php
require_once('PHPUnit.php');
require_once('DB.php');
require_once('PHPUnit_DB.php');
require_once('testdata.php');
require_once('actual.php');

define('DSN', null);
define('IMPORT_ENCODING', null);
define('EXPORT_ENCODING', null);

class PHPUnit_DB_Test extends PHPUnit_TestCase {
    var $tool;
    function PHPUnit_DB_Test($name)
    {
        $this->PHPUnit_TestCase($name);
    }
    function setUp()
    {
        $this->tool = new PHPUnit_DB_Tool(DSN);
        
        $this->clearTable('zipcode_tokyo');
        $this->clearTable('zipcode_kanagawa');
        $this->clearTable('zipcode_aichi');
    }
    /**
     * ˥ݡȤ뤳Ȥǧޤ
     */
    function testImportSuccess()
    {
        global $testdata;
        $d = $testdata;
        
        $this->assertEquals(0, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(0, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(0, $this->getCount('zipcode_aichi'));
        
        $result = $this->tool->importTables($d, IMPORT_ENCODING);
        
        $this->assertTrue($result, var_export($result, true));
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
    }
    /**
     * ݡȤǼԤˡƤΥݡȤ̵äȤˤʤ뤳Ȥǧޤ
     */
    function testImportFail()
    {
        global $testdata;
        $d = $testdata;
        
        $d['hoge'] = array();
        
        $this->assertEquals(0, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(0, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(0, $this->getCount('zipcode_aichi'));
        
        $result = $this->tool->importTables($d, IMPORT_ENCODING);
        
        $this->assertTrue(PEAR::isError($result), $result->toString());
        $this->assertEquals(0, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(0, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(0, $this->getCount('zipcode_aichi'));
    }
    /**
     * ˥ꥢ뤳Ȥǧޤ
     */
    function testClearSuccess()
    {
        global $testdata;
        $d = $testdata;
        
        $result = $this->tool->importTables($d, IMPORT_ENCODING);
        
        $this->assertTrue($result, var_export($result, true));
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
        
        $result = $this->tool->clearTables(array('zipcode_tokyo', 'zipcode_aichi'));
        
        $this->assertTrue($result, var_export($result, true));
        $this->assertEquals(0, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(0, $this->getCount('zipcode_aichi'));
    }
    /**
     * ꥢǼԤ硢ƤΥꥢ̵äȤˤʤ뤳Ȥǧޤ
     */
    function testClearFail()
    {
        global $testdata;
        $d = $testdata;
        
        $result = $this->tool->importTables($d, IMPORT_ENCODING);
        
        $this->assertTrue($result, var_export($result, true));
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
        
        $result = $this->tool->clearTables(array('zipcode_tokyo', 'hoge', 'zipcode_aichi'));
        
        $this->assertTrue(PEAR::isError($result), $result->toString());
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
    }
    /**
     * ˥ݡȤ뤳Ȥǧޤ
     */
    function testExportSuccess()
    {
        global $testdata;
        $d = $testdata;
        global $actual;
        
        $result = $this->tool->importTables($d, IMPORT_ENCODING);
        
        $this->assertTrue($result, var_export($result, true));
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
        
        $exportData = $this->tool->exportTables(array('zipcode_tokyo', 'zipcode_kanagawa', 'zipcode_aichi'), EXPORT_ENCODING);
        
        $this->assertEquals($actual, $exportData);
    }
    /**
     * ݡȤǼԤ硢 PEAR_Error ֥Ȥ֤뤳Ȥǧޤ
     */
    function testExportFail()
    {
        global $testdata;
        $d = $testdata;
        
        $result = $this->tool->importTables($d, IMPORT_ENCODING);
        
        $this->assertTrue($result, var_export($result, true));
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
        
        $exportData = $this->tool->exportTables(array('zipcode_tokyo', 'hoge', 'zipcode_kanagawa', 'zipcode_aichi'), EXPORT_ENCODING);
        
        $this->assertTrue(PEAR::isError($exportData));
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
    }
    function getCount($tableName)
    {
        $conn = $this->tool->getConnection();
        if (PEAR::isError($conn)) {
            die($conn->toString());
        }
        $cnt = $conn->getOne("SELECT COUNT(*) FROM $tableName");
        if (PEAR::isError($cnt)) {
            die($cnt->toString());
        }
        $conn->disconnect();
        return $cnt;
    }
    function clearTable($tableName)
    {
        $conn = $this->tool->getConnection();
        if (PEAR::isError($conn)) {
            die($conn->toString());
        }
        $result = $conn->query("DELETE FROM $tableName");
        if (PEAR::isError($result)) {
            die($result->toString());
        }
        $conn->disconnect();
    }
}

$suite = new PHPUnit_TestSuite('PHPUnit_DB_Test');
$result = PHPUnit::run($suite);
echo $result->toString();
?>
