#ifndef _XML_SOCKET_H
#define _XML_SOCKET_H

#include <pthread.h>

typedef struct {
    int socket_fd;
    FILE* fp;
    char *host;
    unsigned short port;
    int (*OnRecieve)(char* xml_msg, void *data);
    void *data;
    pthread_t thread;
} XML_SOCKET;

XML_SOCKET *xml_socket_open(const char *host, unsigned short port, int (*OnRecieve)(char* xml_msg, void *data), void *data);
int xml_socket_close(XML_SOCKET *session);
int xml_socket_request(XML_SOCKET *session, const char* value);
int xml_socket_retrieve(XML_SOCKET *session);

#endif /* _XML_SOCKET_H */