#ifndef _HTTP_H
#define _HTTP_H

#define HTTP_GET 0
#define HTTP_POST 1

typedef struct {
    float version;
    int socket_fd;
    FILE* fp;
    const char *host;
    const char *path;
    unsigned short port;
} HTTP;

HTTP *http_open(const char *host, const char *path, unsigned short port);
int http_request(HTTP *session, unsigned short mode,
                 const char* cookie, const char* user_agent,
                 const char* value);
int http_retrieve_text(HTTP *session, char* header, char* contents);
int http_close(HTTP *session);


#endif /* _HTTP_H */