#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <libxml/xmlreader.h>

#include "http.h"
#include "XmlSocket.h"

#include "playerstatus.h"
#include "nicolive_comment.h"

//  現在パース中のノード名
typedef enum {
    STATE_NONE,
    STATE_ERROR,//error
    STATE_CHAT,//description
    STATE_THREAD,//thread
    STATE_CHAT_RESULT//chat_result
} parsingStatus;


//  1つのノードを処理する
static void processNode(xmlTextReaderPtr reader, CHAT_INFO* info)
{
    static parsingStatus state = STATE_NONE;
    //static CHAT_COMMENT *cmt = (CHAT_COMMENT *)malloc(sizeof(CHAT_COMMENT));
    static CHAT_COMMENT cmt_b;
    CHAT_COMMENT *cmt = &cmt_b;
    xmlElementType nodeType;
    xmlChar *name, *value;
    
    //  ノード情報の取得
    nodeType = xmlTextReaderNodeType(reader);       //  ノードタイプ
    name = xmlTextReaderName(reader);               //  ノード名
    
    if (!name)
        name = xmlStrdup(BAD_CAST "---");
    //    printf("Node name:%s\n", name);
    if (nodeType == XML_READER_TYPE_ELEMENT) {              //  開始
        if ( xmlStrcmp(name, BAD_CAST "chat") == 0 ) {
            sscanf((const char *)xmlGetProp(xmlDocGetRootElement(xmlTextReaderCurrentDoc(reader)),"no"), "%d", &((*cmt).no));
            sscanf((const char *)xmlGetProp(xmlDocGetRootElement(xmlTextReaderCurrentDoc(reader)),"vpos"), "%d", &((*cmt).vpos));
            sscanf((const char *)xmlGetProp(xmlDocGetRootElement(xmlTextReaderCurrentDoc(reader)),"date"), "%ld", &((*cmt).date));
            (*cmt).user_id = (char *) xmlGetProp(xmlDocGetRootElement(xmlTextReaderCurrentDoc(reader)),"user_id");
            (*info).start_time = (time_t) ((long)time(NULL) - ((*cmt).vpos)/100);
            state = STATE_CHAT;
        } else if ( xmlStrcmp(name, BAD_CAST "thread") == 0 ) {
            //<thread resultcode="0" thread="1301734709" last_res="7" ticket="0xd76c900" revision="1" server_time="1380761746"/>
            //xmlChar *resultcode = xmlGetProp(xmlDocGetRootElement(xmlTextReaderCurrentDoc(reader)),"resultcode");
            sscanf((const char *)xmlGetProp(xmlDocGetRootElement(xmlTextReaderCurrentDoc(reader)),"resultcode"), "%hd", &((*info).resultcode));
            sscanf((const char *)xmlGetProp(xmlDocGetRootElement(xmlTextReaderCurrentDoc(reader)),"last_res"), "%d", &((*info).last_res));
            sscanf((const char *)xmlGetProp(xmlDocGetRootElement(xmlTextReaderCurrentDoc(reader)),"ticket"), "0x%lx", &((*info).ticket));
            //xmlChar *last_res = xmlGetProp(xmlDocGetRootElement(xmlTextReaderCurrentDoc(reader)),"last_res");
            //xmlChar *ticket = xmlGetProp(xmlDocGetRootElement(xmlTextReaderCurrentDoc(reader)),"ticket");
            
            //            printf("resultcode: %hd\nlast_res: %d\nticket: 0x%x\n",(*info).resultcode,(*info).last_res,(*info).ticket);
            state = STATE_THREAD;
        }
        
    } else if (nodeType == XML_READER_TYPE_END_ELEMENT) {   //  終了
        if ( xmlStrcmp(name, BAD_CAST "getplayerstatus") == 0 ) {
            printf("-----------------------\n");
        }
        
        state = STATE_NONE;
        
    } else if (nodeType == XML_READER_TYPE_TEXT) {          //  テキスト
        //  テキストを取得する
        value = xmlTextReaderValue(reader);
        
        if (!value)
            value = xmlStrdup(BAD_CAST "---");
        
        if ( state == STATE_ERROR ) {/////////// ToDo: switch-caseに書き換え
            printf("[ERROR] Reason: %s\n", value);
            return;
        } else if ( state == STATE_CHAT ) {
            //printf("chat: %s\n", value);
            
            (*cmt).contents = (char *) value;
            (*info).comment_evt(cmt, (*info).data);
        } else if ( state == STATE_THREAD ) {
            printf("thread: %s\n", value);
            //(*session).description = (char*)malloc( strlen(value) + 1 );
            //strcpy((*session).description, value);
        }
        
        xmlFree(value);
    }
    
    xmlFree(name);
}

static int callback(char* xml_msg, void *data){
    CHAT_INFO *info = (CHAT_INFO *)data;
    
    xmlTextReaderPtr reader;
    int ret;
    printf("%s", xml_msg);
    reader = xmlReaderForDoc((xmlChar*)xml_msg, NULL, NULL, 1);
    if ( !reader ) {
        printf("Failed to open XML\n");
        return -1;
    }
    
    
    //  次のノードに移動
    ret = xmlTextReaderRead(reader);
    while (ret == 1) {
        //  現在のノードを処理
        processNode(reader, info);
        
        //  次のノードに移動
        ret = xmlTextReaderRead(reader);
    }
    
    //  Reader のすべてのリソースを開放
    xmlFreeTextReader(reader);
    
    //  xmlTextReaderRead の戻り値が -1 だった場合はパースエラー
    if (ret == -1) {
        printf("Parse error.\n");
        return -1;
    }
    
    //   printf("%s\n", xml_msg);
    
    return 0;
}

int nicolive_comment_is_ready(CHAT_INFO *info)
{
    return (( (*info).resultcode )? ((*info).resultcode) : ((*info).postkey==0)?-1:0 ); //if resultcode is other than 0, resultcode. else whether or not post key is ready.
}

CHAT_INFO *nicolive_comment_open(char* comment_server, unsigned short port, int thread, int (*OnRecieve)(CHAT_COMMENT* cmt, void *data), void *data)
{
    CHAT_INFO *info = (CHAT_INFO*)malloc( sizeof(CHAT_INFO) );
    
    (*info).comment_evt = OnRecieve;
    (*info).data = data;
    (*info).thread = thread;
    
    XML_SOCKET *soc = xml_socket_open(comment_server, port, callback, info);
    printf("Connection made\n");
    
    char initial_req[128];
    sprintf(initial_req, "<thread thread=\"%d\" version=\"20061206\" res_from=\"-1\" />", thread);
    xml_socket_request(soc, initial_req);
    
    printf("Sent request\n");
    
    xml_socket_retrieve(soc);
    
    (*info).soc = soc;
    
    return info;
}

int nicolive_comment_send(CHAT_INFO *info, char* comment)
{
    //printf("%ld\n", (long)(*info).start_time);
    //difftime(time(NULL), (*info).start_time);
    //long now = ;
    int vpos = (int)((long)time(NULL) - (long)(*info).start_time) * 100;
    printf("[vpos]%ld\n", vpos);
    char req[256];
    
    sprintf(req, "<chat thread=\"%d\" ticket=\"0x%x\" vpos=\"%d\" postkey=\"%s\" mail=\" \" user_id=\"%s\" premium=\"%d\">%s</chat>", (*info).thread, (*info).ticket, vpos, (*info).postkey, ((NICO_LIVE *)(*info).data)->user_id, ((NICO_LIVE *)(*info).data)->is_premium, comment);
    //printf("[in nicolive, Send]%s\n", req);
    
    xml_socket_request((*info).soc, req);
    return 0;
}

int nicolive_comment_close(CHAT_INFO *info)
{
    xml_socket_close((*info).soc);
    free(info);
    return 0;
}