#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/param.h>
#include <sys/uio.h>
#include <unistd.h>

#include "http.h"


HTTP *http_open(const char *host, const char *path, unsigned short port)
{
    
    if((host == 0)||(path == 0))    /* リクエスト先確認機構 */
    {
        return -1;
    }

    struct hostent *servhost;            /* ホスト名と IP アドレスを扱うための構造体 */
    struct sockaddr_in server;           /* ソケットを扱うための構造体 */
    struct servent *service;             /* サービス (http など) を扱うための構造体 */
    FILE *fp;                            /* ソケット用の FILE 構造体 */
    int s;                               /* ソケットのためのファイルディスクリプタ */
    
    HTTP *session = (HTTP*)malloc( sizeof(HTTP) );                       /* 通信用の HTTP 構造体 */

    
    printf("http://%s%s を取得します。\n\n",host, path);
    
    /* ホストの情報(IPアドレスなど)を取得 */
    servhost = gethostbyname(host);
    if ( servhost == NULL ){
        fprintf(stderr, "[ERROR] IP LOOKUP FOR %s FAILED.\n", host);
        return -1;
    }
    
    bzero((char *)&server, sizeof(server));     /* 構造体をゼロクリア */
    
    server.sin_family = AF_INET;
    
    /* IPアドレスを示す構造体をコピー */
    bcopy(servhost->h_addr, (char *)&server.sin_addr, servhost->h_length);
    
    server.sin_port = htons(port);

    /* ソケット生成 */
    if ( ( s = socket(AF_INET, SOCK_STREAM, 0) ) < 0 ){
        fprintf(stderr, "[ERROR] Socket creation failed.\n");
        return -1;
    }
    /* サーバに接続 */
    if ( connect(s, (struct sockaddr *)&server, sizeof(server)) == -1 ){
        fprintf(stderr, "[ERROR] Connection was not established.\n");
        return -1;
    }
    /* FILE 構造体を作成 */
    fp = fdopen(s, "r+");
    if ( fp == NULL ){
        fprintf(stderr, "[ERROR] File descripter was not created from specified socket.\n");
        return -1;
    }
    /* バッファリング OFF */
    setvbuf(fp, NULL, _IONBF, 0);
    
    *session = (HTTP){1.1, s, fp, host, path, port};
    
    return session;
}

int http_close(HTTP *session)
{
    fclose((*session).fp);
    close((*session).socket_fd);
    
    free(session);
    
    return 0;
}

int http_request(HTTP *session, unsigned short mode,
                 const char* cookie, const char* user_agent,
                 const char* value)
{
    
    if (mode) { //HTTP_POST
                            printf("using post\n");
        fprintf((*session).fp, "POST %s%s HTTP/1.1\r\n", (*session).host, (*session).path);
        fprintf((*session).fp, "Host: %s:%d\r\n", (*session).host, (*session).port);
        fprintf((*session).fp, "User-Agent:%s\r\n", user_agent);
//        fprintf((*session).fp, "Accept:text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\r\n");
        fprintf((*session).fp, "Connection:keep-alive\r\n");
        fprintf((*session).fp, "Cookie:%s\r\n", cookie);
        fprintf((*session).fp, "\r\n");
        fprintf((*session).fp, "%s\r\n", value);
        fprintf((*session).fp, "\r\n");
    }else{ //HTTP_GET  -- I know its not the best lol bout it works
        fprintf((*session).fp, "GET %s HTTP/1.0\r\n", (*session).path);
        fprintf((*session).fp, "Cookie:%s\r\n",cookie);
        fprintf((*session).fp, "Host: %s:%d\r\n", (*session).host, (*session).port);
        fprintf((*session).fp, "\r\n");
    }
    
    return 0;
}
/*
 HTTP/1.1 200 OK
 
 x-niconico-authflag が 1　＝　ノーマル垢、　3　＝　プレミア
 
 
 */
int http_retrieve(HTTP *session)
{
    char buf[256];
    
    /* とりあえず受信して、表示するだけ */
    while (1){
        /* ToDo: NULL来ないこと　あり。タイムアウト必須 */
        if ( fgets(buf, sizeof(buf), (*session).fp) == NULL ){
            printf("end\n");
            break;
        }
        printf("%s", buf);
    }
    
    return 0;
}

int http_retrieve_text(HTTP *session, char* header, char* contents)
{
    char buf[256];
    
    int HTTP_status_code = 0;
    float HTTP_protocol_ver = 0;
    
    char on_contents = 0;

    int line = 0;
    
    /* 受信 */
    while (1){
        /* ToDo: NULL来ないこと　あり。タイムアウト必須 */
//        printf("in loop, %s\n",(on_contents)?"contents":"header"); //debug
        if ( fgets(buf, sizeof(buf), (*session).fp) == NULL ){ //読み込み
            //printf("end\n");//debug
            break;
        }
        //レスポンス部処理
        if (line == 0) { //first line, unlikely
            HTTP_protocol_ver = (buf[7] == '0')?1.0:1.1;
            HTTP_status_code = (buf[9] - ('0'))*100+(buf[10] - ('0'))*10+(buf[11] - ('0'));

            if (HTTP_status_code >= 400) {
                fprintf(stderr, "Server has returned an error. Aborting.. Code = %d\n", HTTP_status_code);
                break;
            }
            printf("Prot = %f,Code = %d\n",HTTP_protocol_ver,HTTP_status_code);
        }
        
        //
        if (!on_contents) { // header
            if (buf[0] == '\r') {//　空行でヘッダはおしまい。
                on_contents = 1;
            }else{
                strcat(header, buf);
            }
        } else { // body
                strcat(contents, buf);
        }
        
        line ++;
    }
    return HTTP_status_code;
}