#ifndef _NICOLIVE_COMMENT_H
#define _NICOLIVE_COMMENT_H

#include <time.h>
#include "XmlSocket.h"

typedef struct {
    int no;
    int vpos;
    unsigned long int date;
    char *user_id;
    char *contents;
} CHAT_COMMENT;

typedef struct {
    short int resultcode;
    time_t start_time;
    char *user_id;
    int thread;
    int last_res;
    unsigned long int ticket;
    char *postkey;
    XML_SOCKET *soc;
    int (*comment_evt)(CHAT_COMMENT* cmt, void *data);
    void *data;
} CHAT_INFO;

CHAT_INFO *nicolive_comment_open(char* comment_server, unsigned short port, int thread, int (*OnRecieve)(CHAT_COMMENT* cmt, void *data), void *data);
int nicolive_comment_send(CHAT_INFO *info, char* comment);
int nicolive_comment_close(CHAT_INFO *info);

#endif /* _NICOLIVE_COMMENT_H */