package jp.co.app.ynomoto.pmft;

import java.util.ArrayList;

import android.net.Uri;
import android.util.Log;

public class GChart {
	private final String URL = "http://chart.apis.google.com/chart";
	private String chs,chd, cht, chco, chtt, chdl, chxt, chxl, chg;
	
	// Google チャートへ渡すパラメータの作成
	public GChart(int maximumKw, ArrayList<Integer> actualToday, ArrayList<Integer> expectedToday){
		int graphMax = 6000;
		chs = "800x300";
		chd = "t:"+ toPercentage(maximumKw, graphMax) + "|" + toPercentage(actualToday, graphMax) + "|" + toPercentage(actualToday, graphMax);
		cht = "bvo";
		chco = "11210D,3D7930,A2C180";
		chtt = "「本日の電力グラフ(単位:万Kw)」";
		chdl = "ピーク時供給力|本日実績|本日予測";
		chxt = "x,y"; 
		chxl = "0:|0|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|1:|0|" + (graphMax / 2) + "|" + graphMax;
		chg = "25,-1";
	}
	
	private String toPercentage(int kWs, int graphMax){
		String percentages = (int)((float)kWs / graphMax * 100) + "";
		for(int i = 1; i < 24; i++){
			percentages += "," + (int)((float)kWs / graphMax * 100);
		}
		return percentages;
	}
	
	private String toPercentage(ArrayList<Integer> kWs, int graphMax){
		String percentages = (int)((float)kWs.get(0) / graphMax * 100) + "";
		for(int i = 1; i < 24; i++){
			percentages += "," + (int)((float)kWs.get(i) / graphMax * 100);
		}
		return percentages;
	}
	
	public Uri getChart() {
		String s = URL 
					+ "?" + "chs=" + chs 
					+ "&" + "chd=" + chd 
					+ "&" + "cht=" + cht 
					+ "&" + "chco=" + chco 
					+ "&" + "chtt=" + chtt 
					+ "&" + "chdl=" + chdl 
					+ "&" + "chxt=" + chxt
					+ "&" + "chxl=" + chxl
					+ "&" + "chg=" + chg;
		Log.v("jp.co.app.ynomoto.pmft.PowerMeter.GChart.getChart()", s);
		return Uri.parse(s);
	}
}
