package jp.co.app.ynomoto.pmft.activity;

import java.io.IOException;
import java.util.ArrayList;

import org.apache.http.client.ClientProtocolException;

import jp.co.app.ynomoto.pmft.R;
import jp.co.app.ynomoto.pmft.parser.TepcoParser;
import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity implements OnClickListener{
	private static final String UPDATE_INTENT = "jp.co.app.ynomoto.pmft.UPDATE";
	private TextView mUpdate;
	private TextView mPeakAvailabilityToday;
	private TextView mMaximumElectricPowerToday;
	private TextView mMessage;
	private Button mPerHourUsages;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

		mUpdate = (TextView)findViewById(R.id.update);
		mPeakAvailabilityToday = (TextView)findViewById(R.id.peakAvailabilityToday);
		mMaximumElectricPowerToday = (TextView)findViewById(R.id.maximumElectricPowerToday);
		mMessage = (TextView)findViewById(R.id.message);
		mPerHourUsages = (Button) findViewById(R.id.perHourUsages);
		setup();
	}
	
	private void setup(){
		SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(this);
		TepcoParser parser;
		
		try {
			parser = new TepcoParser(sharedPreferences.getString("csvUrl", "http://powermeter.sourceforge.jp/juyo-j.csv"));
			mUpdate.setText(parser.getUpdate().toString());
			mPeakAvailabilityToday.setText(parser.getPeakAvailabilityToday()
					.getTimeZones()
					+ " " + parser.getPeakAvailabilityToday().getPower());
			mMaximumElectricPowerToday.setText(parser
					.getMaximumElectricPowerToday().getTimeZones()
					+ " " + parser.getMaximumElectricPowerToday().getPower());
			ArrayList<String> strings = parser.getMessages();
			if (strings != null) {
				mMessage.setText(strings.get(0));
			} else {
				mMessage.setText(getString(R.string.activity_message_not_found));
			}
		} catch (ClientProtocolException e) {
			e.printStackTrace();
			Toast.makeText(this, getString(R.string.activity_error_network), Toast.LENGTH_SHORT).show();
		} catch (IOException e) {
			e.printStackTrace();
			Toast.makeText(this, getString(R.string.activity_error_network), Toast.LENGTH_SHORT).show();
		} 
		
		mPerHourUsages.setOnClickListener(this);

	}

	@Override
	public void onClick(View v) {
		Intent intent = new Intent(this, PerHourUsages.class);
		startActivity(intent); 	
	}
	
	    @Override
    public boolean onCreateOptionsMenu(Menu menu){
    	menu.add(1, 1, Menu.NONE, getString(R.string.activity_menu_preferences))
    	.setIcon(android.R.drawable.ic_menu_preferences);
    	
    	menu.add(1, 2, Menu.NONE, getString(R.string.activity_menu_refresh))
    	.setIcon(R.drawable.ic_menu_refresh);
    	
		return super.onCreateOptionsMenu(menu);
    }
    
    @Override
    public boolean onOptionsItemSelected(MenuItem item){
    	Intent intent;
    	switch (item.getItemId()) {
		case 1:
			intent = new Intent(this, PowerMeterPreference.class);
			startActivity(intent); 
			break;
		case 2:
			setup();
            intent=new Intent(UPDATE_INTENT);
            sendBroadcast(intent);
		default:
			break;
		}
	
		return true;	
    }
}
