package jp.co.app.ynomoto.pmft.activity;

import java.io.IOException;

import org.apache.http.client.ClientProtocolException;

import jp.co.app.ynomoto.pmft.R;
import jp.co.app.ynomoto.pmft.adapter.PerHourUsagesAdapter;
import jp.co.app.ynomoto.pmft.parser.TepcoParser;
import android.app.ListActivity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.Toast;

public class PerHourUsages extends ListActivity implements OnClickListener{
	Button mShowGraphButton;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.per_hour_usages);

		SharedPreferences sharedPreferences = PreferenceManager
				.getDefaultSharedPreferences(this);
		TepcoParser parser;
		try {
			parser = new TepcoParser(sharedPreferences.getString(
					"csvUrl", "http://powermeter.sourceforge.jp/juyo-j.csv"));
			PerHourUsagesAdapter adapter = new PerHourUsagesAdapter(this,
					R.layout.per_hour_usages_list, parser.getPerHourUsages());
			setListAdapter(adapter);
		} catch (ClientProtocolException e) {
			e.printStackTrace();
			Toast.makeText(this, getString(R.string.activity_error_network), Toast.LENGTH_SHORT);
		} catch (IOException e) {
			e.printStackTrace();
			Toast.makeText(this, getString(R.string.activity_error_network), Toast.LENGTH_SHORT);
		}

		mShowGraphButton = (Button) findViewById(R.id.showGraphButton);
		mShowGraphButton.setOnClickListener(this);
	}

	@Override
	public void onClick(View v) {
		Intent intent = new Intent(this, PerHourUsagesGraph.class);
		// intent に何か渡すならば
		// intent.putExtra("", );
		startActivity(intent); 
	}
}
