package jp.co.app.ynomoto.pmft.activity;

import java.io.IOException;
import java.util.ArrayList;

import org.apache.http.client.ClientProtocolException;

import jp.co.app.ynomoto.pmft.GChart;
import jp.co.app.ynomoto.pmft.R;
import jp.co.app.ynomoto.pmft.data.PerHourUsage;
import jp.co.app.ynomoto.pmft.parser.TepcoParser;
import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.webkit.WebView;
import android.widget.Toast;

public class PerHourUsagesGraph extends Activity {
	private WebView mWebView1;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.per_hour_usages_graph);

		mWebView1 = (WebView) findViewById(R.id.webView1);

		SharedPreferences sharedPreferences = PreferenceManager
				.getDefaultSharedPreferences(this);
		TepcoParser parser;
		try {
			parser = new TepcoParser(sharedPreferences.getString("csvUrl",
					"http://powermeter.sourceforge.jp/juyo-j.csv"));
			ArrayList<PerHourUsage> hourUsages = parser.getPerHourUsages();
			ArrayList<Integer> actualToday = new ArrayList<Integer>();
			ArrayList<Integer> expectedToday = new ArrayList<Integer>();
			for (PerHourUsage perHourUsage : hourUsages) {
				actualToday.add(perHourUsage.getActual());
				expectedToday.add(perHourUsage.getExpected());
			}

			GChart chart = new GChart(parser.getPeakAvailabilityToday()
					.getPower(), actualToday, expectedToday);
			String content = chart.getChart().toString();
			mWebView1.setScrollBarStyle(WebView.SCROLLBARS_INSIDE_OVERLAY);
			StringBuilder bufResult = new StringBuilder("<html>");
			bufResult.append("<head>");
			bufResult
					.append("<meta name=\"viewport\" content=\"target-densitydpi=high-dpi\" />");
			bufResult.append("</head>");
			bufResult.append("<body>");
			bufResult.append("<style type=\"text/css\">");
			bufResult.append("body {font-size: 18pt; margin: 0; padding: 0;}");
			bufResult.append("</style>");
			bufResult.append("<img src=\"");
			bufResult.append(content);
			bufResult.append("\" />");
			bufResult.append("</body></html>");
			mWebView1.loadDataWithBaseURL(null, bufResult.toString(),
					"text/html", "UTF-8", null);
		} catch (ClientProtocolException e) {
			e.printStackTrace();
			Toast.makeText(this, getString(R.string.activity_error_network),
					Toast.LENGTH_SHORT).show();
			finish();
		} catch (IOException e) {
			e.printStackTrace();
			Toast.makeText(this, getString(R.string.activity_error_network),
					Toast.LENGTH_SHORT).show();
			finish();
		}
	}
}
