package jp.co.app.ynomoto.pmft.adapter;

import java.util.ArrayList;

import jp.co.app.ynomoto.pmft.data.PerHourUsage;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class PerHourUsagesAdapter extends ArrayAdapter<PerHourUsage> {
	ArrayList<PerHourUsage> mHourUsages = null;
	Context mContext;
	LayoutInflater mInflater = null;
	int mTextViewResourceId;

	public PerHourUsagesAdapter(Context context, int textViewResourceId, ArrayList<PerHourUsage> hourUsages) {
		super(context, textViewResourceId, hourUsages);
		mHourUsages = hourUsages;
		mContext = context;
		mTextViewResourceId = textViewResourceId;
		mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}
	
	@Override
	public View getView(int position, View convertView, ViewGroup parent) {

		View row = convertView;
		if (row == null) {
			row = mInflater.inflate(mTextViewResourceId, parent, false);
		}
		
		TextView date = (TextView)row.findViewById(jp.co.app.ynomoto.pmft.R.id.date);
		TextView actual = (TextView)row.findViewById(jp.co.app.ynomoto.pmft.R.id.actual);
		TextView expected = (TextView)row.findViewById(jp.co.app.ynomoto.pmft.R.id.expected);
		
		date.setText(mHourUsages.get(position).getDate().toLocaleString());
		actual.setText(mHourUsages.get(position).getActual() + "");
		expected.setText(mHourUsages.get(position).getExpected() + "");

		return row;
	}

}
