package jp.co.app.ynomoto.pmft.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import jp.co.app.ynomoto.pmft.data.MaximumElectricPower;
import jp.co.app.ynomoto.pmft.data.PeakAvailability;
import jp.co.app.ynomoto.pmft.data.PerHourUsage;

import org.apache.http.client.ClientProtocolException;

import android.util.Log;

// コンストラクタでネットワークエラーが発生したならば、そのオブジェクトは null
public class TepcoParser {
	private final String LOG_TAG = "jp.co.app.ynomoto.pmft.TepcoParser";
	private Date update; // CSV の更新日時を保存
	private PeakAvailability peakAvailabilityToday = new PeakAvailability(); // ピーク時供給力(今日)
	private PeakAvailability peakAvailabilityTomorrow = new PeakAvailability(); // ピーク時供給力(明日)
	private MaximumElectricPower maximumElectricPowerToday = new MaximumElectricPower(); // 予想最大電力(今日)
	private MaximumElectricPower maximumElectricPowerTomorrow = new MaximumElectricPower(); // 予想最大電力(昨日)
	private ArrayList<PerHourUsage> perHourUsages = new ArrayList<PerHourUsage>(); // 一時間当たりの電力使用量
	private ArrayList<String> messages = new ArrayList<String>(); // 東京電力からのお知らせ
	
	public Date getUpdate() {
		return update;
	}

	public void setUpdate(Date update) {
		this.update = update;
	}

	public PeakAvailability getPeakAvailabilityToday() {
		return peakAvailabilityToday;
	}

	public void setPeakAvailabilityToday(PeakAvailability peakAvailabilityToday) {
		this.peakAvailabilityToday = peakAvailabilityToday;
	}

	public PeakAvailability getPeakAvailabilityTomorrow() {
		return peakAvailabilityTomorrow;
	}

	public void setPeakAvailabilityTomorrow(
			PeakAvailability peakAvailabilityTomorrow) {
		this.peakAvailabilityTomorrow = peakAvailabilityTomorrow;
	}

	public MaximumElectricPower getMaximumElectricPowerToday() {
		return maximumElectricPowerToday;
	}

	public void setMaximumElectricPowerToday(
			MaximumElectricPower maximumElectricPowerToday) {
		this.maximumElectricPowerToday = maximumElectricPowerToday;
	}

	public MaximumElectricPower getMaximumElectricPowerTomorrow() {
		return maximumElectricPowerTomorrow;
	}

	public void setMaximumElectricPowerTomorrow(
			MaximumElectricPower maximumElectricPowerTomorrow) {
		this.maximumElectricPowerTomorrow = maximumElectricPowerTomorrow;
	}

	public ArrayList<PerHourUsage> getPerHourUsages() {
		return perHourUsages;
	}

	public void setPerHourUsages(ArrayList<PerHourUsage> perHourUsages) {
		this.perHourUsages = perHourUsages;
	}

	public ArrayList<String> getMessages() {
		return messages;
	}

	public void setMessages(ArrayList<String> messages) {
		this.messages = messages;
	}

	public TepcoParser(String url) throws ClientProtocolException, IOException {
			parse(get(url));
	}
	
	// CSV ファイルを入手する
	private ArrayList<String> get(String url) throws ClientProtocolException, IOException{
		String host[] = url.split("/");
		
		HttpURLConnection urlconn = (HttpURLConnection)(new URL(url).openConnection());
		urlconn.setRequestMethod("GET");
		urlconn.setInstanceFollowRedirects(false);
		urlconn.setRequestProperty("Host", host[2]);
		urlconn.setRequestProperty("Accept", "*/*");
		urlconn.setRequestProperty("Referer", "http://jp.co.app.ynomoto.pmft/");
		urlconn.setRequestProperty("Accept-Language", "ja");
		urlconn.setRequestProperty("User-Agent", "pmft/1.0");
		urlconn.setRequestProperty("Connection:", "close");
		urlconn.connect();

		Log.d(LOG_TAG, "HTTP Response Code:" + urlconn.getResponseCode());
		ArrayList<String> response = new ArrayList<String>();
		if (urlconn.getResponseCode() == HttpURLConnection.HTTP_OK) {
			BufferedReader reader = new BufferedReader(new InputStreamReader(urlconn.getInputStream(), "Shift_JIS"));
			
			int i = 0;
			response.add(reader.readLine());
			while (response.get(i) != null) {
				response.add(reader.readLine());
				i++;
			}
			response.remove(i);
			reader.close();
		}

		urlconn.disconnect();
		return response;
	}
	
	// CSV ファイルを解析する
	private boolean parse(ArrayList<String> data){
		
		int i = 0;
		while( i < data.size()){
			
//			Log.v(LOG_TAG, data.get(i));
			
			if (data.get(i).endsWith("UPDATE")) {
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
				try {
					update = sdf.parse(data.get(i).substring(0, 14));
				} catch (ParseException e) {
					Log.d(LOG_TAG, "parsing failed");
					return false;
				}
			}
			
			if (data.get(i).startsWith("ピーク時供給力(万kW),")) {
				i++;
				peakAvailabilityToday.setPower(Integer.parseInt(data.get(i).split(",")[0]));
				peakAvailabilityToday.setTimeZones(data.get(i).split(",")[1]);
				String tmp = data.get(i).split(",")[2] + " " + data.get(i).split(",")[3];
				SimpleDateFormat sdf = new SimpleDateFormat("MM/dd HH:mm");
				try {
					peakAvailabilityToday.setUpdate(sdf.parse(tmp));
				} catch (ParseException e) {
					Log.d(LOG_TAG, "parsing failed");
					return false;
				}
			}
			
			if (data.get(i).startsWith("予想最大電力(万kW),")) {
				i++;
				maximumElectricPowerToday.setPower(Integer.parseInt(data.get(i).split(",")[0]));
				maximumElectricPowerToday.setTimeZones(data.get(i).split(",")[1]);
				String tmp = data.get(i).split(",")[2] + " " + data.get(i).split(",")[3];
				SimpleDateFormat sdf = new SimpleDateFormat("MM/dd HH:mm");
				try {
					maximumElectricPowerToday.setUpdate(sdf.parse(tmp));
				} catch (ParseException e) {
					Log.d(LOG_TAG, "parsing failed");
					return false;
				}
			}
			
			if (data.get(i).startsWith("翌日のピーク時供給力(万kW)")) {
				i++;
				try {
					peakAvailabilityTomorrow.setPower(Integer.parseInt(data.get(i).split(",")[0]));
					peakAvailabilityTomorrow.setTimeZones(data.get(i).split(",")[1]);
					String tmp = data.get(i).split(",")[2] + " " + data.get(i).split(",")[3];
					SimpleDateFormat sdf = new SimpleDateFormat("MM/dd HH:mm");
					peakAvailabilityTomorrow.setUpdate(sdf.parse(tmp));
				} catch (ArrayIndexOutOfBoundsException e){
					Log.d(LOG_TAG, "peakAvailabilityTomorrow is null");
					peakAvailabilityTomorrow = null;
				} catch (ParseException e) {
					Log.d(LOG_TAG, "parsing failed");
					return false;
				}
			}
			
			if (data.get(i).startsWith("翌日の予想最大電力(万kW)")) {
				i++;
				try {
					maximumElectricPowerTomorrow.setPower(Integer.parseInt(data.get(i).split(",")[0]));
					maximumElectricPowerTomorrow.setTimeZones(data.get(i).split(",")[1]);
					String tmp = data.get(i).split(",")[2] + " " + data.get(i).split(",")[3];
					SimpleDateFormat sdf = new SimpleDateFormat("MM/dd HH:mm");
					maximumElectricPowerTomorrow.setUpdate(sdf.parse(tmp));
				} catch (ArrayIndexOutOfBoundsException e){
					Log.d(LOG_TAG, "maximumElectricPowerTomorrow is null");
					peakAvailabilityTomorrow = null;
				} catch (ParseException e) {
					Log.d(LOG_TAG, "parsing failed");
					return false;
				}
			}
			
			if (data.get(i).startsWith("DATE,TIME,当日実績(万kW),予測値（万kW)")) {
				i++;
				for (int j = i; j < i + 24; j++) {
					PerHourUsage usage = new PerHourUsage();
					String tmp = data.get(j).split(",")[0] + " " + data.get(j).split(",")[1];
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
					try {
						usage.setDate(sdf.parse(tmp));
					} catch (ParseException e) {
						Log.d(LOG_TAG, "parsing failed");
						return false;
					}
					usage.setActual(Integer.parseInt(data.get(j).split(",")[2]));
					usage.setExpected(Integer.parseInt(data.get(j).split(",")[3]));
					perHourUsages.add(usage);
				}
			}
			
			if (data.get(i).startsWith("メッセージＮｏ,")) {
				i++;
				try {
					messages.add(data.get(i).split(",")[1]);
					messages.add(data.get(i+1).split(",")[1]);
				} catch (ArrayIndexOutOfBoundsException e) {
					Log.d(LOG_TAG, "messages is null");
					messages = null;
				}
			}
			
			i++;
		}
		
		return true;
	}
}

/*
 * juyo-j.csv フォーマット 変更履歴
 */
//2011/7/28 18:40 UPDATE
//ピーク時供給力(万kW),時間帯,供給力情報更新日,供給力情報更新時刻
//5160,9:00～20:00,7/28,8:30
//
//予想最大電力(万kW),時間帯,予想最大電力情報更新日,予想最大電力情報更新時刻
//3930,14:00～15:00,7/28,8:30
//
//DATE,TIME,当日実績(万kW),予測値（万kW)
//2011/7/28,0:00,3091,0
//2011/7/28,1:00,2869,0
//2011/7/28,2:00,2732,0
//2011/7/28,3:00,2657,0
//2011/7/28,4:00,2629,0
//2011/7/28,5:00,2625,0
//2011/7/28,6:00,2768,0
//2011/7/28,7:00,3008,0
//2011/7/28,8:00,3353,0
//2011/7/28,9:00,3665,0
//2011/7/28,10:00,3794,0
//2011/7/28,11:00,3858,0
//2011/7/28,12:00,3730,0
//2011/7/28,13:00,3837,0
//2011/7/28,14:00,3867,0
//2011/7/28,15:00,3872,0
//2011/7/28,16:00,3907,0
//2011/7/28,17:00,3841,0
//2011/7/28,18:00,0,3800
//2011/7/28,19:00,0,3730
//2011/7/28,20:00,0,0
//2011/7/28,21:00,0,0
//2011/7/28,22:00,0,0
//2011/7/28,23:00,0,0
//
//翌日のピーク時供給力(万kW),時間帯,供給力情報更新日,供給力情報更新時刻
//5030,9:00～20:00,7/28,17:30
//
//翌日の予想最大電力(万kW),時間帯,予想最大電力情報更新日,予想最大電力情報更新時刻
//3810,14:00～15:00,7/28,17:30
//
//メッセージＮｏ,節電お願い文
//1,節電にご協力いただき、ありがとうございます。皆さまのご協力により、電気の供給は、比較的余裕のある一日となりそうです。
//1,Thank you for your cooperation in helping us save electricity.Due to your efforts we will meet today’s Electricity Supply needs.
//
//DATE,TIME,当日実績（５分間隔値）(万kW)
//2011/7/28,0:00,3235
//2011/7/28,0:05,3190
//2011/7/28,0:10,3186
//2011/7/28,0:15,3153
//2011/7/28,0:20,3123
//2011/7/28,0:25,3101
//2011/7/28,0:30,3073
//2011/7/28,0:35,3041
//2011/7/28,0:40,3020
//2011/7/28,0:45,3009
//2011/7/28,0:50,2993
//2011/7/28,0:55,2963
//2011/7/28,1:00,2962
//2011/7/28,1:05,2942
//2011/7/28,1:10,2920
//2011/7/28,1:15,2904
//2011/7/28,1:20,2879
//2011/7/28,1:25,2865
//2011/7/28,1:30,2855
//2011/7/28,1:35,2840
//2011/7/28,1:40,2835
//2011/7/28,1:45,2822
//2011/7/28,1:50,2810
//2011/7/28,1:55,2797
//2011/7/28,2:00,2781
//2011/7/28,2:05,2768
//2011/7/28,2:10,2767
//2011/7/28,2:15,2748
//2011/7/28,2:20,2742
//2011/7/28,2:25,2731
//2011/7/28,2:30,2716
//2011/7/28,2:35,2717
//2011/7/28,2:40,2727
//2011/7/28,2:45,2704
//2011/7/28,2:50,2702
//2011/7/28,2:55,2687
//2011/7/28,3:00,2672
//2011/7/28,3:05,2658
//2011/7/28,3:10,2659
//2011/7/28,3:15,2675
//2011/7/28,3:20,2662
//2011/7/28,3:25,2655
//2011/7/28,3:30,2646
//2011/7/28,3:35,2650
//2011/7/28,3:40,2653
//2011/7/28,3:45,2645
//2011/7/28,3:50,2657
//2011/7/28,3:55,2648
//2011/7/28,4:00,2643
//2011/7/28,4:05,2648
//2011/7/28,4:10,2637
//2011/7/28,4:15,2639
//2011/7/28,4:20,2638
//2011/7/28,4:25,2615
//2011/7/28,4:30,2630
//2011/7/28,4:35,2627
//2011/7/28,4:40,2623
//2011/7/28,4:45,2616
//2011/7/28,4:50,2613
//2011/7/28,4:55,2613
//2011/7/28,5:00,2624
//2011/7/28,5:05,2616
//2011/7/28,5:10,2627
//2011/7/28,5:15,2624
//2011/7/28,5:20,2618
//2011/7/28,5:25,2627
//2011/7/28,5:30,2623
//2011/7/28,5:35,2634
//2011/7/28,5:40,2623
//2011/7/28,5:45,2616
//2011/7/28,5:50,2632
//2011/7/28,5:55,2637
//2011/7/28,6:00,2675
//2011/7/28,6:05,2697
//2011/7/28,6:10,2712
//2011/7/28,6:15,2727
//2011/7/28,6:20,2729
//2011/7/28,6:25,2735
//2011/7/28,6:30,2763
//2011/7/28,6:35,2793
//2011/7/28,6:40,2815
//2011/7/28,6:45,2831
//2011/7/28,6:50,2860
//2011/7/28,6:55,2882
//2011/7/28,7:00,2891
//2011/7/28,7:05,2923
//2011/7/28,7:10,2934
//2011/7/28,7:15,2966
//2011/7/28,7:20,2959
//2011/7/28,7:25,3001
//2011/7/28,7:30,2994
//2011/7/28,7:35,3036
//2011/7/28,7:40,3063
//2011/7/28,7:45,3084
//2011/7/28,7:50,3086
//2011/7/28,7:55,3154
//2011/7/28,8:00,3177
//2011/7/28,8:05,3203
//2011/7/28,8:10,3238
//2011/7/28,8:15,3261
//2011/7/28,8:20,3283
//2011/7/28,8:25,3334
//2011/7/28,8:30,3361
//2011/7/28,8:35,3416
//2011/7/28,8:40,3458
//2011/7/28,8:45,3486
//2011/7/28,8:50,3490
//2011/7/28,8:55,3526
//2011/7/28,9:00,3559
//2011/7/28,9:05,3596
//2011/7/28,9:10,3629
//2011/7/28,9:15,3625
//2011/7/28,9:20,3636
//2011/7/28,9:25,3641
//2011/7/28,9:30,3672
//2011/7/28,9:35,3709
//2011/7/28,9:40,3722
//2011/7/28,9:45,3721
//2011/7/28,9:50,3723
//2011/7/28,9:55,3745
//2011/7/28,10:00,3761
//2011/7/28,10:05,3763
//2011/7/28,10:10,3771
//2011/7/28,10:15,3781
//2011/7/28,10:20,3793
//2011/7/28,10:25,3798
//2011/7/28,10:30,3791
//2011/7/28,10:35,3806
//2011/7/28,10:40,3812
//2011/7/28,10:45,3809
//2011/7/28,10:50,3819
//2011/7/28,10:55,3824
//2011/7/28,11:00,3839
//2011/7/28,11:05,3850
//2011/7/28,11:10,3845
//2011/7/28,11:15,3853
//2011/7/28,11:20,3849
//2011/7/28,11:25,3856
//2011/7/28,11:30,3852
//2011/7/28,11:35,3885
//2011/7/28,11:40,3867
//2011/7/28,11:45,3875
//2011/7/28,11:50,3858
//2011/7/28,11:55,3866
//2011/7/28,12:00,3830
//2011/7/28,12:05,3771
//2011/7/28,12:10,3745
//2011/7/28,12:15,3737
//2011/7/28,12:20,3707
//2011/7/28,12:25,3701
//2011/7/28,12:30,3708
//2011/7/28,12:35,3702
//2011/7/28,12:40,3699
//2011/7/28,12:45,3695
//2011/7/28,12:50,3730
//2011/7/28,12:55,3738
//2011/7/28,13:00,3768
//2011/7/28,13:05,3809
//2011/7/28,13:10,3826
//2011/7/28,13:15,3841
//2011/7/28,13:20,3834
//2011/7/28,13:25,3832
//2011/7/28,13:30,3850
//2011/7/28,13:35,3846
//2011/7/28,13:40,3866
//2011/7/28,13:45,3858
//2011/7/28,13:50,3857
//2011/7/28,13:55,3856
//2011/7/28,14:00,3849
//2011/7/28,14:05,3877
//2011/7/28,14:10,3867
//2011/7/28,14:15,3861
//2011/7/28,14:20,3878
//2011/7/28,14:25,3869
//2011/7/28,14:30,3865
//2011/7/28,14:35,3869
//2011/7/28,14:40,3860
//2011/7/28,14:45,3865
//2011/7/28,14:50,3868
//2011/7/28,14:55,3876
//2011/7/28,15:00,3856
//2011/7/28,15:05,3853
//2011/7/28,15:10,3834
//2011/7/28,15:15,3850
//2011/7/28,15:20,3871
//2011/7/28,15:25,3868
//2011/7/28,15:30,3884
//2011/7/28,15:35,3888
//2011/7/28,15:40,3894
//2011/7/28,15:45,3884
//2011/7/28,15:50,3898
//2011/7/28,15:55,3888
//2011/7/28,16:00,3897
//2011/7/28,16:05,3912
//2011/7/28,16:10,3922
//2011/7/28,16:15,3908
//2011/7/28,16:20,3922
//2011/7/28,16:25,3906
//2011/7/28,16:30,3914
//2011/7/28,16:35,3898
//2011/7/28,16:40,3914
//2011/7/28,16:45,3908
//2011/7/28,16:50,3901
//2011/7/28,16:55,3886
//2011/7/28,17:00,3859
//2011/7/28,17:05,3853
//2011/7/28,17:10,3845
//2011/7/28,17:15,3853
//2011/7/28,17:20,3830
//2011/7/28,17:25,3844
//2011/7/28,17:30,3825
//2011/7/28,17:35,3834
//2011/7/28,17:40,3835
//2011/7/28,17:45,3830
//2011/7/28,17:50,3842
//2011/7/28,17:55,3837
//2011/7/28,18:00,3818
//2011/7/28,18:05,3805
//2011/7/28,18:10,3814
//2011/7/28,18:15,3815
//2011/7/28,18:20,3827
//2011/7/28,18:25,3850
//2011/7/28,18:30,3837
//2011/7/28,18:35,3850
//2011/7/28,18:40,3859
//2011/7/28,18:45,
//2011/7/28,18:50,
//2011/7/28,18:55,
//2011/7/28,19:00,
//2011/7/28,19:05,
//2011/7/28,19:10,
//2011/7/28,19:15,
//2011/7/28,19:20,
//2011/7/28,19:25,
//2011/7/28,19:30,
//2011/7/28,19:35,
//2011/7/28,19:40,
//2011/7/28,19:45,
//2011/7/28,19:50,
//2011/7/28,19:55,
//2011/7/28,20:00,
//2011/7/28,20:05,
//2011/7/28,20:10,
//2011/7/28,20:15,
//2011/7/28,20:20,
//2011/7/28,20:25,
//2011/7/28,20:30,
//2011/7/28,20:35,
//2011/7/28,20:40,
//2011/7/28,20:45,
//2011/7/28,20:50,
//2011/7/28,20:55,
//2011/7/28,21:00,
//2011/7/28,21:05,
//2011/7/28,21:10,
//2011/7/28,21:15,
//2011/7/28,21:20,
//2011/7/28,21:25,
//2011/7/28,21:30,
//2011/7/28,21:35,
//2011/7/28,21:40,
//2011/7/28,21:45,
//2011/7/28,21:50,
//2011/7/28,21:55,
//2011/7/28,22:00,
//2011/7/28,22:05,
//2011/7/28,22:10,
//2011/7/28,22:15,
//2011/7/28,22:20,
//2011/7/28,22:25,
//2011/7/28,22:30,
//2011/7/28,22:35,
//2011/7/28,22:40,
//2011/7/28,22:45,
//2011/7/28,22:50,
//2011/7/28,22:55,
//2011/7/28,23:00,
//2011/7/28,23:05,
//2011/7/28,23:10,
//2011/7/28,23:15,
//2011/7/28,23:20,
//2011/7/28,23:25,
//2011/7/28,23:30,
//2011/7/28,23:35,
//2011/7/28,23:40,
//2011/7/28,23:45,
//2011/7/28,23:50,
//2011/7/28,23:55,

// 2011/3/28 時点での csv のフォーマット
// -----------------------------------------------------------------
// 2011/3/28 7:05 UPDATE
// ピーク時供給力(万kW),時台,供給力情報更新日,供給力情報更新時刻
// 3850,18:00,3/27,17:30
//
// DATE,TIME,当日実績(万kW),前日実績(万kW)
// 2011/3/28,0:00,2710,2904
// 2011/3/28,1:00,2576,2759
// 2011/3/28,2:00,2506,2661
// 2011/3/28,3:00,2457,2578
// 2011/3/28,4:00,2454,2520
// 2011/3/28,5:00,2589,2529
// 2011/3/28,6:00,2863,2598
// 2011/3/28,7:00,0,2760
// 2011/3/28,8:00,0,2908
// 2011/3/28,9:00,0,2946
// 2011/3/28,10:00,0,2913
// 2011/3/28,11:00,0,2857
// 2011/3/28,12:00,0,2826
// 2011/3/28,13:00,0,2786
// 2011/3/28,14:00,0,2772
// 2011/3/28,15:00,0,2786
// 2011/3/28,16:00,0,2860
// 2011/3/28,17:00,0,3073
// 2011/3/28,18:00,0,3371
// 2011/3/28,19:00,0,3392
// 2011/3/28,20:00,0,3345
// 2011/3/28,21:00,0,3251
// 2011/3/28,22:00,0,3103
// 2011/3/28,23:00,0,2939
// -----------------------------------------------------------------

//2011/4/8 時点での csv のフォーマット
//-----------------------------------------------------------------
//2011/4/8 5:30 UPDATE
//ピーク時供給力(万kW),時台,供給力情報更新日,供給力情報更新時刻
//4050,18:00,4/8,1:05
//
//予想最大電力(万kW),時間帯,予想最大電力情報更新日,予想最大電力情報更新時刻
//3350,18:00～19:00,4/8,1:05
//
//DATE,TIME,当日実績(万kW),前日実績(万kW)
//2011/4/8,0:00,2677,2659
//2011/4/8,1:00,2546,2551
//2011/4/8,2:00,2484,2492
//2011/4/8,3:00,2438,2442
//2011/4/8,4:00,2424,2438
//2011/4/8,5:00,0,2499
//2011/4/8,6:00,0,2713
//2011/4/8,7:00,0,2909
//2011/4/8,8:00,0,3153
//2011/4/8,9:00,0,3301
//2011/4/8,10:00,0,3300
//2011/4/8,11:00,0,3287
//2011/4/8,12:00,0,3051
//2011/4/8,13:00,0,3183
//2011/4/8,14:00,0,3184
//2011/4/8,15:00,0,3124
//2011/4/8,16:00,0,3133
//2011/4/8,17:00,0,3114
//2011/4/8,18:00,0,3295
//2011/4/8,19:00,0,3281
//2011/4/8,20:00,0,3177
//2011/4/8,21:00,0,3071
//2011/4/8,22:00,0,3018
//2011/4/8,23:00,0,2860
//-----------------------------------------------------------------