package jp.co.app.ynomoto.pmft.receiver;

import java.io.IOException;
import java.util.ArrayList;

import org.apache.http.client.ClientProtocolException;

import jp.co.app.ynomoto.pmft.R;
import jp.co.app.ynomoto.pmft.data.PerHourUsage;
import jp.co.app.ynomoto.pmft.parser.TepcoParser;

import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.widget.RemoteViews;
import android.widget.Toast;

import android.util.Log;

public class PowerMeterWidget extends AppWidgetProvider {
	private static final String UPDATE_INTENT = "jp.co.app.ynomoto.pmft.UPDATE";
	// awm と context は、PowerMeterMain クラスで参照したいので、static 宣言する。
	private static AppWidgetManager awm;
	private static SharedPreferences sp;
	private static int[] appWidgetIds;
	
	@Override
	public void onUpdate(Context context, AppWidgetManager awm, int[] appWidgetIds) {
		PowerMeterWidget.awm = awm; 
		sp = PreferenceManager.getDefaultSharedPreferences(context);
		PowerMeterWidget.appWidgetIds = appWidgetIds;
		
		for (int i = 0; i < appWidgetIds.length; i++) {
			(new PowerMeterMain(appWidgetIds[i], context)).execute();
		}
	}
	
	@Override
	public void onReceive(Context context, Intent intent){
		// onUpdate() を実行するために、スーパークラスの onReceive を呼ぶ。
		super.onReceive(context, intent);
		// ネットワークエラー復帰後を想定して、UPDATE_INTENT によるデータ更新を行う。
		if (intent.getAction().equals(UPDATE_INTENT)) {
			if (awm != null) {
				for (int i = 0; i < appWidgetIds.length; i++) {
					(new PowerMeterMain(appWidgetIds[i], context)).execute();
				}
			}
		}
	}
	
	public class PowerMeterMain extends AsyncTask<Void, Void, RemoteViews>{
		private int appWidgetId;
		private Context context;
		
		public PowerMeterMain(int appWidgetId, Context context){
			this.appWidgetId = appWidgetId;
			this.context = context;
		}

		@Override
		protected RemoteViews doInBackground(Void... params) {

			Log.v("jp.co.app.ynomoto.pmft.PowerMeter", "update appWidgetIds: "
					+ appWidgetId);
			// 何かが影響して次の行で NullPointerException が発生する可能性がある。
			// 実機上(Xperia)で2度同じ事象が確認されている。
			Log.v("jp.co.app.ynomoto.pmft.PowerMeter",
					"Check NullPointerException");
			Log.v("jp.co.app.ynomoto.pmft.PowerMeter",
					"context.getPackageName():" + context.getPackageName());

			// リモートビューに main.xml をセットする。
			RemoteViews rv = new RemoteViews(context.getPackageName(),
					R.layout.widget);

			// csv の取得を行う。取得されたデータは解析済み
			TepcoParser parser;
			try {
				parser = new TepcoParser(sp.getString("csvUrl",
						"http://powermeter.sourceforge.jp/juyo-j.csv"));
				// ウィジェットをクリックしたときに PerHourUsagesGraph を起動する処理
				// rv.setOnClickPendingIntent();

				// ピーク時供給力供給量に対する電力の消費率を表示
				ArrayList<PerHourUsage> hourUsages = parser.getPerHourUsages();
				int usage;
				if (parser.getUpdate().getHours() == 0) {
					usage = calculate(hourUsages.get(23).getActual(), parser
							.getPeakAvailabilityToday().getPower());
				} else {
					usage = calculate(hourUsages.get(
							parser.getUpdate().getHours() - 1).getActual(),
							parser.getPeakAvailabilityToday().getPower());
				}
				Log.v("jp.co.app.ynomoto.pmft.PowerMeter", "usage=" + usage);
				rv.setTextViewText(R.id.textView1, Integer.toString(usage)
						+ "%");

				// 電力消費率による顔文字の変化
				if (usage >= 90) {
					rv.setTextViewText(R.id.textView2, sp.getString(
							"kaoMoji90", "(´；ω；`)"));
				} else if (usage >= 70) {
					rv.setTextViewText(R.id.textView2, sp.getString(
							"kaoMoji70", "(´・ω・`)"));
				} else {
					rv.setTextViewText(R.id.textView2, sp.getString(
							"kaoMoji69", "(`・ω・´)"));
				}

				// テキストカラーと背景を変更する。
				rv.setTextColor(R.id.textView1, Color.parseColor(sp.getString(
						"textColor", "#ffffff")));
				rv.setTextColor(R.id.textView2, Color.parseColor(sp.getString(
						"textColor", "#ffffff")));
				String str = sp.getString("background", "background");
				if (str.equals("background_white")) {
					rv.setImageViewResource(R.id.imageView1,
							R.drawable.background_white);
				} else if (str.equals("background_black")) {
					rv.setImageViewResource(R.id.imageView1,
							R.drawable.background_black);
				} else if (str.equals("background_red")) {
					rv.setImageViewResource(R.id.imageView1,
							R.drawable.background_red);
				} else if (str.equals("background_blue")) {
					rv.setImageViewResource(R.id.imageView1,
							R.drawable.background_blue);
				} else if (str.equals("background_yellow")) {
					rv.setImageViewResource(R.id.imageView1,
							R.drawable.background_yellow);
				} else {
					rv.setImageViewResource(R.id.imageView1,
							R.drawable.background);
				}
				
				return rv;
				
			} catch (ClientProtocolException e) {
				e.printStackTrace();
				return null;
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return null;
			} 
		}
		
		@Override
		protected void onPostExecute(RemoteViews rv) {
			if (rv == null) {
				Toast.makeText(context, "電力情報の取得に失敗しました。", Toast.LENGTH_SHORT)
						.show();
			} else {
				awm.updateAppWidget(appWidgetId, rv);
			}
		}

		public int calculate(int currentKw, int maximumKw) {
			return (int) ((float) currentKw / maximumKw * 100);
		}
	}
}
