/*
 *  psychlops_devices_nidaqmxbase.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/07/30 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_DEVICES_NIDAQMXBASE
#define HEADER_PSYCHLOPS_DEVICES_NIDAQMXBASE

#include "../../core/devices/psychlops_io_analog.h"

namespace Psychlops {

namespace Devices {

	// Notice: Currently Voltage range is limited from -5V to 5V.


	struct NIDAQmxBaseAPI;

	class AnalogInput_NIDAQmxBase : public AnalogInput {
		protected:
		NIDAQmxBaseAPI *api;

		public:
		AnalogInput_NIDAQmxBase(const char* devname = "Dev1/ai0");
		AnalogInput_NIDAQmxBase(double rate, const char* devname = "Dev1/ai0");
		virtual ~AnalogInput_NIDAQmxBase();
		virtual double get();
		virtual int get(double* buf, int length, double timeout_second);
		virtual double samplingRate();
		virtual void samplingRate(double sample_per_sec);



		virtual double getLatency();
		virtual double getJitterSD();
		virtual Interval getRange();
		virtual bool isAnalog();
		virtual void put(double);
		virtual void pulse(double);
		virtual void keep(double);
	};

	class AnalogOutput_NIDAQmxBase : public ITrigger, public AnalogOutput {
		protected:
		NIDAQmxBaseAPI *api;

		public:
		AnalogOutput_NIDAQmxBase(const char* devname = "Dev1/ao0");
		virtual ~AnalogOutput_NIDAQmxBase();
		virtual void put(double);
		static void setVoltage(double val, const char* devname = "Dev1/ao0");
		virtual void trigger();
		virtual void pulse(double);
		virtual void keep(double);



		virtual double getLatency();
		virtual double getJitterSD();
		virtual Interval getRange();
		virtual bool isAnalog();
		virtual double get();
	};


}

}	/*	<- namespace Psycholops 	*/



#endif
