/*
 *  psychlops_widgets_Win32GL.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/12/14 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */


#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>
#include "../../extension/standard/figure/psychlops_figure_standard.h"


namespace Psychlops {

	Figures::Movie& Figures::Movie::save(std::string filename, const double t_fps, const FOURCC codec) {
		double fps;
		if(t_fps<=0.0) { fps = 60.0; } else { fps = t_fps; }
		if(frames.size()>0)
		{
			std::cout << "Movie::save : in progress...";
			cv::Size size_of_frame(frames[0]->getWidth(), frames[0]->getHeight());
			cv::Mat frame;
			int fourcc = 0;
			switch(codec) {
			case AUTO:
				unsigned int loc;
				loc = filename.find(".avi",0);
				if( loc != std::string::npos ) { fourcc = CV_FOURCC('M','J','P','G'); break; }
				loc = filename.find(".mov",0);
				if( loc != std::string::npos ) { fourcc = CV_FOURCC('M','J','P','G'); break; }
				loc = filename.find(".m4v",0);
				if( loc != std::string::npos ) { fourcc = CV_FOURCC('M','P','4','V'); break; }
				break;
			case DIB:
				fourcc = CV_FOURCC('D','I','B',' ');
				break;
			case HFYU:
				fourcc = CV_FOURCC('H','F','Y','U');
				break;
			case PIM1:
				fourcc = CV_FOURCC('P','I','M','1');
				break;
			case MJPG:
				fourcc = CV_FOURCC('M','J','P','G');
				break;
			case DIVX:
				fourcc = CV_FOURCC('D','I','V','X');
				break;
			case XVID:
				fourcc = CV_FOURCC('X','V','I','D');
				break;
			case MP4V:
				fourcc = CV_FOURCC('M','P','4','V');
				break;
			}
			cv::VideoWriter writer(filename, fourcc, fps, size_of_frame);
			for(int i=0; i<frames.size(); i++)
			{
				frames[i]->to(frame);
				writer << frame;
			}
		} else {
			std::cout << "Movie::save : The movie is empty.";
		}
		return *this;
	}


}	/*	<- namespace Psycholops 	*/
