/*
 *  psychlops_io_clock_OSX.cpp
 *  Psychlops Standard Library (MacOSX)
 *
 *  Last Modified 2005/12/19 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#include <stdlib.h>
#include <Math.h>
#include <time.h>
#include <iostream>

#include <ApplicationServices/ApplicationServices.h>
#include <CoreServices/CoreServices.h>
#include <mach/mach.h>
#include <mach/mach_time.h>

#include "psychlops_io_clock_OSX.h"
#include "../../core/devices/psychlops_io_clock.h"


namespace Psychlops {


	void Clock::initialize() {
	}
	Clock::Clock() {
		update();
	}
	Clock::Clock(CLOCK_UNIT nativeclock_) {
		clock_ = nativeclock_;
	}
	Clock::~Clock() {}
	void Clock::update() {
		clock_ = mach_absolute_time();
	}
	Clock Clock::operator +(Clock &rhs) {
		return Clock(clock_ + rhs.clock_);
	}
	Clock Clock::operator -(Clock &rhs) {
		return Clock(clock_ - rhs.clock_);
	}
	Clock & Clock::operator +=(Clock &rhs) {
		(*this) = (*this) + rhs;
		return *this;
	}
	Clock & Clock::operator -=(Clock &rhs) {
		(*this) = (*this) - rhs;
		return *this;
	}
	bool Clock::operator ==(Clock &rhs) {
		return (clock_==rhs.clock_);
	}
	bool Clock::operator !=(Clock &rhs) {
		return (clock_!=rhs.clock_);
	}
	bool Clock::operator >(Clock &rhs) {
		return (clock_>rhs.clock_);
	}
	bool Clock::operator <(Clock &rhs) {
		return (clock_<rhs.clock_);
	}
	bool Clock::operator >=(Clock &rhs) {
		return (clock_>=rhs.clock_);
	}
	bool Clock::operator <=(Clock &rhs) {
		return (clock_<=rhs.clock_);
	}
	double Clock::at_msec() {
		long long val;
		Nanoseconds nano;
		nano = AbsoluteToNanoseconds( *(AbsoluteTime *) &clock_ );
		val = nano.hi;
		val <<= 32;
		val += nano.lo;
		return (val/(1000000.0));
	}


	long Gettime_ms() {
		uint64_t time_now;
		long long val;
		Nanoseconds nano;
		time_now = mach_absolute_time();
		nano = AbsoluteToNanoseconds( *(AbsoluteTime *) &time_now );
		val = nano.hi;
		val <<= 32;
		val += nano.lo;
		return val/(1000000.0);
	}



}	/*	<- namespace Psycholops 	*/
