/*
 *  psychlops_devices_nidaqmxbase.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/04/14 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */


#include <windows.h>
#include "../../core/math/psychlops_m_util.h"
#include "../../extension/devices/psychlops_devices_parallelport.h"


namespace Psychlops {
namespace Devices {

	//http://support.microsoft.com/kb/413279/JA
	//https://msdn.microsoft.com/ja-jp/library/cc429198.aspx
	//http://support.microsoft.com/kb/823179/ja

	GenericParallelPort::GenericParallelPort(std::string port_name, size_t pin) : pins(pin) {
		if (!(handle = CreateDC(NULL , port_name.c_str() , NULL , NULL))) {
			handle = 0;
			throw new Exception("Parallel port was not found.");
		}
	}
	GenericParallelPort::~GenericParallelPort() {
		if(handle!=0) {
			DeleteDC((HDC)handle);
		}
	}

	void GenericParallelPort::trigger() {
		DOCINFO diInfo = {0};
		diInfo.cbSize = sizeof (DOCINFO);
		diInfo.lpszDocName = "";
		if (StartDoc((HDC)handle , &diInfo) > 0) {
			TextOut((HDC)handle , 0 , 0 , &pins , 1);
			EndDoc((HDC)handle);
		}
	}

	void GenericParallelPort::trigger(int dn) {
		int n=1;
		if(dn>0) { n=dn; }
		DOCINFO diInfo = {0};
		diInfo.cbSize = sizeof (DOCINFO);
		diInfo.lpszDocName = "";
		if (StartDoc((HDC)handle , &diInfo) > 0) {
			for(int i=0; i<n; i++) { TextOut((HDC)handle , 0 , 0 , &pins , 1); }
			EndDoc((HDC)handle);
		}
	}

	void GenericParallelPort::trigger(const char *data, size_t length) {
		DOCINFO diInfo = {0};
		diInfo.cbSize = sizeof (DOCINFO);
		diInfo.lpszDocName = "";
		if (StartDoc((HDC)handle , &diInfo) > 0) {
			TextOut((HDC)handle , 0 , 0 , data, length);
			EndDoc((HDC)handle);
		}
	}

	void GenericParallelPort::trigger(std::string data) {
		DOCINFO diInfo = {0};
		diInfo.cbSize = sizeof (DOCINFO);
		diInfo.lpszDocName = "";
		if (StartDoc((HDC)handle , &diInfo) > 0) {
			TextOut((HDC)handle , 0 , 0 , data.c_str(), data.length());
			EndDoc((HDC)handle);
		}
	}

}
}	/*	<- namespace Psycholops 	*/

