﻿//Two types of plaid motion
//E. H. Adelson and J. A. Movshon (1982).
//Phenomenal coherence of moving visual patterns. Nature 300, 523-525

///+ Prefix
//// Include Psychlops Package
using Psychlops;

	namespace PsychlopsSilverlightApp
	{

		public class PsychlopsMain
		{
			///- Prefix

			///+ Global
			// Struct for component paremeters
			struct component
			{
				public double contrast;
				public double orientation;
				public double lambda;
				public double tf;
			}
			///- Global

			///+ Stimulus drawing function
			//// A function for stimulus drawing (main body)
			void drawgratingmovie(Image[] img, component c1, component c2, double contrast, int start, int maxframe, double bg_lum, double alpha)
			{
				double _xp, _xp2, col1, col2;
				double contrast1, contrast2;
				double imageheight, imagewidth;

				contrast1 = contrast*c1.contrast/(c1.contrast+c2.contrast);
				contrast2 = contrast*c2.contrast/(c1.contrast+c2.contrast);

				imageheight = img[0].getHeight();
				imagewidth = img[0].getWidth();

				for(int frame=start; frame<start+maxframe+1; frame++){
					//Display.progressbar(frame, maxframe+1);
					//img[frame].convert(Image::RGBA);
					for(int i=0; i<imagewidth; i++){
						for(int j=0; j<imageheight; j++){
							_xp = Math.sin(c1.orientation)*(i-imagewidth*0.5) + Math.cos(c1.orientation) * (j-imageheight *0.5);
							_xp2 = Math.sin(c2.orientation)*(i-imagewidth*0.5) + Math.cos(c2.orientation) * (j-imageheight *0.5);
							col1 = bg_lum*contrast1*Math.sin(2*Math.PI*_xp/c1.lambda + 2*Math.PI*c1.tf*frame/(double)refresh);
							col2 = bg_lum*contrast2*Math.sin(2*Math.PI*_xp2/c2.lambda + 2*Math.PI*c2.tf*frame/(double)refresh);
							img[frame].pix(i,j,new Color(col1+col2+bg_lum));
							img[frame].alpha(i,j,alpha);
						}
					}
					//img[frame].cache();
				}
			}

			///+ Stimulus drawing function
			//// A function for stimulus drawing (main body)
			void drawplaid() {
				Canvas display = new Canvas(Canvas.window);
				///+ Preperation
				//// Declare and initialize local variables
				int rect_size = 150;
				double rect_lum  = 0.5;
				double bg_lum    = 0.2;
				double duration = 400;

				double[] lambda = new double[2], contrast = new double[2], tf = new double[2];
				double center_orientation = 0.0;
				Image[,] movie = StaticFunctions.NewArray<Image>(2, 120);
				Image[,] component_movie = StaticFunctions.NewArray<Image>(4, 120);
				Image envelope = new Image(), envelope_small = new Image();

				for(int i=0; i<120; i++)
				{
					movie[0, i].set(rect_size, rect_size);
					movie[1, i].set(rect_size, rect_size);
					component_movie[0, i].set(rect_size/2, rect_size/2);
					component_movie[1, i].set(rect_size/2, rect_size/2);
					component_movie[2, i].set(rect_size/2, rect_size/2);
					component_movie[3, i].set(rect_size/2, rect_size/2);
				}
				envelope.set(rect_size, rect_size);
				envelope_small.set(rect_size/2, rect_size/2);

				Letters let1 = new Letters(), let2 = new Letters(), let3 = new Letters();
				let1.str = "Component1";
				let2.str = "Component2";
				let3.str = "Superposition";
				let1.centering().shift(-rect_size*1.25, -rect_size);
				//let1.cache();
				let2.centering().shift(rect_size*1.25, -rect_size);
				//let2.cache();
				let3.centering().shift(0.0, rect_size*0.75);
				//let3.cache();

				component c1, c2, c0;
				c0 = new component{ 0.0,0.0,1.0,1.0 }; //dummy for component movie
				///+ type-I
				// Prepare Type-I plaid movie
				center_orientation = 0.0;
				orientation_offset = Math.PI/6;
				contrast[0] = 1.0, contrast[1] = 1.0;
				lambda[0] = 30.0, lambda[1] = 30.0;
				tf[0] = 1.0; tf[1] = 1.0;

				c1 = {contrast[0], center_orientation-orientation_offset, lambda[0], tf[0]};
				c2 = {contrast[1], center_orientation+orientation_offset, lambda[1], tf[1]};

			drawgratingmovie(movie[0],c1, c2, 0.5, 0, refresh_int, bg_lum, 1.0);
			drawgratingmovie(component_movie[0],c0, c2, 0.5, 0, refresh_int, bg_lum, 1.0);
			drawgratingmovie(component_movie[1],c1, c0, 0.5, 0, refresh_int, bg_lum, 1.0);
			///- type-I

			///+ type-II
			// Prepare Type-II plaid movie
			center_orientation = -0.0, orientation_offset = Math.PI/12;
			contrast[0] = 1.0, contrast[1] = 1.0;
			lambda[0] = 30.0, lambda[1] = 30.0;
			tf[0] = 1.0; tf[1] = 4.0;

			c1 = {contrast[0], center_orientation-orientation_offset, lambda[0], tf[0]};
			c2 = {contrast[1], center_orientation+orientation_offset, lambda[1], tf[1]};

			drawgratingmovie(movie[1],c1, c2, 0.5, 0, refresh_int, bg_lum, 1.0);
			drawgratingmovie(component_movie[2],c0, c2, 0.5, 0, refresh_int, bg_lum, 1.0);
			drawgratingmovie(component_movie[3],c1, c0, 0.5, 0, refresh_int, bg_lum, 1.0);
			///- type-II

			///+ gaussian
			//draw Gaussian envelopes
			envelope.clear(new Color(bg_lum)); //clear offscreen image
			double _x, _y;
			for(int i=0; i<rect_size; i++){
			_x=i-0.5*rect_size;
			for(int j=0; j<rect_size; j++){
			_y=j-0.5*rect_size;
			envelope.alpha(i,j,1.0-Math.exp(-((_x*_x+_y*_y)/ (2.0*pow(rect_size/6.0, 2.0) ))));
			}
			}

			envelope_small.clear(new Color(bg_lum)); //clear offscreen image
			for(int i=0; i<rect_size*0.5; i++){
			_x=i-0.25*rect_size;
			for(int j=0; j<rect_size*0.5; j++){
			_y=j-0.25*rect_size;
			envelope_small.alpha(i,j,1.0-Math.exp(-((_x*_x+_y*_y)/ (2.0*pow(rect_size/12.0, 2.0) ))));
			}
			}
			envelope.cache(); //send offscreen image from main memory to GPU
			envelope_small.cache(); //send offscreen image from main memory to GPU
			///- gaussian

			///+ user interface
			// Draw user interface
			Widgets::SelectBox stimulus_type;
			stimulus_type.area.set(120, 20);
			stimulus_type.append(L"TypeI");
			stimulus_type.append(L"TypeII");
			stimulus_type.centering().shift(-120.0,250.0);

			Psychlops::Widgets::SelectBox stimulus_type2;
			stimulus_type2.area.set(120, 20);
			stimulus_type2.append(L"Continuous");
			stimulus_type2.append(L"Periodic");
			stimulus_type2.centering().shift(120.0,250.0);

			Psychlops::Widgets::Slider duration_slider;
			duration_slider.area.set(100,20);
			duration_slider.centering().shift(120,280.0);
			Interval rng = new Interval();
			duration_slider.link(duration, 50<=rng<=950, 50.0, 50.0);
			///- user interface
			///- Preperation

			///+ Main loop
			int frame = 0;
			int period = refresh_int;
			int movienum;
			while(!Keyboard.esc.pushed()) {
			Display.clear(new Color(bg_lum));
			movienum = stimulus_type.getSelected(); //if "Type-I" is selected, 0, else frame refresh per sec

			in;
			else period = refresh_int;

			if(frame>0){
			movie[movienum, frame].centering().draw();
			envelope.centering().draw();
			component_movie[movienum*2, frame].centering().shift(-rect_size*0.5, -rect_size).draw();
			envelope_small.centering().shift(-rect_size*0.5, -rect_size).draw();
			component_movie[movienum*2+1, frame].centering().shift(rect_size*0.5, -rect_size).draw();
			envelope_small.centering().shift(rect_size*0.5, -rect_size).draw();
			}

			///+ draw user interface
			let1.draw(0.75);
			let2.draw(0.75);
			let3.draw(0.75);
			stimulus_type.draw();
			stimulus_type2.draw();
			if(stimulus_type2.getSelected())duration_slider.draw();
			///- draw user interface
			Display.flip();
			if(frame++ >= period) frame -= refresh_int;
			}
			///- Main loop

			}
			///- Stimulus drawing function

		///+ Main function for demo circumstances
		public void psychlops_main() {
			///+ Demo circumstances
			//// Spells for run demonstration circumstances
			Procedure p = new Procedure();
			//p.setDesign(Procedure::DEMO); //Designate that this is a demo.
			p.setProcedure(drawplaid);  //The argument name is a name of drawing function.
			p.run();
			///- Demo circumstances
		}
	}
}




/*
using Psychlops;
//Position Bias Program
namespace PsychlopsSilverlightApp
{

    public class PsychlopsMain
    {
        Canvas cnvs;
        Image img, img2, img3;
        int isize = 80;        
        int frames;
        Psychlops.Widgets.Slider tfreq;
        Psychlops.Widgets.Slider contrast;
        Psychlops.Widgets.Slider lambda;

        public void psychlops_main()
        {
            cnvs = new Canvas(300, 600);
            Interval rng = new Interval();
            tfreq = new Psychlops.Widgets.Slider("Temporal Frequency(Hz)", -5 <= rng <= 5, 3.0);
            contrast = new Psychlops.Widgets.Slider("Contrast", 0.0 <= rng <= 1.0, 0.25);
            lambda = new Psychlops.Widgets.Slider("Wave Length", 10.0 <= rng <= 120.0, 30);

            img = new Image(isize * 2, isize * 2);
            img2 = new Image(isize * 2, isize * 2);
            img3 = new Image(isize * 2, isize * 2);


            while (true)
            {
                cnvs.clear(new Color(0.5));

                Figures.drawGabor(ref img, isize / 6, 1/lambda, contrast, 0.5 * Math.PI, (double)frames * 2.0 * Math.PI * tfreq / 60);
				Figures.drawGabor(ref img2, isize / 6, 1 / lambda, contrast, 0.5 * Math.PI, (double)frames * 2.0 * Math.PI * -tfreq / 60);
				Figures.drawGabor(ref img3, isize / 6, 1 / lambda, contrast, 0.5 * Math.PI, (double)frames * 2.0 * Math.PI * tfreq / 60);

                img.centering().shift(0, -isize * 1.5).draw();
                img2.centering().draw();
                img3.centering().shift(0, isize * 1.5).draw();
                
                if (!Mouse.left.pressed()) frames++;

                cnvs.flip();
            }
        }
    }
}

*/