/*
 *  psychlops_g_canvas3d_prototype.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2005/10/05 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

//#include <gl/gl.h>
#include "../../../psychlops_core.h"
#include "../../../platform/gl/psychlops_g_GL_h.h"

#include "psychlops_g_canvas3d_prototype.h"


namespace Psychlops {

/*
	Canvas3D::Canvas3D(void) : has_instance_(false), APIsetColor(0) {
	}
	Canvas3D::Canvas3D(CanvasMode mode) : has_instance_(false), APIsetColor(0) {
		set(mode);
	}
	Canvas3D::Canvas3D(int d_width, int d_height, int d_colordepth, double d_refreshrate, CanvasMode mode) : has_instance_(false), APIsetColor(0) {
		set(d_width, d_height, d_colordepth, d_refreshrate, mode);
	}*/
	Canvas3D::~Canvas3D(void) {
		release();
	}

		static void setColor4Through(const Color &color) {
			double r,g,b,a;
			color.get(r,g,b,a);
			glColor4d(r,g,b,a);
		}
		static void setColorClaer4Through(const Color &color) {
			double r,g,b,a;
			color.get(r,g,b,a);
			glClearColor(r,g,b,a);
		}

	void Canvas3D::popMatrixes() {
		glMatrixMode(GL_MODELVIEW);
		glPopMatrix();
		glMatrixMode(GL_PROJECTION);
		glPopMatrix();
	}
	void Canvas3D::loadOrthoProjection() {
		glMatrixMode(GL_PROJECTION);
		glPushMatrix();
		glOrtho(-0.375, Width-0.375, Height-0.375, -0.375, -1000, 1000);
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
//		glDisable(GL_LIGHTING);
//		glDisable(GL_DEPTH_TEST);
	}

	void Canvas3D::initAPIprop() {
		switch(colordepth) {
/*		case 24:
		case 32:
			APIsetColor = &(DirectGetColor::setColor4ub);
			APIsetColorClear = &(DirectGetColor::setColorClear4ub);
			break;*/
		default:
			APIsetColor = &(setColor4Through);
			APIsetColorClear = &(setColorClaer4Through);
			break;
		}

		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		loadOrthoProjection();

		initAPIattributes();
		glDrawBuffer(GL_BACK);
		glReadBuffer(GL_BACK);

		GLclampf red=0.0, green=0.0, blue=0.0, alpha=1.0;
//		default_drawing_mode_ = GL_POINTS;
		glClearColor(red,green,blue,alpha);
		clear();
		this->Canvas::flip();
		clear();
		this->Canvas::flip();
	}

	void Canvas3D::initAPIattributes() {
		glPushAttrib(GL_ALL_ATTRIB_BITS);

		////	default settings	////
		glShadeModel(GL_FLAT);
		glEnable(GL_ALPHA_TEST);
		glEnable(GL_BLEND);
		glEnable(GL_LINE_STIPPLE);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
/*		glDisable(GL_POINT_SMOOTH);
		glDisable(GL_LINE_SMOOTH);
		glDisable(GL_POLYGON_SMOOTH);
		glDisable(GL_DEPTH_TEST);
		glDisable(GL_DITHER);
		glDisable(GL_FOG);
		glDisable(GL_LIGHTING);
		glDisable(GL_LOGIC_OP);
		glDisable(GL_STENCIL_TEST);
		glDisable(GL_TEXTURE_1D);
		glDisable(GL_TEXTURE_2D);
*/		glPixelTransferi(GL_MAP_COLOR, GL_FALSE);
		glPixelTransferi(GL_MAP_STENCIL, GL_FALSE);
		glPixelTransferi(GL_RED_SCALE, 1);
		glPixelTransferi(GL_RED_BIAS, 0);
		glPixelTransferi(GL_GREEN_SCALE, 1);
		glPixelTransferi(GL_GREEN_BIAS, 0);
		glPixelTransferi(GL_BLUE_SCALE, 1);
		glPixelTransferi(GL_BLUE_BIAS, 0);
		glPixelTransferi(GL_ALPHA_SCALE, 1);
		glPixelTransferi(GL_ALPHA_BIAS, 0);
		glPixelStorei(GL_UNPACK_ROW_LENGTH, 0);
		glPixelStorei(GL_UNPACK_SKIP_ROWS, 0);
		glPixelStorei(GL_UNPACK_SKIP_PIXELS, 0);
		glPixelStorei(GL_UNPACK_ALIGNMENT, 4);
		glPixelStoref(GL_UNPACK_ALIGNMENT, 4);
		glPixelStorei(GL_PACK_ALIGNMENT, 4);
		glPixelStoref(GL_PACK_ALIGNMENT, 4);
		glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	}

	void Canvas3D::flip(int nextframe) {
		popMatrixes();
		loadOrthoProjection();

		glPushAttrib(GL_ALL_ATTRIB_BITS);
		glDisable(GL_LIGHTING);
		this->Canvas::flip(nextframe);
		glPopAttrib();

		popMatrixes();
		loadOrthoProjection();
	}


}	/*	<- namespace Psycholops 	*/
