/*
 *  psychlops_g_font_OSX.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2008/09/12 by Kenchi HOSOKAWA
 *  (C) 2008 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */

#include "../../core/graphic/psychlops_g_font.h"
#include "../../core/graphic/psychlops_g_font.h"
#include <CoreFoundation/CoreFoundation.h>
#include "../../core/ApplicationInterfaces/psychlops_code_exception.h"

namespace Psychlops {

	Font Font::default_font(20, normal_weight, normal_style, L"HiraKakuPro-W3");

	std::wstring LocalEncodingtoWCHAR(const char* s, int length) {
		char *c = new char[length+1];
		memcpy(c+1, s, length);
		c[0] = (char)length;
		CFStringRef str = CFStringCreateWithBytes(kCFAllocatorDefault, (const UInt8*)(c), length+1, kCFStringEncodingMacJapanese, false);
		delete c;
		if(str==NULL) throw new Exception("fail: ShiftJIStoWCHAR");
		std::wstring result;
		result.resize(CFStringGetLength(str));
#if defined(PANTHER) && ( PANTHER ==1 )
		CFStringGetCString(str, (char*)result.data(), result.length()*4, kCFStringEncodingUnicode);
#else
		CFStringGetCString(str, (char*)result.data(), result.length()*4, kCFStringEncodingUTF32LE);
#endif
		return result;
	}
	std::wstring LocalEncodingtoWCHAR(const char* c) {
		int i = 0;
		while(c[i]!=0) i++;
		i--;
		return LocalEncodingtoWCHAR(c, i);
	}
	
}	/*	<- namespace Psycholops 	*/
