#include <psychlops.h>
using namespace Psychlops;

void ullmancylinder() {
	std::cout << AppInfo::argc << std::endl;
	for(int i=0; i<AppInfo::argc; i++)
	{
		std::cout << AppInfo::argv[i] << std::endl;
		std::cout << AppInfo::args[i] << std::endl;
	}
		
	const int DOTCNT = 5000;
	
	int dotcnt = 100;
	double bg_lum = 0.0;
	double velocity = 1.0;
	double SOA_pp;
	int SIZE = 3;
	int SOA = 0, frames = 0;
	
	Range rng;
	Independent << dotcnt   | "Number of Dots" |   1< rng< DOTCNT |  5   | 2.0 ;
	Independent << velocity | "Dot Velocity"   | 0.0<=rng<=10.0   |  0.1 | 0.05;
	Independent << SOA      | "SOA Frames"     |   0<=rng<=60     |  1   | 5;
	Independent << bg_lum   | "Luminance Inv." | 0.0<=rng<=1.0    |  1   | 1;
	Independent << SIZE     | "Dot Size"       |   0< rng<=10     |  1   | 1;
	
	
	Canvas canvas(Canvas::window);
	Psychlops::Rectangle rect(SIZE,SIZE);
	double phase=0.0;
	Color bgcolor(0), dotcolor(1.0-bg_lum);
	
	double x[DOTCNT], dx[DOTCNT], y[DOTCNT];
	for(int i=0; i<DOTCNT; i++) {
		x[i] = Psychlops::random(2.0*PI);
		y[i] = Psychlops::random(400)-200+canvas.getHeight()/2;
	}
	double centerx = canvas.getWidth()/2;
	
	while(!Input::get(Keyboard::esc)) {
		bgcolor.set(bg_lum);
		dotcolor.set(1.0-bg_lum);
		canvas.clear(bgcolor);
		rect.set(SIZE,SIZE);
		
		phase += velocity;
		frames++;
		SOA_pp = SOA+2;
		
		for(int i=0; i<DOTCNT; i++)	dx[i] = (200*sin(x[i]+SOA_pp*phase/100.0))+centerx;
		
		for(int i=0; i<dotcnt; i++)	rect.centering(dx[i], y[i]).display(dotcolor);
		
		canvas.flip(SOA+2);
	}
}


void psychlops_main()
{
	
	Procedure p;
	p.setDesign(Procedure::DEMO);
	p.setProcedure(ullmancylinder);
	p.run();
	
}



/*
 #include <psychlops.h>
 using namespace Psychlops;	// Initially developed with Psychlops Win32 1.0.2 / 20080414



const double E = 2.718281828459045;
const double LOG2E = 1.44269504088896340736;
double sigmoid(double x, double d, double a) { return 1 / ( 1 + pow(E, -(a*(x-d))) ); }
double log2NormalDistibution(double log_x, double octave_mu, double octave_sigma) { return Math::normalDistibution(log(log_x)*LOG2E, octave_mu, octave_sigma); }
double cumulativeLog2NormalDistibution(double log_x, double octave_mu, double octave_sigma) { return Math::cumulativeNormalDistibution(log(log_x)*LOG2E, octave_mu, octave_sigma); }


double bind(double x) {
	return cumulativeLog2NormalDistibution(x, 2, 1.15/2);
}
double bind2(double x) {
	return 1-cumulativeLog2NormalDistibution(x, 1, 1.15/2);
}

void psychlops_main() {
	Canvas cnvs(1024,768,Canvas::window);

	Figures::FunctionalPlot plot(500,500);
	plot.append(&bind);
	plot.append(&bind2);
	plot.x_max=20; plot.x_min=0.0000001; plot.y_max=1.1; plot.y_min=-0.1;
	plot.draw();
	cnvs.flip();

	while(!Keyboard::esc.pushed()) {}
}
*/

/*
void psychlops_main() {
	Canvas sampleA(Canvas::fullscreen);

	Image img(200,200);
	img.clear(Color::blue);
	img.rect(Psychlops::Rectangle(50,0,150,100),Color::green); // Draw rect to upper side
	img.centering().draw();


	Psychlops::Rectangle rect(500,500);
	Image target;

	sampleA.to(target, rect.centering());
	rect.draw(Color(1,0,0,0.2));	// show source area of Canvas::to


	sampleA.flip();	// If Canvas::flip has been done bofore Canvas::to, Canvas::to won't work as you intended.
	while(!Input::get(Keyboard::esc));

	// writing outline of the image
	target.line(0, 0, 0, target.getHeight(), Color::red);
	target.line(0, 0, target.getWidth(), 0, Color::red);
	target.line(0, 0, target.getWidth(), target.getHeight(), Color::red);

	sampleA.clear();
	target.draw();
	sampleA.flip();
	while(!Input::get(Keyboard::esc));
}
*/

/*
Psychlops::Rectangle rect1(1279,1023); Psychlops::Rectangle rect2;
Psychlops::Image Stimulus1(rect1); Psychlops::Image Stimulus2(rect1);
Psychlops::Color col(0.8);

void psychlops_main() {
	Canvas sampleA(Canvas::fullscreen);
	for(int y=0; y<10; y++) {
		rect2.set(0, y*100+25, 1279, y*100+20+25);
		Stimulus1.rect(rect2, col);
	}
	Stimulus1.draw();
	sampleA.flip();
	while(!Input::get(Keyboard::esc));

	sampleA.flip();

	rect2.set(0,0,500,500);//x座標が指定できていない
	//rect2.set(0,0,1680,500);//上下反転？
	//rect2.set(0,500,1680,1000);//OK

	sampleA.to(Stimulus2, rect2);
	Stimulus2.draw();
	sampleA.flip();
	while(!Input::get(Keyboard::esc));
}

*/
