/*
 *  psychlops_devices_crs_bits.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/07/30 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_DEVICES_CRS_BITS
#define HEADER_PSYCHLOPS_DEVICES_CRS_BITS

#include "../../core/graphic/psychlops_graphic.h"
#include "../../core/devices/psychlops_io_analog.h"
#include "../../core/devices/psychlops_io_clock.h"
#include "../../extension/standard/shader/psychlops_g_shader.h"
#include "../../platform/gl/extension/psychlops_g_shader_gl.h"


namespace Psychlops {
namespace Devices {


	struct BitsTlock
	{
		static const unsigned char COMMAND_R[8];// = { 69,40,19,119,52,233,41,183 };
		static const unsigned char COMMAND_G[8];// = { 33,230,190,84,12,108,201,124 };
		static const unsigned char COMMAND_B[8];// = { 56,208,102,207,192,172,80,221};
		static const unsigned char PALLETE_R[8];// = { 69,40,19,119,52,233,41,183 };
		static const unsigned char PALLETE_G[8];// = { 33,230,190,84,12,108,201,124 };
		static const unsigned char PALLETE_B[8];// = { 56,208,102,207,192,172,80,221};
	};


	struct BitsTimer
	{
	};


	struct BitsPallete
	{
		Image tlock;
		bool is_initialized;
		void initialize();

		BitsPallete();
		void set(double *val);
	};


	struct BitsTrigger
	{
		Image tlock;
		bool is_initialized;
		void initialize();

		BitsTrigger();
		void set(double val);
		void out();
	};


/*
	struct BitsResponseBox
	{
		struct Key {
			const int code;
			Key(const int code_);
			bool pressed() const;
			bool pushed() const;
			bool released() const;
			bool get(KeyState state) const;
		};

		CBBOXRECORD C;
		Image tlock;
		bool is_initialized;
		void initialize();

		BitsResponseBox();
		BitsResponseBox(unsigned long BoxType);
		~BitsResponseBox();
		void open(unsigned long BoxType = 8);
		void close();

		void reset();
		void buzzer(unsigned long Period, unsigned long Frequency);
		void sendback();
		void check();
		void flush();
	};
*/




	class CanvasBits : public Canvas
	{
		protected:
		ShaderAPI shader;
		/*
		virtual void initAPIprop();
		virtual void initAPIattributes();
		void popMatrixes();
		void loadOrthoProjection();
		*/
		inline void setStrokeState(const Stroke& strk);

		public:
		CanvasBits();
		CanvasBits(CanvasMode mode);
		CanvasBits(int d_width, int d_height, int d_colordepth, double d_refreshrate, CanvasMode mode);
		virtual ~CanvasBits(void);

		virtual void initAPIprop();
		virtual void initAPIattributes();
		//virtual void popAPIattributes();

		public:
		virtual CanvasBits& clear(const Color &col);
		/*
		virtual Drawable& pix(const double x, const double y, const Color &col) = 0;


		virtual Drawable& line(const Line &drawee, const Color &col) = 0;
		virtual Drawable& line(const Line &drawee, const Stroke &strk) = 0;
		*/
		virtual CanvasBits& rect(const Rectangle &drawee, const Color &col);
		virtual CanvasBits& rect(const Rectangle &drawee, const Stroke &strk);
		/*
		//virtual Drawable& rect(const Rectangle[] drawee, const Color &col) = 0;
		//virtual Drawable& rect(const Rectangle[] drawee, const Stroke &strk) = 0;
		virtual Drawable& ellipse(const Ellipse &drawee, const Color &col) = 0;
		virtual Drawable& ellipse(const Ellipse &drawee, const Stroke &strk) = 0;
		virtual Drawable& polygon(const Polygon &drawee) = 0;
		virtual Drawable& polygon(const Polygon &drawee, const Color &col) = 0;
		virtual Drawable& polygon(const Polygon &drawee, const Stroke &strk) = 0;
		virtual Drawable& polyline(const PolyLine &drawee) = 0;
		virtual Drawable& polyline(const PolyLine &drawee, const Color &col) = 0;
		virtual Drawable& polyline(const PolyLine &drawee, const Stroke &strk) = 0;
		virtual Drawable& figures(const Group &drawee) = 0;
		*/
		virtual CanvasBits& image(const Image &img);
//		virtual CanvasBits& image(Image &img, const Rectangle &target_area, const Rectangle &source_rect);
		virtual CanvasBits& image(const Image &img, const double x, const double y);
		/*	virtual Drawable& image(const Image &img, const double alpha) = 0;
		//virtual Drawable& cacheImage(Image &img, bool on_off) = 0;
		virtual Drawable& letters(Letters &let, const Color &col) = 0;
		*/
		//virtual void flip(int and_wait_N_vsyncs=1);


		virtual void cacheImageBody(Image &img);
		void drawImage(const Image &img, const double left, const double top);
//		void drawImage(Image &img, const Rectangle &target_area);
	};


}

}	/*	<- namespace Psycholops 	*/



#endif
