/*
 *  psychlops_code_exception.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2005/12/17 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */


#include <typeinfo>
#include <string>
#include <iostream>


#include "psychlops_code_exception.h"


namespace Psychlops {



	Exception Exception::dummy_;
	Exception::Exception()
		: ti_((const std::type_info &)typeid(dummy_)) {}
	Exception::Exception(const std::type_info &ti)
		: ti_(ti) {}
	Exception::Exception(std::string str)
		: ti_((const std::type_info &)typeid(dummy_)), str_(str) {}
	Exception::Exception(const char *str)
		: ti_((std::type_info &)typeid(dummy_)), str_(std::string(str)) {}
	Exception::Exception(const std::type_info &ti, std::string category)
		: ti_(ti), category_(category) {}
	Exception::Exception(const std::type_info &ti, const char *category)
		: ti_(ti), category_(std::string(category)) {}
	Exception::Exception(const std::type_info &ti, std::string category, std::string str)
		: ti_(ti), category_(category), str_(str) {}
	Exception::Exception(const std::type_info &ti, const char *category, const char *str)
		: ti_(ti), category_(std::string(category)), str_(std::string(str)) {}

	std::string Exception::to_s() {
		return std::string(ti_.name()) + " [" + category_ + "] " + str_;
	}
	std::string Exception::toString() {
		return std::string(ti_.name()) + " [" + category_ + "] " + str_;
	}
	std::string Exception::getErrorString() {
		return str_;
	}



namespace Prototype {
	double debug_double[8] = {0,0,0,0,0,0,0,0};
}


}	/*	<- namespace Psychlops 	*/

