/*
 *  psychlops_devices_nidaqmxbase.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/04/14 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#include "../../core/ApplicationInterfaces/psychlops_code_exception.h"
#include "../../core/devices/psychlops_io_hid.h"
#include "../../core/graphic/psychlops_g_canvas.h"
#include "../../core/math/psychlops_math.h"

#include "psychlops_devices_crs_bits.h"

#if defined(__APPLE__)
#else
#include "C:\Program Files\Cambridge Research Systems\VSGV7\Windows\WIN32\MSC\include\bits++.h"
#endif



namespace Psychlops {

namespace Devices {

	const unsigned char BitsTlock::COMMAND_R[8] = { 69 ,40 ,19 ,119,52 ,233,41 ,183 };
	const unsigned char BitsTlock::COMMAND_G[8] = { 33 ,230,190,84 ,12 ,108,201,124 };
	const unsigned char BitsTlock::COMMAND_B[8] = { 56 ,208,102,207,192,172,80 ,221 };

	const unsigned char BitsTlock::PALLETE_R[8] = { 36 ,63 , 8 ,211,3  ,112,56 ,34 };
	const unsigned char BitsTlock::PALLETE_G[8] = {106 ,136,19 ,25 ,115,68, 41, 156};
	const unsigned char BitsTlock::PALLETE_B[8] = {133 ,163,138,46 ,164,9  ,49, 208};

	inline double CTB(int param)
	{
		return param / 255.0;
	}

	void BitsPallete::initialize()
	{
		if(!is_initialized)
		{
		Color::setGammaValue(1.0,1.0,1.0);
			tlock.set(20,1,Image::RGB);
			for(int i=0; i<8; i++) {
				tlock.pix(i, 0, Color(CTB(BitsTlock::COMMAND_R[i]), CTB(BitsTlock::COMMAND_G[i]), CTB(BitsTlock::COMMAND_B[i])) );
			}
		Color::setGammaValue(1.0,1.0,1.0, Color::BITS_MONO);
		}
	}

	BitsPallete::BitsPallete()
	{
		is_initialized = false;
		initialize();
	}

	void BitsPallete::set(double *val)
	{
		Color::setGammaValue(1.0,1.0,1.0);
		int packet_length = 1;
		tlock.pix(8, 0, Color(CTB(0), CTB(0), CTB(packet_length-1)));
		tlock.pix(9, 0, Color(CTB(6), CTB(0), CTB(2)));
		tlock.pix(10, 0, Color(CTB(0), CTB(0), CTB(0)));
		tlock.pix(11, 0, Color(CTB(7), CTB(255), CTB(255)));

		tlock.pix(12, 0, Color(CTB(0), CTB(0), CTB(0)));
		//tlock.pix(14, 0, Color(CTB(0), CTB(0), CTB(0));
		//tlock.pix(16, 0, Color(CTB(0), CTB(0), CTB(0));
		//tlock.pix(18, 0, Color(CTB(0), CTB(0), CTB(0));

		short w = val[0];
		tlock.pix(13, 0, Color(CTB(7), w >> 8 / 255, w >> 255 ));
		Color::setGammaValue(1.0,1.0,1.0, Color::BITS_MONO);
	}


	void BitsTrigger::initialize()
	{
		if(!is_initialized)
		{
		Color::setGammaValue(1.0,1.0,1.0);
			tlock.set(20,1,Image::RGB);
			for(int i=0; i<8; i++) {
				tlock.pix(i, 0, Color(CTB(BitsTlock::COMMAND_R[i]), CTB(BitsTlock::COMMAND_G[i]), CTB(BitsTlock::COMMAND_B[i])) );
			}
		Color::setGammaValue(1.0,1.0,1.0, Color::BITS_MONO);
		}
	}

	BitsTrigger::BitsTrigger()
	{
		is_initialized = false;
		initialize();
	}

	void BitsTrigger::set(double val)
	{
		Color::setGammaValue(1.0,1.0,1.0);
		int packet_length = 1;
		tlock.pix(8, 0, Color(CTB(0), CTB(0), CTB(packet_length-1)));
		tlock.pix(9, 0, Color(CTB(6), CTB(0), CTB(2)));
		tlock.pix(10, 0, Color(CTB(0), CTB(0), CTB(0)));
		tlock.pix(11, 0, Color(CTB(7), CTB(255), CTB(255)));

		tlock.pix(12, 0, Color(CTB(0), CTB(0), CTB(0)));
		//tlock.pix(14, 0, Color(CTB(0), CTB(0), CTB(0));
		//tlock.pix(16, 0, Color(CTB(0), CTB(0), CTB(0));
		//tlock.pix(18, 0, Color(CTB(0), CTB(0), CTB(0));

		short w = val;
		tlock.pix(13, 0, Color(CTB(7), w >> 8 / 255, w >> 255 ));
		tlock.setDatum(Point(0, Display::getHeight()-1));
		Color::setGammaValue(1.0,1.0,1.0, Color::BITS_MONO);
	}

	void BitsTrigger::out()
	{
		tlock.draw();
	}



/*

	void BitsResponseBox::initialize()
	{
		if(!is_initialized)
		{
			tlock.set(12,1,Image::RGB);
			for(int i=0; i<8; i++) {
				tlock.pix(i, 0, Color(CTB(BitsTlock::COMMAND_R[i]), CTB(BitsTlock::COMMAND_G[i]), CTB(BitsTlock::COMMAND_B[i])) );
			}
			tlock.pix(8, 0, Color(CTB(0), CTB(0), CTB(1)));
			tlock.pix(9, 0, Color(CTB(6), CTB(12), CTB(0)));
			tlock.pix(10, 0, Color(CTB(0), CTB(0), CTB(0)));
			tlock.pix(11, 0, Color(CTB(0), CTB(0), CTB(0)));
		}
	}

	BitsResponseBox::BitsResponseBox()
	{
		is_initialized = false;
		initialize();
	}
	BitsResponseBox::BitsResponseBox(unsigned long BoxType)
	{
		is_initialized = false;
		initialize();
		open(BoxType);
	}
	BitsResponseBox::~BitsResponseBox()
	{
		close();
	}
	void BitsResponseBox::buzzer(unsigned long Period, unsigned long Frequency)
	{
		bitsCbboxBuzzer(Period, Frequency);  /* Buzz CB1 buzzer
	}
	void BitsResponseBox::sendback()
	{
		bitsCbboxSendback();                 /* Ask explicitly for switch settings
	}

	int  changeA;
	int  switchA;
	int  changeB;
	int  switchB;
	int  changeC;
	int  switchC;
	long counter;

	void BitsResponseBox::reset()
	{
		bitsResetTimer();
	}
	void BitsResponseBox::check()
	{
		bitsCbboxCheck(&C);                  /* Check if any switches have changed
	}
	void BitsResponseBox::flush()
	{
		bitsCbboxFlush();                            /* Flush the input buffer
	}

	void BitsResponseBox::open(unsigned long BoxType)
	{
		DWORD res = bitsCbboxOpen(BoxType);
		std::cout << res << std::endl;
	}
	void BitsResponseBox::close()
	{
		bitsCbboxClose();                            /* Reset interrupt vectors
	}
	*/



}


}	/*	<- namespace Psycholops 	*/


