/*
 *  psychlops_devices_nidaqmxbase.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/04/14 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#include "../../core/ApplicationInterfaces/psychlops_code_exception.h"
#include "../../core/devices/psychlops_io_hid.h"
#include "../../core/graphic/psychlops_g_canvas.h"
#include "../../core/math/psychlops_math.h"

#include "psychlops_devices_util.h"


namespace Psychlops {

namespace Devices {

	double through(double x) {
		return x;
	}


	DisplayFlash::~DisplayFlash() { ; }
	double DisplayFlash::getLatency() { return 0; }
	double DisplayFlash::getJitterSD() { return 0; }
	Interval DisplayFlash::getRange() { Interval i; return 0<=i<=5; }
	bool DisplayFlash::isAnalog() { return false; }
	double DisplayFlash::get() { return 0; }
	void DisplayFlash::put(double v) { Color col(v); draw(col);; }


	OscillationSimulator::OscillationSimulator()
	{
		normalize = &through;
		waveform = &sin;
	}
	OscillationSimulator::OscillationSimulator(double freq, double amp, double phase)
	{
		normalize = &through;
		waveform = &sin;
		frequency = freq;
		amplitude = amp;
		internal_phase = phase;
	}
	double OscillationSimulator::get()
	{
		internal_phase += frequency;
		return amplitude*waveform(internal_phase*2*PI);
	}


	const double ONESEC = 2.0*PI/1000.0;
	ClockOscillator::ClockOscillator()
	{
		normalize = &through;
		waveform = &sin;
	}
	ClockOscillator::ClockOscillator(double freq, double amp, double phase)
	{
		normalize = &through;
		waveform = &sin;
		frequency = freq;
		amplitude = amp;
		internal_phase = phase;
	}
	double ClockOscillator::get()
	{
		clock.update();
		return amplitude*waveform(frequency*clock.at_msec()*ONESEC+internal_phase);
	}



	MouseX::MouseX(const double fac) : factor(fac) {
		normalize = &through;
	}
	MouseX::MouseX() {
		normalize = &through;
		if(Drawable::prime_is_a_canvas()) factor=1.0/Drawable::prime->getWidth();
		else factor=1;
	}
	MouseX::~MouseX() {
	}
	double MouseX::get() {
		return normalize(factor*Mouse::uniX);
	}
}


}	/*	<- namespace Psycholops 	*/


