#include <psychlops.h>
using namespace Psychlops;

double dcX,dcY, rectcol;
double rectsize=80;
int display_cursor=1, in_rect=0;
Psychlops::Rectangle rect(rectsize*2,rectsize*2);
Psychlops::Range rngx,rngy;

void psychlops_main() {
	
	Canvas display(Canvas::fullscreen);
	display.clear(Color::gray);
	AppState::setThreadPriority(AppState::HIGH);
	rect.centering();
	dcX= display.getHcenter();
	dcY= display.getVcenter();
	Input::refresh();
	
	//Move mouse cursor to the center 
	Mouse::x=dcX;
	Mouse::y=dcY;
	
	while(!Input::get(Keyboard::spc)){
		display.clear(Color::gray);
		rectcol=0.25;
		//set current rect area
		rect.getHcenter()-rectsize<rngx<rect.getHcenter()+rectsize;
		rect.getVcenter()-rectsize<rngy<rect.getVcenter()+rectsize;
	
		if(display_cursor)Mouse::show();
			else Mouse::hide();
		
		if(Input::get(Mouse::right, Mouse::pushed))display_cursor=1-display_cursor;	
		if(in_rect){
			rect.centering(Mouse::x, Mouse::y);
			rectcol=1.0;
		}
			
		rect.draw(rectcol);
		display.flip();
		if(Input::get(Mouse::left, Mouse::pushed)){
				if (rngx.includes(Mouse::x) && rngy.includes(Mouse::y))in_rect=1;
					else in_rect=0;
		}
		if(Input::get(Mouse::left, Mouse::released))	{
				if (rngx.includes(Mouse::x) && rngy.includes(Mouse::y))in_rect=0;
		}
	}
}
