/*
 *  psychlops_app_state_Win32.h
 *  Psychlops Standard Library (Win32)
 *
 *  Last Modified 2007/06/22 by Kenchi HOSOKAWA
 *  (C) 2006 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */


#ifndef HEADER_PSYCHLOPS_APP_STATE_WIN32
#define HEADER_PSYCHLOPS_APP_STATE_WIN32


#include <windows.h>

namespace Psychlops {


	class APIInputProperties;
	class APICanvasProperties;
	class APICanvasPropertiesWindow;
	void initialize();

	class APIApplicationProperties {
		friend class APIInputProperties;
		friend class APICanvasProperties;
		friend class APICanvasPropertiesWindow;
		friend void initialize();

		private:
		HINSTANCE hInstance_;			//	Handle for Application INSTANCE
		HINSTANCE hPrevInstance_;		//	Legacy of Win16 API
		LPSTR lpCmdLine_;				//	Synonym of arg* of ordinary C-language "main(int argc, char **argv)" function
		int iCmdShow_;					//	To show or not to show when the application starts

		unsigned long thread_state_[5];

		public:
		char* pClassName;
		char* pAppName;

		public:
		HANDLE primaryThread;		// Handle for primary thread of Psychrops process
		DWORD primaryThreadID;		//	ID of primary thread of Psychrops process

		public:
		APIApplicationProperties();
		APIApplicationProperties(HINSTANCE _hInstance, HINSTANCE _hPrevInstance, LPSTR _lpCmdLine, int _iCmdShow);
		~APIApplicationProperties();

		void set(HINSTANCE _hInstance, HINSTANCE _hPrevInstance, LPSTR _lpCmdLine, int _iCmdShow);
		DWORD getPrimaryThreadID();
		static LRESULT CALLBACK proc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
		void setThreadPriority( unsigned int priority );
		int getThreadPriority();

		static void analyzeAPIError();
		static APIApplicationProperties startupinfo;

		private:
		void initialize();
	};


}	/*	<- namespace Psychlops 	*/


#endif
