
#include <psychlops.h>
using namespace Psychlops;


void loadImageSequence(Image *target, int number, const std::string &base_path, const std::string &prefix, const std::string &postfix)
{
	std::stringstream filename;
	for(int i=0; i<number; i++) {
		filename.str("");
		filename << base_path << "/" << prefix << i << postfix;
		target[i].load(filename.str());
	}
}

void psychlops_main() {
	Canvas window(Canvas::window, Display::secondary);
	//Canvas window(Canvas::fullscreen, Display::secondary);
	//Canvas window(1024,768,32,60.0, Display::secondary);

	Procedure p;

//	Trigger trigger(new Devices::AnalogInput_NIDAQmx);

	Psychlops::Rectangle rect;
	rect.set(200,100).shift(60,100);
	rect.stroke = Stroke(Color::red, 1, Stroke::SOLID);

	Widgets::Button text(L"test");
	text.centering(100,100);
	//window.eventroot.append(text);
	//text.tabStop();

	double v = 0, w = 100;
	Interval rng;
	Independent << v | "dfdsfdsv" | 0<=rng<=4 | 1;
	Independent.append(w).set("another", 0<=rng<=200, 2);
	Widgets::Slider slider(Independent["dfdsfdsv"]), slider2(Independent[1]);
	slider.centering();
	slider2.centering().shift(100,100);

	Image img[5];
	loadImageSequence(img, 5, "D:\\Users\\hskwk\\Documents\\Develop\\Psychlops\\cpp\\trunk\\win32gl\\test\\", "D1_low", ".png");

	img[0] -= img[1];

	Psychlops::Rectangle rect22(100,1000);
	rect22.fill = Color::green;
	rect22.centering();

	Psychlops::Ellipse ell(200, 300);
	ell.shift(300,200);
	ell.resize(100,50);

	Widgets::SelectBox box;
	box.append(L"hpge");
	box.set(200,30);
	box.centering().shift(200,200);

    while(!Keyboard::esc.pushed()){
        window.clear(Color::black);
		img[(int)v].centering().draw();

		text.draw();
		//Events::Focus fo;
		//text.bubble(fo);

		slider.draw();
		slider2.draw();
Display::ellipse(rect22, Color::green);
		box.draw();

window.var(Mouse::uniX,200,200);
window.var(Mouse::uniY,200,240);



		//rect22.centering(Mouse::position).draw();
		//rect22.centering(Mouse::position).draw();
		//rect22.centering(window.mouse()).draw();


int n = 60; // ̖{
int r = 100; // Oډ~̔a
double angle1, angle2;
Psychlops::Point center = window.getCenter(); // p`̒S
for(int i=0; i<n; i++)
{
	angle1 = ( (double)i   /n) *2*PI; // _̊pxvZ
	window.line( center.x + r*cos(angle1), center.y + r*sin(angle1),
	             center.x, center.y,
	             Color::red);
	// p`̒S璸_ւ̑ΓIȈʒuw肵A`
}



        window.flip();
    }

}


/*
#include <psychlops.h>
using namespace Psychlops;

const int StimKind=3;// Stimuluskind:: 1:MDC  2:TDC  3:LDC

#define StimulusWidth 160
#define StimulusHeight 160

#define BlankBeforeStimulus 10
#define StimulusDuration 10
#define r_duration 30

#define LineNumber 200
#define LineWidth 2

#define DotLife 4
#define DotNumber 300
int DotSpeed=1;

const int SIZE_=100;

const int ATT = 2, LAG=2,  ITERATION_PER_A_CONDITION= 10;
const int trial_max = ATT * LAG* ITERATION_PER_A_CONDITION;
int Attribute[ATT]={0, 1};
int SATlag[LAG] = {60,120};//{5, 10, 15, 20, 25, 30, 40, 50, 100, 150};

unsigned int condition[trial_max];
int result[trial_max], resultRT[trial_max];

int condition_att[trial_max], condition_lag[trial_max],number[trial_max];
Psychlops::Rectangle fixation,fixation2,fication3;

Range row, col;
Matrix StimulusFieldA(StimulusWidth, StimulusHeight), StimulusFieldB(StimulusWidth, StimulusHeight), StimulusField(StimulusWidth, StimulusHeight);
Matrix Dot(DotNumber,3);

const int WIDTH=1024, HEIGHT=768;
const int StimLU=WIDTH*0.5-StimulusWidth*0.5, StimRB=HEIGHT*0.5-StimulusHeight*0.5;

double t1, t2;
Clock timer;

//SAT procedure
int maximum;
int SAT_frag = 0, SAT_counter = 0;
int miss_trial[trial_max];
//

void procedure();
void StimulusDraw();

void DrawLDC(int trial_now, int attribute);
void DrawODC(int trial_now, int attribute);
void DrawMDC(int trial_now, int attribute);

void Response(int trial_now);
void Recondtion();
void Data_save();
void EXPabort();

void psychlops_main()
{
	//Canvas display(Canvas::fullscreen);
	Canvas display(Canvas::window);

	display.setGammaValue(2.26459,2.29437,2.12506);//CRT_21gs_090920
	procedure();
}

void procedure() {
	Psychlops::Rectangle blank;
	blank.set(WIDTH,HEIGHT).centering().setColor(Color::black);

	for (int i=0; i<trial_max; i++){condition[ i ] = i;}
	Math::shuffle(condition, trial_max);

	//initialize
	for(int i=0; i<trial_max; i++) {
		number[ i ] = i+1;
		condition_att[ i ] = Attribute[ condition[ i ] %ATT];
		condition_lag[ i ] = SATlag[ (condition[ i ]/ATT) %LAG];

		result[ i ] = -1;
	}

	//for(int i=0; i<trial_max; i++) {std::cout<<condition_att[ i ]<<" "<<condition_lag[ i ]<<std::endl;}

	while(!Keyboard::spc.pushed()) {
		Display::clear();
		Display::message("push space key to start",400,380,Color::white);
		Display::flip();
	}
	StimulusDraw();
}

void StimulusDraw(){
	// Stimuluskind:: 1: MDC 2: ODC 3:LDC

	fixation.set(5,5).centering().setColor(Color::yellow);
	fixation2.set(10,10).centering().setColor(Color::yellow);

	if (SAT_frag ==0){maximum = trial_max;}
	if (SAT_frag ==1){
		maximum = SAT_counter;
		while (!Keyboard::spc.pushed()) {
			Display::clear(0.0);
			Display::message(" Please push spc key to restart",400,380,Color::white);
			fixation.display();Display::flip();
		}
		SAT_counter = 0;
	}

	std::cout<<"trials = "<<maximum<<std::endl;

	for(int trial_now=0; trial_now<maximum; trial_now++){

		if (Keyboard::esc.pushed()){EXPabort();}

		//Blank frame
		for(int i=0; i<BlankBeforeStimulus; i++) {
			Input::refresh();
			//Keyboard::pad1.pushed();	Keyboard::pad3.pushed();
			Display::clear(0.0);fixation.display();Display::flip();
		}

		//DrawStimulus
		if (SAT_frag ==0){
			switch(StimKind){
				case 1: DrawMDC(trial_now, condition_att[trial_now]); break;
				case 2: DrawODC(trial_now, condition_att[trial_now]); break;
				case 3: DrawLDC(trial_now, condition_att[trial_now]); break;
			}
			for(int i=0; i<condition_lag[trial_now]; i++) {
				//Keyboard::pad1.pushed();	Keyboard::pad3.pushed();
				Display::clear(0.0);fixation.display();Display::flip();
			}
		}
		else {
			switch(StimKind){
				case 1: DrawMDC(trial_now, condition_att[ miss_trial[trial_now] ]); break;
				case 2: DrawODC(trial_now, condition_att[ miss_trial[trial_now] ]); break;
				case 3: DrawLDC(trial_now, condition_att[ miss_trial[trial_now] ]); break;
			}
			for(int i=0; i<condition_lag[ miss_trial[trial_now] ]; i++) {
				//Keyboard::pad1.pushed();	Keyboard::pad3.pushed();
				Display::clear(0.0);fixation.display();Display::flip();
			}
		}

		Response(trial_now);
	}

	//f[^玸ss
	for(int trial_now=0; trial_now<trial_max; trial_now++){
		SAT_frag = 0;
		std::cout<<result[trial_now]<<std::endl;
		if (result[trial_now] == -1){SAT_frag =1;break;}
	}

	std::cout<<"SAT_frag = "<<SAT_frag<<std::endl;
	if (SAT_frag == 0){Data_save();}
	else {Keyboard::pad5.pushed();Recondtion();}
}

void Response(int trial_now){

	//Keyboard::pad1.pushed();	Keyboard::pad3.pushed();
	Input::refresh();


	for(int i=0; i<r_duration; i++) {
		Display::clear(0.0);fixation2.display();Display::flip();

		if (Keyboard::esc.pushed()){EXPabort();}

		if (SAT_frag ==0){
			if( Keyboard::pad1.pushed())  {result[trial_now]= (1-condition_att[trial_now]); break;}// white or Leftup response
			if( Keyboard::pad3.pushed())  {result[trial_now]= (condition_att[trial_now]);break;}// black or Rightup response
		}
		if (SAT_frag ==1){
			result[ miss_trial[trial_now] ] = -1;
			if( Keyboard::pad1.pushed())  {result[ miss_trial[trial_now] ]= (1-condition_att[ miss_trial[trial_now] ]); break;}// white or Leftup response
			if( Keyboard::pad3.pushed())  {result[ miss_trial[trial_now] ]= (condition_att[ miss_trial[trial_now] ]);break;}// black or Rightup response
		}

	}
	if (SAT_frag ==0){std::cout<<trial_now<<" condition  = "<<condition_att[trial_now]<<" result = "<<result[trial_now]<<std::endl;}
	if (SAT_frag ==1){std::cout<<miss_trial[trial_now]<<" condition  = "<<condition_att[miss_trial[trial_now]]<<" result = "<<result[miss_trial[trial_now]]<<std::endl;}

	if( result[trial_now] == -1 && SAT_frag ==0){
		miss_trial[SAT_counter] =trial_now;SAT_counter+=1;
	}
	if( result[ miss_trial[trial_now] ] == -1 && SAT_frag ==1){
		miss_trial[SAT_counter] =miss_trial[trial_now];SAT_counter+=1;
	}

	std::cout<<"SAT_counter = "<<SAT_counter<<std::endl;
}

void Recondtion(){
	const int tmp_n= SAT_counter;
	int recondition[tmp_n];

	for (int i=0; i<SAT_counter; i++){recondition[ i ] = miss_trial[ i ];}
	if(SAT_counter >0){Math::shuffle(recondition, SAT_counter);}

	for (int i=0; i<SAT_counter; i++){miss_trial[ i ]= recondition[ i ];}

	StimulusDraw();
}

void Data_save(){

	Input::refresh();
	switch(StimKind){
		case 1:	Data::savearray("MDCline_att_%TIME_.txt", "Num\tDirection\tLag\tjudge", trial_max, number, condition_att, condition_lag,result);break;
		case 2:	Data::savearray("ODCline_att_%TIME_.txt", "Num\tOrientation\tLag\tjudge", trial_max, number, condition_att, condition_lag, result);break;
		case 3:	Data::savearray("LDCline_att_%TIME_.txt", "Num\tLuminance\tLag\tjudge", trial_max, number, condition_att, condition_lag,result);break;
	}

	while(!Keyboard::spc.pushed()) {
		Display::clear();
		Display::message("thanks",500,380,Color::white);
		Display::flip();
	}
}


void DrawLDC(int trial_now, int attribute){
	int XS, YS, XE, YE;
	int i,j;

	StimulusField=StimulusFieldA;

	//Init Stimulus
	for (i=1; i<LineNumber+1; i++){
		Dot(i,1)=1+rand()%(StimulusWidth-LineWidth);
		Dot(i,2)=1+rand()%(StimulusHeight-LineWidth);
		Dot(i,3)=DotLife;
	}

	//Draw Stimulus
	int Direction;
	Direction=(rand()%2)*2-1;

	for(i=0; i<StimulusDuration; i++){
		Display::clear();
		//fixation.display();

		for (j=1; j<LineNumber+1; j++){
			XS=Dot(j,1)-1; // Convert to Origin (0,0)
			YS=Dot(j,2)-1; // Convert to Origin (0,0)

			int hv;
			hv=(rand()%2)*2-1;
			if(StimulusField(XS+1, YS+1)==condition_att[trial_now]){
				if (hv==1){	XE=XS+LineWidth; YE=YS;}
				else {XS=XS-LineWidth; YS=YS-LineWidth; XE=XS; YE=YS-LineWidth;}
				Display::line(XS+StimLU, YS+StimRB, XE+StimLU, YE+StimRB, 0.9);
			}
			else{
				if (hv==1){XS=XS-LineWidth; YS=YS-LineWidth; XE=XS+LineWidth; YE=YS;}
				else {XE=XS; YE=YS-LineWidth;}
				Display::line(XS+StimLU, YS+StimRB, XE+StimLU, YE+StimRB, 0.1);
			}

			Dot(j,3)--;

			if(Dot(j,3)<1){
				Dot(j,1)=1+rand()%(StimulusWidth-LineWidth);
				Dot(j,2)=1+rand()%(StimulusHeight-LineWidth);
				Dot(j,3)=DotLife;
			}

		}

		Display::flip();
	}

}


void DrawODC(int trial_now, int attribute){
	int XS, YS, XE, YE;
	int i,j;

	//Init Stimulus
	for (i=1; i<LineNumber+1; i++){
		Dot(i,1)=1+rand()%(StimulusWidth-LineWidth);
		Dot(i,2)=1+rand()%(StimulusHeight-LineWidth);
		Dot(i,3)=DotLife;
	}

	//Draw Stimulus
	int Direction;
	Direction=(rand()%2)*2-1;

	for(i=0; i<StimulusDuration; i++){
		Display::clear();
		//fixation.display();

		for (j=1; j<LineNumber+1; j++){
			XS=Dot(j,1)-1; // Convert to Origin (0,0)
			YS=Dot(j,2)-1; // Convert to Origin (0,0)

			if(StimulusField(XS+1, YS+1)==condition_att[trial_now]){
				XE=XS+Direction*LineWidth; YE=YS+Direction*LineWidth;
			}
			else{
				XE=XS+Direction*LineWidth; YE=YS-Direction*LineWidth;
			}

			Display::line(XS+StimLU, YS+StimRB, XE+StimLU, YE+StimRB, 1.0);
			Dot(j,3)--;

			if(Dot(j,3)<1){
				///*LifeTime Event
				Dot(j,1)=1+rand()%(StimulusWidth-LineWidth);
				Dot(j,2)=1+rand()%(StimulusHeight-LineWidth);
				Dot(j,3)=DotLife;
			}
		}
		Display::flip();
	}

}


void DrawMDC(int trial_now, int attribute){

	int i,j;
	//Set StimulusField

    //Init Stimulus
	int X, Y;
	for (i=1; i<DotNumber+1; i++){
		Dot(i,1)=1+rand()%(StimulusWidth);
		Dot(i,2)=1+rand()%(StimulusHeight);
		Dot(i,3)=DotLife;
	}


	//Draw Stimulus
	int orientation =1;
	DotSpeed=1;

	for(i=0; i<StimulusDuration; i++){
		Display::clear();

		//Draw Signal
		for (j=1; j<DotNumber+1; j++){
			X=Dot(j,1)-1; // Convert to Origin (0,0)
			Y=Dot(j,2)-1; // Convert to Origin (0,0)

			Display::pix(X+StimLU, Y+StimRB,1.0);
			//Display::pix(X+StimLU, Y+StimRB,1.0);
			Dot(j,3)--;

			if(Dot(j,3)>1){
				switch(condition_att[trial_now]){
					case 0 : Dot(j,1)-=DotSpeed; Dot(j,2)-=DotSpeed;break;
					case 1 : Dot(j,1)+=DotSpeed; Dot(j,2)+=DotSpeed;break;
				}

				//* Validation of Stimulus area
				if(Dot(j,1)>StimulusWidth){
					//if(orientation==1){Dot(j,1)-=StimulusWidth*0.5;}
					if(orientation==1){Dot(j,1)-=StimulusWidth*0.5;}
					else{Dot(j,1)-=StimulusWidth;}
				}
				if(Dot(j,1)<1){
					if(orientation==1){Dot(j,1)+=StimulusWidth*0.5;}
					else{Dot(j,1)+=StimulusWidth;}
				}
				if(Dot(j,2)>StimulusWidth){
					if(orientation==1){Dot(j,2)-=StimulusHeight;}
					else{Dot(j,2)-=StimulusHeight*0.5;}
				}
				if(Dot(j,2)<1){
					if(orientation==1){Dot(j,2)+=StimulusHeight;}
					else{Dot(j,2)+=StimulusHeight*0.5;}
				}

			}
			else{
				///*LifeTime Event
				Dot(j,1)=1+rand()%(StimulusWidth);
				Dot(j,2)=1+rand()%(StimulusHeight);//Math::random(StimHeight);
				Dot(j,3)=DotLife;
			}
		}
		Display::flip();
	}
}
void EXPabort(){
	while(!Keyboard::pad5.pushed()){
		Display::clear();
		Display::message("Experiment is terminated. push 5 key to quit",500,380,Color::white);
		Display::flip();
	}
	exit(0);
}
*/
