#include <psychlops.h>
using namespace Psychlops;

void psychlops_main() {
	Canvas d(Canvas::window);

	Image img(100,100, Image::RGBA), ovalimg(200,200,Image::RGBA), copyimg, mtximg(100,100);
	Image partialimg;
	Psychlops::Rectangle rect(50,50);

	Range row,col;
	Matrix mtx_r(100,100), mtx_g(100,100), mtx_b(100,100);
	mtx_b = 0.2;
	mtx_g(1<=row<=50,1<=col<=50) = 0.6;
	mtx_r(1,1) = 1.0;
	mtximg.from(mtx_r, mtx_g, mtx_b);

	ovalimg.clear(Color(0.0,0.0,0.0,0.1));
	ovalimg.shift(150,150);
	ovalimg.oval(rect.dup().shift(-50,-50).resize(200,200), Color(0.1,0.3,0.1,0.3));
	ovalimg.oval(rect.shift(50,50), Color(0.5,0.2,0.8,0.5));
	ovalimg.oval(rect.shift(50,50).resize(100,50), Color(0.5,0.2,0.8));
	ovalimg.oval(rect.shift(50,50).resize(100,200), Color(0.8,0.2,0.1,0.4));

	copyimg.from(ovalimg);
	copyimg.shift(-100,-100).rect(rect.set(50,50).centering(copyimg), Color::red);
	ovalimg.convert(Image::RGB);

	copyimg.cache();
	ovalimg.cache();

	img.clear(Color(0.5,0.5,0.5,0.5));
	img.rect(rect.set(50,100), Color(0.5));
	img.line(-25, 50, 50, -25, Color::black);
	img.line(50, -25, 125, 50, Color::black);
	img.line(125, 50, 50, 125, Color::black);
	img.line(50, 125, -25, 50, Color::black);
	img.line(50, 50, -1, -1, Color::white);
	img.line(50, 50, 0, 23, Color::red);
	img.line(50, 50, 0, 25, Color::red);
	img.line(50, 50, 0, 32, Color::red);
	img.line(50, 50, 0, 50, Color::white);
	img.line(50, 50, 0, 52, Color(1.0, 0.5, 0.0));
	img.line(50, 50, 0, 75, Color(1.0, 0.5, 0.0));
	img.line(50, 50, 0, 80, Color(1.0, 0.5, 0.0));
	img.line(50, 50, 0, 100, Color::white);
	img.line(50, 50, 15, 100, Color::yellow);
	img.line(50, 50, 25, 100, Color::yellow);
	img.line(50, 50, 30, 100, Color::yellow);
	img.line(50, 50, 50, 100, Color::white);
	img.line(50, 50, 70, 100, Color::green);
	img.line(50, 50, 75, 100, Color::green);
	img.line(50, 50, 85, 100, Color::green);
	img.line(50, 50, 100, 100, Color::white);
	img.line(50, 50, 100, 85, Color::cyan);
	img.line(50, 50, 100, 75, Color::cyan);
	img.line(50, 50, 100, 65, Color::cyan);
	img.line(50, 50, 100, 50, Color::white);
	img.line(50, 50, 100, 45, Color::blue);
	img.line(50, 50, 100, 25, Color::blue);
	img.line(50, 50, 100, 15, Color::blue);
	img.line(50, 50, 100, 0, Color::white);
	img.line(50, 50, 88, 0, Color(0.5,0.0,1.0));
	img.line(50, 50, 75, 0, Color(0.5,0.0,1.0));
	img.line(50, 50, 60, 0, Color(0.5,0.0,1.0));
	img.line(50, 50, 50, 0, Color::white);
	img.line(50, 50, 45, 0, Color::magenta);
	img.line(50, 50, 25, 0, Color::magenta);
	img.line(50, 50, 11, 0, Color::magenta);
	img.line( 0,  0, 99,  0, Color::red);
	img.line(99,  0, 99, 99, Color::blue);
	img.line(99, 99,  0, 99, Color::green);
	img.line( 0, 99,  0,  0, Color::yellow);
	img.cache();


	//img.save("hoge.png");
	Psychlops::Rectangle targetarea(0,0,98,98), sourcearea(100,100);
	targetarea.shift(400,200);

	while(!Input::get(Keyboard::esc)){
		d.clear(0.5);
		mtximg.draw();
		ovalimg.draw();
		img.draw(Mouse::x, Mouse::y);
		copyimg.draw();
		d.image(img, targetarea, sourcearea);
		d.flip(1);
	}
}
