#include <psychlops.h>
using namespace Psychlops;	

double x=0,y=0, dX,dY;
int code, oldcode;
Psychlops::Rectangle rect(60,60), rect2(60,60);

void psychlops_main() {
	
	Canvas display(Canvas::fullscreen);
	display.clear(Color::gray);
	rect.centering();
	dX= display.getHcenter();
	dY= display.getVcenter();
	x=dX;
	y=dY;
	
	Input::refresh();
	
	while(!Input::get(Keyboard::spc)){
		oldcode=code;
		code=-1;
		
		//state "pushed" Demo
		if(Input::get(Keyboard::c, Keyboard::pushed))code=0; //centering
		
		if(Input::get(Keyboard::a, Keyboard::pushed))code=1;
		else if(Input::get(Keyboard::s, Keyboard::pushed))code=2;
	
		//state "pressed" Demo
		if(Input::get(Keyboard::z, Keyboard::pressed))code=3;
		else if(Input::get(Keyboard::x, Keyboard::pressed))code=4;
		
		//state "pressed" and "released" Demo
		if(Input::get(Keyboard::q, Keyboard::pressed)){
			code=5;
		   if(oldcode==5||oldcode==7)code=7;
		}
		else if(Input::get(Keyboard::w, Keyboard::pressed)){
		   code=6;
		   if(oldcode==6||oldcode==8)code=8;
		}
		if(Input::get(Keyboard::q, Keyboard::released))code=9;
		else if(Input::get(Keyboard::w, Keyboard::released))code=9;
		
		switch(code){
			case -1: break;
			case 0: rect.centering(); break;
			case 1: rect.shift(-1,0); break;
			case 2: rect.shift(1,0); break;
			case 3: rect.shift(-1,0); break;
			case 4: rect.shift(1,0); break;
			case 5: x=ceil(rect.getHcenter()); y=ceil(rect.getVcenter()); rect.shift(-1,0);break;
			case 6: x=ceil(rect.getHcenter()); y=ceil(rect.getVcenter()); rect.shift(1,0);break;
			case 7: rect.shift(-1,0); break;
			case 8: rect.shift(1,0); break;
			case 9: rect.centering(x,y); break;
		}
		display.clear(Color::gray);
		
		//Show variables 
		display.message("KeyState:", dX-100, dY-120, Color::green);
		display.var(code, dX,dY-120, Color::green);
		display.message("X:", dX-100, dY-100, Color::white); 
		display.var(ceil(rect.getHcenter()),dX,dY-100, Color::white);
		display.message("Y:", dX-100, dY-80, Color::white);
		display.var(ceil(rect.getVcenter()),dX,dY-80, Color::white);
		
		if(code>5){ 
					rect2.centering(x,y).draw(Psychlops::Color(0.75,0.75,0.75)); 
					rect.draw(Psychlops::Color(1.0,1.0,1.0,0.25));
			}
		else rect.draw(1.0);
		display.flip();
	}
}
