/*
 *  psychlops_figure_visualization.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/10/05 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_FIGURE_VISUALIZATION
#define HEADER_PSYCHLOPS_FIGURE_VISUALIZATION

#include "../../../core/graphic/psychlops_g_fundamental.h"
#include "../../../psychlops_core.h"
#include <deque>


namespace Psychlops {
namespace Figures {


	class XYPlot : public Rectangle {
	protected:
		double Xpix(double x);
		double Ypix(double y);
	public:
		double x_min, x_max, y_min, y_max;
		XYPlot();
		XYPlot(double wid, double hei);
		XYPlot(double wid, double hei, Interval x_a, Interval y_a);
		XYPlot& set(double wid, double hei);
		XYPlot& set(double wid, double hei, Interval x_a, Interval y_a);
		XYPlot& setInterval(Interval x_a, Interval y_a);
	};

	class FunctionalPlot : public XYPlot {
	public:
		typedef double (*OneDimFun)(double);
		std::deque< OneDimFun > functions;
		FunctionalPlot();
		FunctionalPlot(double wid, double hei);
		FunctionalPlot& set(double wid, double hei);
		FunctionalPlot& append(OneDimFun fun);
		FunctionalPlot& draw(Drawable &target = *Drawable::prime);
	};

	class LinePlot : public XYPlot {
	protected:
		std::deque< std::deque<double> > table;
	public:
		LinePlot();
		LinePlot(double wid, double hei);
		LinePlot& set(double wid, double hei);
		void setTableSize(int n_seq, int n_elems);
		void push_pop(double x, int seq_index=0);
		LinePlot& draw(Drawable &target = *Drawable::prime);
	};


}	/*	<- namespace Figure 	*/
}	/*	<- namespace Psycholops 	*/


#endif

