<?php
/**
 *
 * PukiWiki - Yet another WikiWikiWeb clone.
 *
 * backup.php
 *
 * Хååפ
 *
 * @package org.pukiwiki
 * @access  public
 * @author  
 * @create  
 * @version $Id: backup.php,v 1.13 2003/06/05 05:03:10 arino Exp $
 **/

/**
 * make_backup
 * Хååפ
 *
 * @access    public
 * @param     String    $page        ڡ̾
 * @param     Boolean   $delete      TRUE:Хååפ
 *
 * @return    Void
 */
function make_backup($page,$delete = FALSE)
{
	global $splitter,$cycle,$maxage;
	global $do_backup,$del_backup;
	
	if (!$do_backup)
	{
		return;
	}
	
	if ($del_backup and $delete)
	{
		backup_delete($page);
		return;
	}
	
	if (!is_page($page))
	{
		return;
	}
	
	$arystrout = array();
	
	$lastmod = backup_get_filetime($page);
	if (($lastmod == 0) or (UTIME - $lastmod) > (60 * 60 * $cycle))
	{
		$backups = get_backup($page);
		$count = count($backups) + 1;
		if ($count > $maxage)
		{
			//ľ1ɲäΤǡ(-1)ĶǤΤƤ
			array_splice($backups,0,$count - $maxage);
		}
		
		$strout = '';
		foreach($backups as $age=>$data)
		{
			$strout .= "$splitter {$data['time']}\n";
			$strout .= join('',$data['data']);
		}
		$strout = trim($strout);
		if ($strout != '')
		{
			$strout .= "\n";
		}
		
		$body = "$splitter ".get_filetime($page)."\n".join('',get_source($page));
		$body = preg_replace("/\n*$/","\n",$body);

		$fp = backup_fopen($page,'wb')
			or die_message('cannot write file '.htmlspecialchars($realfilename).'<br />maybe permission is not writable or filename is too long');
		backup_fputs($fp,$strout);
		backup_fputs($fp,$body);
		backup_fclose($fp);
	}
}

/**
 * get_backup
 * Хååפ
 * $age=0ޤϾά : ƤΥХååץǡǼ
 * $age>0          : ꤷΥХååץǡ
 *
 * @access    public
 * @param     String    $page        ڡ̾
 * @param     Integer   $age         Хååפֹ ά
 *
 * @return    String    Хåå($age!=0)
 *            Array     Хååפ($age==0)
 */
function get_backup($page,$age = 0)
{
	global $splitter;
	
	$lines = backup_file($page);
	
	if (!is_array($lines))
	{
		return array();
	}
	
	$_age = 0;
	$retvars = array();
	
	foreach($lines as $line)
	{
		if (preg_match("/^$splitter\s(\d+)$/",trim($line),$match))
		{
			$_age++;
			if ($age > 0 and $_age > $age)
			{
				return $retvars[$age];
			}
			$retvars[$_age]['time'] = $match[1];
		}
		else
		{
			$retvars[$_age]['data'][] = $line;
		}
	}
	
	return $retvars;
}

/**
 * backup_get_filename
 * Хååץե̾
 *
 * @access    private
 * @param     String    $page        ڡ̾
 *
 * @return    String    ХååפΥե̾
 */
function backup_get_filename($page)
{
	return BACKUP_DIR.encode($page).BACKUP_EXT;
}

/**
 * backup_file_exists
 * Хååץե뤬¸ߤ뤫
 *
 * @access    private
 * @param     String    $page        ڡ̾
 *
 * @return    Boolean   TRUE: FALSE:ʤ
 */
function backup_file_exists($page)
{
	return file_exists(backup_get_filename($page));
}

/**
 * backup_get_filetime
 * Хååץեι
 *
 * @access    private
 * @param     String    $page        ڡ̾
 *
 * @return    Integer   եι(GMT)
 */

function backup_get_filetime($page)
{
	return backup_file_exists($page) ?
		filemtime(backup_get_filename($page)) - LOCALZONE :
		0;
}

/**
 * backup_delete
 * Хååץե
 *
 * @access    private
 * @param     String    $page        ڡ̾
 *
 * @return    Boolean   FALSE:
 */
function backup_delete($page)
{
	return unlink(backup_get_filename($page));
}

/////////////////////////////////////////////////

if (function_exists('gzfile'))
{
	// ե륷ƥؿ
	// zlibؿ
	define('BACKUP_EXT','.gz');
	
/**
 * backup_fopen
 * Хååץե򳫤
 *
 * @access    private
 * @param     String    $page        ڡ̾
 * @param     String    $mode        ⡼
 *
 * @return    Boolean   FALSE:
 */
	function backup_fopen($page,$mode)
	{
		return gzopen(backup_get_filename($page),$mode);
	}

/**
 * backup_fputs
 * Хååץե˽񤭹
 *
 * @access    private
 * @param     Integer   $zp          եݥ
 * @param     String    $str         ʸ
 *
 * @return    Boolean   FALSE: ¾:񤭹Хȿ
 */
	function backup_fputs($zp,$str)
	{
		return gzputs($zp,$str);
	}

/**
 * backup_fclose
 * ХååץեĤ
 *
 * @access    private
 * @param     Integer   $zp          եݥ
 *
 * @return    Boolean   FALSE:
 */
	function backup_fclose($zp)
	{
		return gzclose($zp);
	}

/**
 * backup_file
 * ХååץեƤ
 *
 * @access    private
 * @param     String    $page        ڡ̾
 *
 * @return    Array     ե
 */
	function backup_file($page)
	{
		return backup_file_exists($page) ?
			gzfile(backup_get_filename($page)) :
			array();
	}
}
/////////////////////////////////////////////////
else
{
	// ե륷ƥؿ
	define('BACKUP_EXT','.txt');
	
/**
 * backup_fopen
 * Хååץե򳫤
 *
 * @access    private
 * @param     String    $page        ڡ̾
 * @param     String    $mode        ⡼
 *
 * @return    Boolean   FALSE:
 */
	function backup_fopen($page,$mode)
	{
		return fopen(backup_get_filename($page),$mode);
	}

/**
 * backup_fputs
 * Хååץե˽񤭹
 *
 * @access    private
 * @param     Integer   $zp          եݥ
 * @param     String    $str         ʸ
 *
 * @return    Boolean   FALSE: ¾:񤭹Хȿ
 */
	function backup_fputs($zp,$str)
	{
		return fputs($zp,$str);
	}

/**
 * backup_fclose
 * ХååץեĤ
 *
 * @access    private
 * @param     Integer   $zp          եݥ
 *
 * @return    Boolean   FALSE:
 */
	function backup_fclose($zp)
	{
		return fclose($zp);
	}

/**
 * backup_file
 * ХååץեƤ
 *
 * @access    private
 * @param     String    $page        ڡ̾
 *
 * @return    Array     ե
 */
	function backup_file($page)
	{
		return backup_file_exists($page) ?
			file(backup_get_filename($page)) :
			array();
	}
}
?>
